/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.border.Border;

public class ButtonBorder
implements Border {
    private static Border mouseoverBorder;
    private static Border regularBorder;
    private final Image imgBottom;
    private final Image imgBottomLeft;
    private final Image imgBottomRight;
    private final Image imgCenter;
    private final Image imgLeft;
    private final Image imgRight;
    private final Image imgTop;
    private final Image imgTopLeft;
    private final Image imgTopRight;

    private ButtonBorder(boolean mouseOver) {
        if (mouseOver) {
            this.imgTopLeft = ButtonBorder.loadImage("/org/broadinstitute/genee/resources/cmap/butt-sel-top-lef.png");
            this.imgTopRight = ButtonBorder.loadImage("/org/broadinstitute/genee/resources/cmap/butt-sel-top-right.png");
            this.imgBottomLeft = ButtonBorder.loadImage("/org/broadinstitute/genee/resources/cmap/butt-sel-bott-left.png");
            this.imgBottomRight = ButtonBorder.loadImage("/org/broadinstitute/genee/resources/cmap/butt-sel-bott-right.png");
            this.imgLeft = ButtonBorder.loadImage("/org/broadinstitute/genee/resources/cmap/butt-sel-side-left.png");
            this.imgRight = ButtonBorder.loadImage("/org/broadinstitute/genee/resources/cmap/butt-sel-side-right.png");
            this.imgTop = ButtonBorder.loadImage("/org/broadinstitute/genee/resources/cmap/butt-sel-top.png");
            this.imgBottom = ButtonBorder.loadImage("/org/broadinstitute/genee/resources/cmap/butt-sel-bottom.png");
            this.imgCenter = ButtonBorder.loadImage("/org/broadinstitute/genee/resources/cmap/butt-sel-center.png");
        } else {
            this.imgTopLeft = ButtonBorder.loadImage("/org/broadinstitute/genee/resources/cmap/butt-top-lef.png");
            this.imgTopRight = ButtonBorder.loadImage("/org/broadinstitute/genee/resources/cmap/butt-top-right.png");
            this.imgBottomLeft = ButtonBorder.loadImage("/org/broadinstitute/genee/resources/cmap/butt-bott-left.png");
            this.imgBottomRight = ButtonBorder.loadImage("/org/broadinstitute/genee/resources/cmap/butt-bott-right.png");
            this.imgLeft = ButtonBorder.loadImage("/org/broadinstitute/genee/resources/cmap/butt-side-left.png");
            this.imgRight = ButtonBorder.loadImage("/org/broadinstitute/genee/resources/cmap/butt-side-right.png");
            this.imgTop = ButtonBorder.loadImage("/org/broadinstitute/genee/resources/cmap/butt-top.png");
            this.imgBottom = ButtonBorder.loadImage("/org/broadinstitute/genee/resources/cmap/butt-bottom.png");
            this.imgCenter = ButtonBorder.loadImage("/org/broadinstitute/genee/resources/cmap/butt-center.png");
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(11, 11, 11, 11);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        g.drawImage(this.imgTopLeft, x, y, c);
        g.drawImage(this.imgBottomLeft, x, y + height - this.imgBottomLeft.getHeight(c), c);
        g.drawImage(this.imgLeft, x, y + this.imgTopLeft.getHeight(c), this.imgLeft.getWidth(c), height - this.imgTopLeft.getHeight(c) - this.imgBottomLeft.getHeight(c), c);
        g.drawImage(this.imgTopRight, x + width - this.imgTopRight.getWidth(c), y, c);
        g.drawImage(this.imgBottomRight, x + width - this.imgBottomRight.getWidth(c), y + height - this.imgBottomRight.getHeight(c), c);
        g.drawImage(this.imgRight, x + width - this.imgRight.getWidth(c), y + this.imgTopRight.getHeight(c), this.imgRight.getWidth(c), height - this.imgTopRight.getHeight(c) - this.imgBottomRight.getHeight(c), c);
        g.drawImage(this.imgTop, x + this.imgTopLeft.getWidth(c), y, x + width - this.imgTopLeft.getWidth(c) - this.imgTopRight.getWidth(c), this.imgTop.getHeight(c), c);
        g.drawImage(this.imgBottom, x + this.imgBottomLeft.getWidth(c), y + height - this.imgBottom.getHeight(c), x + width - this.imgBottomLeft.getWidth(c) - this.imgBottomRight.getWidth(c), this.imgBottom.getHeight(c), c);
        g.drawImage(this.imgCenter, x + this.imgTopLeft.getWidth(c), y + this.imgTopLeft.getHeight(c), x + width - this.imgTopLeft.getWidth(c) - this.imgTopRight.getWidth(c), y + height - this.imgTopLeft.getHeight(c) - this.imgBottomLeft.getHeight(c), c);
    }

    public static Border createMouseOver() {
        if (null == mouseoverBorder) {
            mouseoverBorder = new ButtonBorder(true);
        }
        return mouseoverBorder;
    }

    public static Border createRegular() {
        if (null == regularBorder) {
            regularBorder = new ButtonBorder(false);
        }
        return regularBorder;
    }

    private static Image loadImage(String url) {
        URL imgURL = ButtonBorder.class.getResource(url);
        return imgURL != null ? new ImageIcon(imgURL).getImage() : null;
    }
}

