/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import com.jidesoft.pane.CollapsiblePane;
import com.jidesoft.pane.CollapsiblePanes;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.broadinstitute.genee.gui.IconManager;

public class CloseableComponentList {
    private CollapsiblePanes collapsiblePanes;
    private ActionListener deleteActionListener;

    public CloseableComponentList(ActionListener deleteActionListener) {
        this.deleteActionListener = deleteActionListener;
        this.collapsiblePanes = new CollapsiblePanes();
        this.collapsiblePanes.setGap(0);
        this.collapsiblePanes.setBackground(UIManager.getColor("Panel.background"));
        this.collapsiblePanes.addExpansion();
    }

    public void add(JComponent content, String name) {
        MyCollapsiblePane pane = new MyCollapsiblePane(content, name);
        this.collapsiblePanes.add((Component)((Object)pane));
        this.setIndices();
        int cc = this.collapsiblePanes.getComponentCount();
        for (int i = 0; i < cc; ++i) {
            Component c = this.collapsiblePanes.getComponent(i);
            if (!(c instanceof MyCollapsiblePane) || c == pane) continue;
            try {
                ((CollapsiblePane)c).setCollapsed(true);
                continue;
            }
            catch (PropertyVetoException e1) {
                e1.printStackTrace();
            }
        }
    }

    public JComponent[] getComponents() {
        ArrayList<JComponent> list = new ArrayList<JComponent>();
        int cc = this.collapsiblePanes.getComponentCount();
        for (int i = 0; i < cc; ++i) {
            Component c = this.collapsiblePanes.getComponent(i);
            if (!(c instanceof MyCollapsiblePane)) continue;
            list.add(((MyCollapsiblePane)((Object)c)).getContentPane());
        }
        return list.toArray(new JComponent[0]);
    }

    public JComponent getJComponent() {
        return this.collapsiblePanes;
    }

    private void setIndices() {
        int index = 0;
        int cc = this.collapsiblePanes.getComponentCount();
        for (int i = 0; i < cc; ++i) {
            Component c = this.collapsiblePanes.getComponent(i);
            if (!(c instanceof MyCollapsiblePane)) continue;
            ((MyCollapsiblePane)((Object)c)).setIndex(index++);
        }
    }

    private class MyCollapsiblePane
    extends CollapsiblePane {
        private JPanel panel;
        private JButton deleteButton;

        private MyCollapsiblePane(final JComponent content, String name) {
            content.setName(name);
            this.panel = new JPanel(new FlowLayout(0));
            this.panel.setOpaque(false);
            this.deleteButton = new JButton(IconManager.loadIcon("16x16/14763.delete.gif"));
            this.deleteButton.setToolTipText("Delete");
            ActionListener deleteButtonActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CloseableComponentList.this.collapsiblePanes.remove((Component)((Object)MyCollapsiblePane.this));
                    CloseableComponentList.this.collapsiblePanes.revalidate();
                    CloseableComponentList.this.setIndices();
                    CloseableComponentList.this.deleteActionListener.actionPerformed(new ActionEvent(content, e.getID(), e.getActionCommand()));
                }
            };
            this.deleteButton.addActionListener(deleteButtonActionListener);
            this.panel.add(this.deleteButton);
            this.setTitleComponent(this.panel);
            this.setTitleLabelGap(0);
            this.setSteps(1);
            this.setContentPane(content);
            this.setTitle(content.getName());
        }

        public void setIndex(int index) {
            this.setTitle(this.getContentPane().getName() + " " + (index + 1));
        }
    }
}

