/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import com.google.common.base.Supplier;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.broadinstitute.genee.gui.CloseablePanel;
import org.broadinstitute.genee.gui.UIUtil;

public class CloseablePanelList
extends JPanel {
    private CellConstraints cc;
    private FormLayout formLayout = new FormLayout("p", "");

    public CloseablePanelList() {
        this.setLayout((LayoutManager)this.formLayout);
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.cc = new CellConstraints();
    }

    public void addCloseable(final Supplier<Component> c) {
        this.formLayout.appendRow(UIUtil.decodeRowSpec("p"));
        final CloseablePanel closeablePanel = new CloseablePanel((Component)c.get(), c.toString());
        ActionListener deleteActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CloseablePanelList.this.remove(closeablePanel.getComponent());
                CloseablePanelList.this.notifyDeleted((Supplier<Component>)c);
                CloseablePanelList.this.revalidate();
                CloseablePanelList.this.repaint();
            }
        };
        if (c instanceof CloseButtonSupplier) {
            CloseButtonSupplier s = (CloseButtonSupplier)c;
            s.getCloseButton().addActionListener(deleteActionListener);
            closeablePanel.getCloseButton().setVisible(false);
        } else {
            closeablePanel.addCloseActionListener(deleteActionListener);
        }
        this.add(closeablePanel.getComponent(), this.cc.xy(1, this.formLayout.getRowCount()));
        this.notifyAdded(c);
        this.revalidate();
        this.repaint();
    }

    protected void notifyAdded(Supplier<Component> c) {
    }

    protected void notifyDeleted(Supplier<Component> c) {
    }

    public static interface CloseButtonSupplier {
        public JButton getCloseButton();
    }
}

