/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.broadinstitute.genee.category.DefaultVectorColorModel;
import org.broadinstitute.genee.category.VectorColorModel;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.MetadataEditor;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.DefaultHeatMapColorScheme;
import org.broadinstitute.genee.heatmap.HeatMapColorScheme;
import org.broadinstitute.genee.heatmap.LinearGradientChooserPanel;
import org.broadinstitute.genee.math.FloatListStatUtils;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;
import org.jdesktop.swingx.multislider.ThumbDataEvent;
import org.jdesktop.swingx.multislider.ThumbDataListener;

class ContinuousColorEditorPanel
extends JPanel {
    private LinearGradientChooserPanel linearGradientChooserPanel;

    public ContinuousColorEditorPanel(final Vector vector, final VectorColorModel colorModel) {
        HeatMapColorScheme colorScheme = colorModel.getContinuousColorScheme(vector);
        this.linearGradientChooserPanel = new LinearGradientChooserPanel(){

            @Override
            public float max() {
                return VectorUtil.getMax(vector);
            }

            @Override
            public float min() {
                return VectorUtil.getMin(vector);
            }

            @Override
            public float percentile(int p) {
                return FloatListStatUtils.percentile(VectorUtil.asFloatList(vector), p);
            }
        };
        this.linearGradientChooserPanel.setHeatMapColorScheme(colorScheme);
        ThumbDataListener tdl = new ThumbDataListener(){

            public void positionChanged(ThumbDataEvent e) {
                this.updateColorScheme();
            }

            public void thumbAdded(ThumbDataEvent e) {
                this.updateColorScheme();
            }

            public void thumbRemoved(ThumbDataEvent e) {
                this.updateColorScheme();
            }

            public void valueChanged(ThumbDataEvent e) {
                this.updateColorScheme();
            }

            private void updateColorScheme() {
                HeatMapColorScheme colorScheme = colorModel.getContinuousColorScheme(vector);
                if (colorScheme != null && ContinuousColorEditorPanel.this.linearGradientChooserPanel.isEnabled()) {
                    LinearGradientChooserPanel.FractionColorPair[] pairs = ContinuousColorEditorPanel.this.linearGradientChooserPanel.getFractionColorPairs();
                    float[] fractions = new float[pairs.length];
                    Color[] colors = new Color[pairs.length];
                    for (int i = 0; i < fractions.length; ++i) {
                        fractions[i] = pairs[i].getFraction();
                        colors[i] = pairs[i].getColor();
                    }
                    colorScheme.setColors(colors, fractions);
                }
            }
        };
        this.linearGradientChooserPanel.addThumbDataListener(tdl);
        JButton resetBtn = new JButton("Reset");
        resetBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                float min = VectorUtil.getMin(vector);
                float max = VectorUtil.getMax(vector);
                HeatMapColorScheme colorScheme = colorModel.getContinuousColorScheme(vector);
                colorScheme.setRelative(false);
                colorScheme.setGlobalMin(min);
                colorScheme.setGlobalMax(max);
                if (min < 0.0f && max > 0.0f) {
                    float span = max - min;
                    float zeroFraction = (0.0f - min) / span;
                    if (Float.isInfinite(span)) {
                        zeroFraction = 1.0E-5f;
                    }
                    colorScheme.setColors(DefaultVectorColorModel.DEFAULT_CONTINUOUS_COLORS, new float[]{0.0f, zeroFraction, 1.0f});
                } else {
                    colorScheme.setColors(DefaultVectorColorModel.DEFAULT_CONTINUOUS_COLORS);
                }
                colorModel.setContinuousColorScheme(vector, colorScheme);
                ContinuousColorEditorPanel.this.linearGradientChooserPanel.setHeatMapColorScheme(colorScheme);
            }
        });
        FormBuilder formBuilder = new FormBuilder();
        formBuilder.addSeparator("Predefined Color Schemes");
        formBuilder.nextRow();
        final JButton saveBtn = new JButton("Save Current Settings\u2026");
        formBuilder.add(saveBtn);
        formBuilder.nextRow();
        final JComboBox saveColorSchemesComboBox = UIUtil.createComboBox();
        this.populateSavedColorSchemes(saveColorSchemesComboBox);
        formBuilder.addLabel("Predefined Schemes:");
        CellConstraints cc = new CellConstraints();
        JPanel predefPanel = new JPanel((LayoutManager)new FormLayout(UIUtil.createColumnStringForFormLayout("left:p", 3), "p"));
        predefPanel.add((Component)saveColorSchemesComboBox, cc.xy(1, 1));
        final JButton loadBtn = new JButton("Load");
        final JButton deleteBtn = new JButton("Delete");
        ActionListener btnListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == saveBtn) {
                    String name = UIUtil.showInputDialog(ContinuousColorEditorPanel.this, "Please enter a name", "");
                    if (name != null) {
                        HeatMapColorScheme colorScheme = colorModel.getContinuousColorScheme(vector);
                        DefaultHeatMapColorScheme.save(colorScheme, name, MetadataEditor.class);
                        saveColorSchemesComboBox.addItem(name);
                    }
                    ContinuousColorEditorPanel.this.populateSavedColorSchemes(saveColorSchemesComboBox);
                } else if (e.getSource() == loadBtn) {
                    HeatMapColorScheme cs = DefaultHeatMapColorScheme.load((String)saveColorSchemesComboBox.getSelectedItem(), MetadataEditor.class);
                    colorModel.setContinuousColorScheme(vector, cs);
                    ContinuousColorEditorPanel.this.linearGradientChooserPanel.setHeatMapColorScheme(cs);
                } else if (e.getSource() == deleteBtn) {
                    Preferences prefs = Preferences.userNodeForPackage(MetadataEditor.class);
                    Preferences node = prefs.node("color.scheme");
                    String name = (String)saveColorSchemesComboBox.getSelectedItem();
                    node = node.node(name);
                    try {
                        node.removeNode();
                        saveColorSchemesComboBox.removeItem(name);
                    }
                    catch (BackingStoreException e1) {
                        e1.printStackTrace();
                    }
                }
                loadBtn.setEnabled(saveColorSchemesComboBox.getItemCount() > 0);
                deleteBtn.setEnabled(saveColorSchemesComboBox.getSelectedIndex() > 0);
            }
        };
        saveColorSchemesComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                deleteBtn.setEnabled(saveColorSchemesComboBox.getSelectedIndex() > 0);
            }
        });
        loadBtn.setEnabled(saveColorSchemesComboBox.getItemCount() > 0);
        deleteBtn.setEnabled(false);
        loadBtn.addActionListener(btnListener);
        deleteBtn.addActionListener(btnListener);
        saveBtn.addActionListener(btnListener);
        predefPanel.add((Component)loadBtn, cc.xy(3, 1));
        predefPanel.add((Component)deleteBtn, cc.xy(5, 1));
        formBuilder.add(predefPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)this.linearGradientChooserPanel, "Center");
        formBuilder.nextRow();
        formBuilder.addSpanned(ButtonBarFactory.buildLeftAlignedBar((JButton[])new JButton[]{resetBtn}));
        this.add((Component)formBuilder.getPanel(), "South");
        this.revalidate();
    }

    private void populateSavedColorSchemes(JComboBox saveColorSchemesComboBox) {
        saveColorSchemesComboBox.removeAllItems();
        try {
            String[] keys;
            Preferences prefs = Preferences.userNodeForPackage(MetadataEditor.class);
            Preferences node = prefs.node("color.scheme");
            for (String key : keys = node.childrenNames()) {
                saveColorSchemesComboBox.addItem(key);
            }
        }
        catch (BackingStoreException e1) {
            e1.printStackTrace();
        }
    }
}

