/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEWindow;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.matrix.Comparators;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;

public class CustomSortOrderChooser {
    private JList list;
    private JScrollPane sp;
    private Vector vector;
    private Project project;
    private boolean rows;

    public CustomSortOrderChooser(Project project, boolean rows, Vector v) {
        this.project = project;
        this.rows = rows;
        this.vector = v;
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        this.list = new JList(new DefaultListModel());
        JPanel btnPanel = this.createMoveUpDownPanel();
        p.add(UIUtil.createNoBorderScrollPane(this.list));
        p.add((Component)btnPanel, "West");
        final JCheckBox customSortOrderCheckBox = new JCheckBox("Custom sort order", v.getComparator() instanceof Comparators.CustomSortOrderComparator);
        customSortOrderCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIUtil.setChildrenEnabledRecursively(CustomSortOrderChooser.this.sp, customSortOrderCheckBox.isSelected());
                if (customSortOrderCheckBox.isSelected()) {
                    CustomSortOrderChooser.this.setCustomComparator();
                } else {
                    CustomSortOrderChooser.this.setDefaultComparator();
                }
            }
        });
        this.sp = UIUtil.createNoBorderScrollPane(p);
        UIUtil.setChildrenEnabledRecursively(this.sp, customSortOrderCheckBox.isSelected());
        this.setVector(v);
        GENEEWindow window = Application.getWindowManager().createInputWindow(v.getName() + " custom sort order", null);
        ((Dialog)((Object)window)).setModal(true);
        window.getContentPane().add(this.sp);
        window.getContentPane().add((Component)customSortOrderCheckBox, "North");
        window.pack();
        window.setSize(Math.max(window.getWidth(), 300), window.getHeight());
        window.setVisible(true);
    }

    public Component getComponent() {
        return this.sp;
    }

    public void setCustomComparator() {
        this.vector.setComparator(new Comparators.CustomSortOrderComparator(Arrays.asList(((DefaultListModel)this.list.getModel()).toArray())));
        this.notifyChanged();
    }

    public void setDefaultComparator() {
        this.vector.setComparator(VectorUtil.getDefaultComparator(this.vector.getColumnClass()));
        this.notifyChanged();
    }

    public void setVector(Vector vector) {
        SequencedCollection<Object> iterable;
        this.vector = vector;
        Set values = VectorUtil.getValues(vector);
        if (vector.getComparator() != null) {
            Object[] array = values.toArray();
            Arrays.sort(array, vector.getComparator());
            iterable = Arrays.asList(array);
        } else {
            iterable = new TreeSet(values);
        }
        DefaultListModel model = new DefaultListModel();
        for (Object t : iterable) {
            model.addElement(t);
        }
        this.list.setModel(model);
    }

    protected void notifyChanged() {
        if (this.rows) {
            this.project.setRowSortOrder(this.project.getRowSortKeys());
        } else {
            this.project.setColumnSortOrder(this.project.getColumnSortKeys());
        }
    }

    private JPanel createMoveUpDownPanel() {
        CellConstraints cc = new CellConstraints();
        final JButton moveUpButton = new JButton(new ImageIcon(this.getClass().getResource("/com/jidesoft/list/icons/moveUp.png")));
        moveUpButton.setToolTipText("Move the selected items up");
        final JButton moveDownButton = new JButton(new ImageIcon(this.getClass().getResource("/com/jidesoft/list/icons/moveDown.png")));
        moveDownButton.setToolTipText("Move the selected items down");
        final JButton moveToTopButton = new JButton(new ImageIcon(this.getClass().getResource("/com/jidesoft/list/icons/moveToTop.png")));
        moveToTopButton.setToolTipText("Move the selected items to the top");
        final JButton moveToBottomButton = new JButton(new ImageIcon(this.getClass().getResource("/com/jidesoft/list/icons/moveToBottom.png")));
        moveToBottomButton.setToolTipText("Move the selected items to the bottom");
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object obj;
                DefaultListModel model = (DefaultListModel)CustomSortOrderChooser.this.list.getModel();
                int[] selected = CustomSortOrderChooser.this.list.getSelectedIndices();
                if (selected == null || selected.length == 0) {
                    return;
                }
                Object[] values = CustomSortOrderChooser.this.list.getSelectedValues();
                if (e.getSource() == moveDownButton) {
                    for (int idx : selected) {
                        if (idx >= model.size() - 1) continue;
                        obj = model.remove(idx);
                        model.add(idx + 1, obj);
                    }
                } else if (e.getSource() == moveUpButton) {
                    for (int idx : selected) {
                        if (idx <= 0) continue;
                        obj = model.remove(idx);
                        model.add(idx - 1, obj);
                    }
                } else if (e.getSource() == moveToTopButton) {
                    for (int idx : selected) {
                        if (idx <= 0) continue;
                        obj = model.remove(idx);
                        model.add(0, obj);
                    }
                } else if (e.getSource() == moveToBottomButton) {
                    for (int idx : selected) {
                        if (idx <= 0) continue;
                        obj = model.remove(idx);
                        model.add(model.getSize(), obj);
                    }
                }
                CustomSortOrderChooser.this.setCustomComparator();
                CustomSortOrderChooser.this.list.getSelectionModel().setValueIsAdjusting(true);
                CustomSortOrderChooser.this.list.getSelectionModel().clearSelection();
                block4: for (Object value : values) {
                    ListModel dm = CustomSortOrderChooser.this.list.getModel();
                    int c = dm.getSize();
                    for (int i = 0; i < c; ++i) {
                        if (!value.equals(dm.getElementAt(i))) continue;
                        CustomSortOrderChooser.this.list.getSelectionModel().addSelectionInterval(i, i);
                        continue block4;
                    }
                }
                CustomSortOrderChooser.this.list.getSelectionModel().setValueIsAdjusting(false);
            }
        };
        moveToTopButton.addActionListener(l);
        moveToBottomButton.addActionListener(l);
        moveUpButton.addActionListener(l);
        moveDownButton.addActionListener(l);
        JPanel panel = new JPanel((LayoutManager)new FormLayout("left:p:none, 2px", "15px, p:none, 5px, p:none, 15px, p:none, 5px, p:none, 15px"));
        panel.add((Component)moveToTopButton, cc.xy(1, 2));
        panel.add((Component)moveUpButton, cc.xy(1, 4));
        panel.add((Component)moveDownButton, cc.xy(1, 6));
        panel.add((Component)moveToBottomButton, cc.xy(1, 8));
        return panel;
    }
}

