/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.text.JTextComponent;
import org.broadinstitute.genee.gui.DelimListDataIntelliHints;
import org.broadinstitute.genee.heatmap.AbstractQuickFilterPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorMetadataModelView;

public class DatasetAutocomplete
extends DelimListDataIntelliHints {
    private Project p;
    private AbstractQuickFilterPanel qs;
    private boolean autocompleteRows;
    private Dataset dataset;

    public DatasetAutocomplete(AbstractQuickFilterPanel qs, Dataset dataset, boolean autocompleteRows) {
        super(qs.getTextField());
        this.dataset = dataset;
        this.qs = qs;
        this.autocompleteRows = autocompleteRows;
    }

    public DatasetAutocomplete(AbstractQuickFilterPanel qs, Project p, boolean autocompleteRows) {
        super(qs.getTextField());
        this.p = p;
        this.qs = qs;
        this.autocompleteRows = autocompleteRows;
    }

    public DatasetAutocomplete(JTextComponent tc, Dataset dataset, boolean autocompleteRows) {
        super(tc);
        this.dataset = dataset;
        this.autocompleteRows = autocompleteRows;
    }

    @Override
    public Collection<String> getMatches(String text) {
        String filterColumnName = this.qs != null ? this.qs.getDefaultFilterColumnName() : "All";
        Dataset dataset = this.p != null ? this.p.getOriginalDataset() : this.dataset;
        boolean caseSensitive = this.isCaseSensitive();
        if (!this.autocompleteRows) {
            dataset = DatasetUtil.transposeView(dataset);
        }
        MetadataModel metadata = dataset.getRowMetadata();
        return DatasetAutocomplete.getMatches(text, metadata, caseSensitive, filterColumnName);
    }

    public static Set<String> getMatches(String text, MetadataModel metadata, boolean caseSensitive, String filterColumnName) {
        boolean all = filterColumnName.equals("All");
        if (!all) {
            metadata = new VectorMetadataModelView(metadata.get(metadata.getColumnIndex(filterColumnName)));
        }
        TreeSet<String> matches = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        int rows = metadata.getItemCount();
        for (int rowIndex = 0; rowIndex < rows; ++rowIndex) {
            int cols = metadata.getMetadataCount();
            for (int j = 0; j < cols; ++j) {
                Vector vector;
                String value;
                if (!String.class.isAssignableFrom(metadata.get(j).getColumnClass()) || (value = (String)(vector = metadata.get(j)).getValue(rowIndex)) == null) continue;
                String _value = value;
                if (!caseSensitive) {
                    _value = _value.toLowerCase();
                }
                if (!_value.startsWith(text)) continue;
                matches.add(value);
            }
        }
        return matches;
    }
}

