/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import org.broadinstitute.genee.gui.GelModel;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.stats.Sorting;

public class DefaultGelModel
implements GelModel {
    private Dataset distanceMatrix;
    private int[] ranks;
    private float maxDistance;
    private float minDistance;
    private GelModel rankSupplier;
    private int referenceIndex;

    @Override
    public DefaultGelModel copy() {
        DefaultGelModel model = new DefaultGelModel();
        model.distanceMatrix = this.distanceMatrix;
        model.ranks = this.ranks;
        model.maxDistance = this.maxDistance;
        model.minDistance = this.minDistance;
        model.rankSupplier = this.rankSupplier != null ? this.rankSupplier.copy() : null;
        model.referenceIndex = this.referenceIndex;
        return model;
    }

    @Override
    public float getDistance(int index) {
        return this.distanceMatrix.getValue(this.referenceIndex, index);
    }

    @Override
    public Dataset getDistanceMatrix() {
        return this.distanceMatrix;
    }

    @Override
    public float getMaxDistance() {
        return this.maxDistance;
    }

    @Override
    public float getMinDistance() {
        return this.minDistance;
    }

    @Override
    public float getRankForTheta(int index) {
        return this.rankSupplier != null ? this.rankSupplier.getRankForTheta(index) : (float)this.ranks[index];
    }

    @Override
    public float getActualRank(int index) {
        return this.ranks[index];
    }

    public int getReferenceIndex() {
        return this.referenceIndex;
    }

    @Override
    public GelModel getRankSupplier() {
        return this.rankSupplier;
    }

    public void setDistanceMatrix(Dataset distanceMatrix) {
        this.distanceMatrix = distanceMatrix;
    }

    @Override
    public void setDistanceMatrixRefIndex(int referenceIndex) {
        this.referenceIndex = referenceIndex;
        float[] values = new float[this.distanceMatrix.getColumnCount()];
        this.maxDistance = -3.4028235E38f;
        this.minDistance = Float.MAX_VALUE;
        int ncols = this.distanceMatrix.getColumnCount();
        for (int j = 0; j < ncols; ++j) {
            float val = this.distanceMatrix.getValue(referenceIndex, j);
            this.maxDistance = Math.max(this.maxDistance, val);
            this.minDistance = Math.min(this.minDistance, val);
            values[j] = val;
        }
        int[] indices = Sorting.index(values, true);
        this.ranks = Sorting.rank(indices);
    }

    @Override
    public void setRankSupplier(GelModel rankSupplier) {
        if (this == rankSupplier) {
            rankSupplier = null;
        }
        this.rankSupplier = rankSupplier;
    }

    @Override
    public int size() {
        return this.ranks.length;
    }
}

