/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import com.enterprisedt.net.ftp.FTPException;
import java.io.File;
import java.io.IOException;
import javax.swing.JComboBox;
import org.broadinstitute.genee.gui.FTPFile;
import org.broadinstitute.genee.gui.FTPFileModel;

public class FTPComboBox
extends JComboBox {
    private FTPFileModel model;

    public FTPComboBox(FTPFileModel model) throws FTPException, IOException {
        this.model = model;
        String[] filenames = model.getFileNames();
        if (filenames != null) {
            int length = filenames.length;
            for (int i = 0; i < length; ++i) {
                this.addItem(new FTPFile(model.getHost(), model.getDir(), filenames[i]));
            }
        }
    }

    public void downloadSelectedItem(File dest) throws Exception {
        String selectedFilename = ((FTPFile)this.getSelectedItem()).getName();
        this.model.downloadFile(dest, selectedFilename);
    }

    public void quit() throws IOException, FTPException {
        this.model.quit();
    }
}

