/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPTransferType;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;

public class FTPFileModel {
    public static final String GSEA_CHIP_DIR = "/pub/gsea/annotations";
    public static final String GSEA_FTP_URL = "gseaftp.broadinstitute.org";
    public static final String GSEA_GENE_SETS_DIR = "/pub/gsea/gene_sets";
    public static final String GSEA_USER = "gs3as3cr3tz";
    public static final String GSEA_PASSWORD = "asdf7hEGw";
    private FTPClient ftp = new FTPClient();
    private String[] filenames;

    public FTPFileModel(String host, String dir) throws FTPException, IOException {
        this(host, dir, "anonymous", "");
    }

    public FTPFileModel(String host, String dir, String username, String password) throws FTPException, IOException {
        this.ftp.setRemoteHost(host);
        this.ftp.connect();
        this.ftp.login(username, password);
        this.ftp.setType(FTPTransferType.BINARY);
        this.setDir(dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadFile(File dest, String selectedFilename) throws Exception {
        if (selectedFilename == null) {
            throw new IllegalArgumentException("No file selected");
        }
        try (OutputStream os = null;){
            os = new BufferedOutputStream(new FileOutputStream(dest));
            this.ftp.get(os, selectedFilename);
            Date time = this.ftp.modtime(selectedFilename);
            dest.setLastModified(time.getTime());
        }
    }

    public void downloadFile(OutputStream os, String selectedFilename) throws FTPException, IOException {
        if (selectedFilename == null) {
            throw new IllegalArgumentException("No file selected");
        }
        this.ftp.get(os, selectedFilename);
    }

    public String getDir() throws IOException, FTPException {
        return this.ftp.pwd();
    }

    public String[] getFileNames() {
        return this.filenames;
    }

    public String getHost() {
        return this.ftp.getRemoteHost();
    }

    public void quit() throws IOException, FTPException {
        this.ftp.quit();
    }

    public void setDir(String dir) throws IOException, FTPException {
        this.ftp.chdir(dir);
        this.filenames = this.ftp.dir();
        if (this.filenames != null) {
            Arrays.sort(this.filenames, String.CASE_INSENSITIVE_ORDER);
        }
    }

    public static FTPFileModel createChipInstance() throws FTPException, IOException {
        return new FTPFileModel(GSEA_FTP_URL, GSEA_CHIP_DIR, "anonymous", "anonymous");
    }

    public static void mSigDBDownload(File dest, String file) throws Exception {
        FTPFileModel model = FTPFileModel.createMSigDBInstance();
        model.downloadFile(dest, file);
        model.quit();
    }

    public static void chipFileDownload(File dest, String file) throws Exception {
        FTPFileModel model = FTPFileModel.createChipInstance();
        model.downloadFile(dest, file);
        model.quit();
    }

    public static FTPFileModel createMSigDBInstance() throws FTPException, IOException {
        FTPFileModel model = new FTPFileModel(GSEA_FTP_URL, GSEA_GENE_SETS_DIR, GSEA_USER, GSEA_PASSWORD);
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] dir(String host, String dir, String username, String password) throws FTPException, IOException {
        FTPFileModel model = null;
        try {
            model = new FTPFileModel(host, dir, username, password);
        }
        finally {
            if (model != null) {
                model.quit();
            }
        }
        return model.getFileNames();
    }
}

