/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.DockableFrameWindow;
import org.broadinstitute.genee.application.GENEEWindow;
import org.broadinstitute.genee.gui.TableToolTip;
import org.broadinstitute.genee.gui.UIUtil;

public class GENEEToolTipManager
extends MouseAdapter
implements MouseMotionListener {
    public static final Object KEY = new Object();
    private static GENEEToolTipManager manager;
    private FocusListener focusChangeListener;
    private boolean initted;
    private JPanel tipPanel = new JPanel();
    private GENEEWindow window;
    private static final Color FOREGROUND;

    GENEEToolTipManager() {
        if (!GraphicsEnvironment.isHeadless() && Application.getWindowManager() != null) {
            this.window = Application.getWindowManager().createToolWindow("Info", 4, 1);
            this.window.getContentPane().setBackground(Color.WHITE);
            this.focusChangeListener = new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent evt) {
                    JComponent c = (JComponent)evt.getSource();
                    c.removeFocusListener(GENEEToolTipManager.this.focusChangeListener);
                    c.removeMouseMotionListener(GENEEToolTipManager.this);
                    GENEEToolTipManager.this.setToolTipText(null);
                }
            };
            if (this.window != null) {
                this.tipPanel.setBackground(Color.WHITE);
                this.window.getContentPane().add(UIUtil.createScrollPane(this.tipPanel));
                ((Component)((Object)this.window)).addKeyListener(new KeyListener(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        if (!e.isConsumed() && e.getKeyChar() == 'i' && e.getModifiers() == Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) {
                            if (!GENEEToolTipManager.sharedInstance().isShowing()) {
                                GENEEToolTipManager.sharedInstance().show();
                            } else {
                                GENEEToolTipManager.sharedInstance().hide();
                            }
                            e.consume();
                        }
                    }

                    @Override
                    public void keyReleased(KeyEvent e) {
                    }

                    @Override
                    public void keyTyped(KeyEvent e) {
                    }
                });
            }
        }
    }

    public GENEEWindow getWindow() {
        return this.window;
    }

    public void hide() {
        this.window.setVisible(false);
    }

    public boolean isShowing() {
        return ((Component)((Object)this.window)).isShowing();
    }

    @Override
    public void mouseDragged(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        this.initiateToolTip(event);
    }

    @Override
    public void mouseExited(MouseEvent event) {
        JComponent component = (JComponent)event.getSource();
        component.removeMouseMotionListener(this);
        component.removeFocusListener(this.focusChangeListener);
        this.setToolTipText(null);
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        JComponent component = (JComponent)event.getSource();
        if (component instanceof TableToolTip) {
            List<Map.Entry> tips = ((TableToolTip)((Object)component)).getTableToolTipText(event);
            this.setToolTipText(tips);
        } else {
            List tips = (List)component.getClientProperty(KEY);
            this.setToolTipText(tips);
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    public void registerComponent(JComponent component) {
        component.removeMouseListener(this);
        component.addMouseListener(this);
    }

    public void show() {
        if (this.window != null) {
            this.window.activate();
            if (!this.initted) {
                ((DockableFrameWindow)this.window).revalidate();
                this.initted = true;
            }
        }
    }

    public void unregisterComponent(JComponent component) {
        component.removeMouseListener(this);
        component.removeMouseMotionListener(this);
        component.removeFocusListener(this.focusChangeListener);
    }

    private void initiateToolTip(MouseEvent event) {
        JComponent component = (JComponent)event.getSource();
        component.removeMouseMotionListener(this);
        component.addMouseMotionListener(this);
        component.removeFocusListener(this.focusChangeListener);
        component.addFocusListener(this.focusChangeListener);
    }

    private void setToolTipText(Object tip) {
        this.tipPanel.removeAll();
        if (tip instanceof List) {
            CellConstraints cc = new CellConstraints();
            List list = (List)tip;
            this.tipPanel.setLayout((LayoutManager)new FormLayout("p", UIUtil.rep("p", list.size(), ",")));
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Map.Entry e = (Map.Entry)list.get(i);
                JLabel key = new JLabel(e.getKey() + ":");
                key.setForeground(FOREGROUND);
                JLabel value = new JLabel(String.valueOf(e.getValue()));
                value.setFont(value.getFont().deriveFont(1));
                value.setForeground(FOREGROUND);
                JPanel row = new JPanel(new FlowLayout(0));
                row.setBackground(Color.WHITE);
                row.add(key);
                row.add(value);
                this.tipPanel.add((Component)row, cc.xy(1, i + 1));
            }
        }
        this.tipPanel.revalidate();
        this.tipPanel.repaint();
    }

    public static GENEEToolTipManager sharedInstance() {
        if (manager == null) {
            manager = new GENEEToolTipManager();
        }
        return manager;
    }

    static {
        FOREGROUND = Color.decode("#777");
    }
}

