/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.broadinstitute.genee.gui.UIUtil;

public class GridFormLayout {
    private Color borderColor;
    private DragSource dragSource;
    private DragGestureListener dgListener;
    private DragSourceListener dsListener;
    private DropTarget dropTarget;
    private DropTargetListener dtListener;
    private int dragAction = 2;
    private int acceptableActions = 2;
    private Component c;

    public GridFormLayout(Component panel) {
        this.c = panel;
        if (panel instanceof JComponent) {
            ((JComponent)panel).setOpaque(true);
        }
        this.dragSource = DragSource.getDefaultDragSource();
        this.dgListener = new DGListener();
        this.dsListener = new DSListener();
        this.dragSource.createDefaultDragGestureRecognizer(panel, this.dragAction, this.dgListener);
        this.dtListener = new DTListener();
        this.dropTarget = new DropTarget(panel, this.acceptableActions, this.dtListener, true);
    }

    private void showBorder(boolean b) {
        if (this.c instanceof JComponent) {
            if (b) {
                ((JComponent)this.c).setBorder(BorderFactory.createLineBorder(this.borderColor, 1));
            } else {
                ((JComponent)this.c).setBorder(BorderFactory.createEmptyBorder());
            }
        }
        this.c.getParent().validate();
        this.c.repaint();
    }

    /*
     * WARNING - void declaration
     */
    public static FormLayout layoutGrid(JComponent panel, Collection<? extends Component> panels, int columns, boolean dragDrop) {
        void var11_14;
        panel.removeAll();
        int rows = (int)Math.ceil((float)panels.size() / (float)columns);
        FormLayout layout = new FormLayout(UIUtil.createColumnStringForFormLayout(columns), UIUtil.createStringForFormLayout(null, "pref", rows));
        layout.setHonorsVisibility(false);
        panel.setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        int col = 1;
        int row = 1;
        int columnCount = 0;
        for (Component component : panels) {
            if (!component.isVisible()) continue;
            if (dragDrop) {
                new GridFormLayout(component);
            }
            panel.add(component, cc.xy(col, row));
            col += 2;
            if (++columnCount != columns) continue;
            col = 1;
            row += 2;
            columnCount = 0;
        }
        int diff = rows * columns - panels.size();
        boolean bl = false;
        while (var11_14 < diff) {
            JPanel p = new JPanel();
            ((Component)p).setBackground(panel.getBackground());
            if (dragDrop) {
                new GridFormLayout(p);
            }
            panel.add((Component)p, cc.xy(col, row));
            col += 2;
            if (++columnCount == columns) {
                col = 1;
                row += 2;
                columnCount = 0;
            }
            ++var11_14;
        }
        panel.revalidate();
        return layout;
    }

    static class MyTransferable
    implements Transferable {
        private Component component;
        private static DataFlavor[] flavors;
        private static List<DataFlavor> flavorList;

        public MyTransferable(Component component) {
            this.component = component;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            return this.component;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavorList.contains(flavor);
        }

        static {
            try {
                flavors = new DataFlavor[]{new DataFlavor("application/x-java-jvm-local-objectref")};
                flavorList = Arrays.asList(flavors);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    class DTListener
    implements DropTargetListener {
        DTListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent e) {
            if (!this.isDragOk(e)) {
                GridFormLayout.this.borderColor = Color.red;
                GridFormLayout.this.showBorder(true);
                e.rejectDrag();
                return;
            }
            GridFormLayout.this.borderColor = Color.green;
            GridFormLayout.this.showBorder(true);
            e.acceptDrag(e.getDropAction());
        }

        @Override
        public void dragExit(DropTargetEvent e) {
            GridFormLayout.this.borderColor = Color.green;
            GridFormLayout.this.showBorder(false);
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
            if (!this.isDragOk(e)) {
                GridFormLayout.this.borderColor = Color.red;
                GridFormLayout.this.showBorder(true);
                e.rejectDrag();
                return;
            }
            e.acceptDrag(e.getDropAction());
        }

        @Override
        public void drop(DropTargetDropEvent e) {
            DataFlavor chosen = this.chooseDropFlavor(e);
            if (chosen == null) {
                System.err.println("No flavor match found");
                e.rejectDrop();
                return;
            }
            System.err.println("Chosen data flavor is " + chosen.getMimeType());
            int da = e.getDropAction();
            int sa = e.getSourceActions();
            if ((sa & GridFormLayout.this.acceptableActions) == 0) {
                System.err.println("No action match found");
                e.rejectDrop();
                GridFormLayout.this.showBorder(false);
                return;
            }
            Component draggedData = null;
            try {
                e.acceptDrop(GridFormLayout.this.acceptableActions);
                draggedData = (Component)e.getTransferable().getTransferData(chosen);
                if (draggedData == null) {
                    throw new NullPointerException();
                }
            }
            catch (Throwable t) {
                System.err.println("Couldn't get transfer data: " + t.getMessage());
                t.printStackTrace();
                e.dropComplete(false);
                GridFormLayout.this.showBorder(false);
                return;
            }
            FormLayout fl = (FormLayout)draggedData.getParent().getLayout();
            CellConstraints cc = fl.getConstraints(draggedData);
            CellConstraints cc2 = fl.getConstraints(GridFormLayout.this.c);
            fl.setConstraints(draggedData, cc2);
            fl.setConstraints(GridFormLayout.this.c, cc);
            e.dropComplete(true);
            GridFormLayout.this.showBorder(false);
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e) {
            if (!this.isDragOk(e)) {
                e.rejectDrag();
                return;
            }
            e.acceptDrag(e.getDropAction());
        }

        private DataFlavor chooseDropFlavor(DropTargetDropEvent e) {
            try {
                return new DataFlavor("application/x-java-jvm-local-objectref");
            }
            catch (ClassNotFoundException e1) {
                return null;
            }
        }

        private boolean isDragFlavorSupported(DropTargetDragEvent e) {
            return true;
        }

        private boolean isDragOk(DropTargetDragEvent e) {
            if (!this.isDragFlavorSupported(e)) {
                return false;
            }
            int da = e.getDropAction();
            return (da & GridFormLayout.this.acceptableActions) != 0;
        }
    }

    class DSListener
    implements DragSourceListener {
        DSListener() {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent e) {
            if (!e.getDropSuccess()) {
                return;
            }
        }

        @Override
        public void dragEnter(DragSourceDragEvent e) {
            DragSourceContext context = e.getDragSourceContext();
            int myaction = e.getDropAction();
            if ((myaction & GridFormLayout.this.dragAction) != 0) {
                context.setCursor(DragSource.DefaultMoveDrop);
            } else {
                context.setCursor(DragSource.DefaultMoveNoDrop);
            }
        }

        @Override
        public void dragExit(DragSourceEvent e) {
        }

        @Override
        public void dragOver(DragSourceDragEvent e) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent e) {
            DragSourceContext context = e.getDragSourceContext();
            context.setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    class DGListener
    implements DragGestureListener {
        DGListener() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent e) {
            if (e.getDragOrigin().y > 20) {
                return;
            }
            if ((e.getDragAction() & GridFormLayout.this.dragAction) == 0) {
                return;
            }
            MyTransferable transferable = new MyTransferable(GridFormLayout.this.c);
            try {
                e.startDrag(DragSource.DefaultMoveDrop, transferable, GridFormLayout.this.dsListener);
            }
            catch (InvalidDnDOperationException idoe) {
                System.err.println(idoe);
            }
        }
    }
}

