/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class HorizontalLayout
implements LayoutManager {
    private int gap = 0;

    public HorizontalLayout() {
    }

    public HorizontalLayout(int gap) {
        this.gap = gap;
    }

    @Override
    public void addLayoutComponent(String name, Component c) {
    }

    public int getGap() {
        return this.gap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            Dimension size = target.getSize();
            int height = size.height - insets.top - insets.bottom;
            int width = insets.left;
            int cc = target.getComponentCount();
            for (int i = 0; i < cc; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                m.setBounds(width, insets.top, m.getPreferredSize().width, height);
                width += m.getSize().width + this.gap;
            }
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            Dimension pref = new Dimension(0, 0);
            int cc = target.getComponentCount();
            for (int i = 0; i < cc; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension componentPreferredSize = target.getComponent(i).getPreferredSize();
                pref.height = Math.max(pref.height, componentPreferredSize.height);
                pref.width += componentPreferredSize.width + this.gap;
            }
            pref.width += insets.left + insets.right;
            pref.height += insets.top + insets.bottom;
            return pref;
        }
    }

    @Override
    public void removeLayoutComponent(Component c) {
    }

    public void setGap(int gap) {
        this.gap = gap;
    }
}

