/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import org.broadinstitute.genee.gui.GelModel;
import org.broadinstitute.genee.matrix.Dataset;

public class InterpolatedGelModel
implements GelModel {
    private GelModel start;
    private GelModel end;
    private float fraction;
    private boolean interpolateDistance;

    @Override
    public float getDistance(int index) {
        return !this.interpolateDistance ? this.end.getDistance(index) : this.start.getDistance(index) + this.fraction * (this.end.getDistance(index) - this.start.getDistance(index));
    }

    @Override
    public Dataset getDistanceMatrix() {
        return this.end.getDistanceMatrix();
    }

    public GelModel getEnd() {
        return this.end;
    }

    @Override
    public float getMaxDistance() {
        return this.end.getMaxDistance();
    }

    @Override
    public float getMinDistance() {
        return this.end.getMinDistance();
    }

    @Override
    public float getRankForTheta(int index) {
        return this.start.getRankForTheta(index) + this.fraction * (this.end.getRankForTheta(index) - this.start.getRankForTheta(index));
    }

    @Override
    public float getActualRank(int index) {
        return this.start.getActualRank(index) + this.fraction * (this.end.getActualRank(index) - this.start.getActualRank(index));
    }

    @Override
    public GelModel getRankSupplier() {
        return null;
    }

    public GelModel getStart() {
        return this.start;
    }

    public boolean isInterpolateDistance() {
        return this.interpolateDistance;
    }

    public void setEnd(GelModel end) {
        this.end = end;
    }

    public void setFraction(float fraction) {
        this.fraction = fraction;
    }

    public void setInterpolateDistance(boolean interpolateDistance) {
        this.interpolateDistance = interpolateDistance;
    }

    @Override
    public void setDistanceMatrixRefIndex(int referenceIndex) {
    }

    @Override
    public void setRankSupplier(GelModel model) {
    }

    public void setStart(GelModel start) {
        this.start = start;
    }

    @Override
    public int size() {
        return this.end.size();
    }

    @Override
    public GelModel copy() {
        return null;
    }
}

