/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEWindow;
import org.broadinstitute.genee.gui.UIUtil;

public class KeyboardShortcutDialog {
    private String acceleratorDelimiter = "-";
    private GENEEWindow dialog = Application.createDialog("Keyboard Shortcuts");

    public KeyboardShortcutDialog(KeyStroke[] keys, Action[] actions) {
        FormLayout fl = new FormLayout("pref, 8dlu, pref", "");
        CellConstraints cc = new CellConstraints();
        JPanel p = new JPanel((LayoutManager)fl);
        p.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        for (int i = 0; i < keys.length; ++i) {
            int keyCode;
            if (i > 0) {
                fl.appendRow(UIUtil.decodeRowSpec("pref"));
                p.add((Component)new JSeparator(), cc.xywh(1, fl.getRowCount(), 3, 1));
            }
            String acceleratorText = "";
            int modifiers = keys[i].getModifiers();
            if (modifiers > 0) {
                acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
                acceleratorText = acceleratorText + " ";
            }
            acceleratorText = (keyCode = keys[i].getKeyCode()) != 0 ? acceleratorText + KeyEvent.getKeyText(keyCode) : acceleratorText + keys[i].getKeyChar();
            fl.appendRow(UIUtil.decodeRowSpec("pref"));
            JLabel nameLabel = new JLabel(actions[i].getValue("Name").toString());
            JLabel value = new JLabel(acceleratorText);
            p.add((Component)nameLabel, cc.xy(1, fl.getRowCount()));
            p.add((Component)value, cc.xy(3, fl.getRowCount()));
        }
        this.dialog.getContentPane().add(p);
        this.dialog.pack();
    }

    public void setVisible(boolean b) {
        this.dialog.setVisible(b);
    }
}

