/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.broadinstitute.genee.gui.ButtonBorder;
import org.broadinstitute.genee.gui.UIUtil;

public class LinkButton
extends JButton
implements MouseListener,
ActionListener,
FocusListener {
    private static final Color MOUSE_OVER_LINK_COLOR = new Color(16748032);
    private static final Border mouseoverBorder = ButtonBorder.createMouseOver();
    private static final Border regularBorder = ButtonBorder.createRegular();
    private static Color VISITED_LINK_COLOR = new Color(5607890);
    private final Color defaultForeground;
    private final boolean showBorder;
    private boolean underline = false;
    private boolean visited;

    public LinkButton(String label) {
        this(label, new Color(1909075), true);
    }

    public LinkButton(String label, Color foreground, boolean showBorder) {
        super(label);
        this.defaultForeground = foreground;
        this.showBorder = showBorder;
        this.setForeground(this.defaultForeground);
        if (showBorder) {
            this.setBorder(BorderFactory.createEmptyBorder(5, 11, 5, 11));
            this.setMargin(new Insets(11, 11, 11, 11));
        } else {
            this.setBorder(new EmptyBorder(1, 1, 1, 1));
            this.setMargin(new Insets(0, 0, 0, 0));
        }
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setHorizontalAlignment(2);
        this.addMouseListener(this);
        this.setFocusable(true);
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        this.setRolloverEnabled(true);
        this.setContentAreaFilled(false);
        this.addActionListener(this);
        this.addFocusListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.visited = true;
    }

    @Override
    public void focusGained(FocusEvent e) {
        Rectangle rect = this.getBounds();
        rect.grow(0, UIUtil.DEFAULT_FONT_SIZE);
        this.scrollRectToVisible(rect);
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.isEnabled()) {
            this.underline = true;
            this.repaint();
            if (!this.showBorder) {
                this.setForeground(MOUSE_OVER_LINK_COLOR);
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.isEnabled()) {
            this.underline = false;
            if (!this.showBorder) {
                this.setForeground(this.visited ? VISITED_LINK_COLOR : this.defaultForeground);
            }
            this.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.underline && this.isEnabled() && !this.showBorder) {
            Font f = this.getFont();
            FontMetrics fm = this.getFontMetrics(f);
            int iconWidth = 0;
            if (null != this.getIcon()) {
                iconWidth = this.getIcon().getIconWidth() + this.getIconTextGap();
            }
            int x1 = iconWidth;
            int y1 = fm.getHeight();
            int x2 = fm.stringWidth(this.getText()) + iconWidth;
            if (this.getText().length() > 0) {
                g.drawLine(x1, y1, x2, y1);
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.showBorder) {
            Border b = this.underline ? mouseoverBorder : regularBorder;
            b.paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
        }
        super.paintComponent(g2);
    }
}

