/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEWindow;
import org.broadinstitute.genee.category.VectorColorModel;
import org.broadinstitute.genee.gui.ContinuousColorEditorPanel;
import org.broadinstitute.genee.gui.CustomSortOrderChooser;
import org.broadinstitute.genee.gui.DiscreteColorEditorPanel;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.TableAutoComplete;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.actions.MetadataDataType;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.ProjectEvent;
import org.broadinstitute.genee.heatmap.ProjectListener;
import org.broadinstitute.genee.io.util.TrackerUtil;
import org.broadinstitute.genee.matrix.Comparators;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.table.FilterableTableModel;
import org.broadinstitute.genee.table.TableFilterField;
import org.broadinstitute.genee.table.TableUtil;

public class MetadataEditor {
    private static final Class<?>[] COLUMN_CLASSES = new Class[]{String.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, ChartStyle.class, MetadataDataType.class, Boolean.class, Boolean.class};
    private static final String[] COLUMN_NAMES = new String[]{"Name", "Color Bar", "Text Color", "Text", "Tooltip", "Chart", "Data Type", "Custom Sort Order", "Show in dataset"};
    private FilterableTableModel filterableModel;
    private MetadataModel metadataModel;
    private JPanel panel;
    private Project project;
    private boolean rows;
    private JTable table;

    public MetadataEditor(Project project, boolean rows) {
        this.project = project;
        this.rows = rows;
        this.metadataModel = rows ? project.getOriginalDataset().getRowMetadata() : project.getOriginalDataset().getColumnMetadata();
        this.init();
    }

    public void delete(List<String> selection) {
        if (UIUtil.showOkCancelDialog(this.table, "Are you sure you want to delete " + (selection.size() == 1 ? selection.get(0) : "the selected annotations") + "?", "")) {
            for (String name : selection) {
                this.metadataModel.remove(this.metadataModel.getColumnIndex(name));
            }
            if (this.rows) {
                this.project.fireRowMetadataChanged();
            } else {
                this.project.fireColumnMetadataChanged();
            }
        }
    }

    public JComponent getComponent() {
        return this.panel;
    }

    private List<String> getSelection() {
        int[] selectedRows = this.table.getSelectedRows();
        ArrayList<String> list = new ArrayList<String>();
        for (int row : selectedRows) {
            list.add((String)this.table.getValueAt(row, 0));
        }
        return list;
    }

    private void init() {
        this.project.addProjectListener(new ProjectListener(){

            @Override
            public void projectChanged(ProjectEvent e) {
                boolean changed = false;
                if (MetadataEditor.this.rows && e.getType() == 5) {
                    changed = true;
                } else if (!MetadataEditor.this.rows && e.getType() == 6) {
                    changed = true;
                }
                if (changed) {
                    MetadataEditor.this.filterableModel.fireTableDataChanged();
                }
            }
        });
        this.filterableModel = new FilterableTableModel(new MetadataEditorTableModel(this.metadataModel, this.rows));
        TableFilterField filterField = new TableFilterField(this.filterableModel, null){

            @Override
            protected String getSavedSearchKey() {
                return null;
            }
        };
        this.table = new JTable(this.filterableModel);
        TableUtil.setSortable(this.table, this.filterableModel);
        this.table.setDefaultRenderer(Boolean.class, new DefaultTableCellRenderer(){

            @Override
            protected void setValue(Object value) {
                if (value instanceof Boolean) {
                    this.setText((Boolean)value != false ? "yes" : "");
                } else {
                    this.setText("");
                }
            }
        });
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(true);
        this.table.setMinimumSize(new Dimension(0, 0));
        this.table.setFont(new Font(UIUtil.getFontName(), 0, 12));
        this.table.getTableHeader().setFont(new Font(UIUtil.getFontName(), 0, 13));
        this.table.setAutoResizeMode(0);
        TableUtil.sizeColumns(this.table);
        new TableAutoComplete(filterField, this.filterableModel);
        this.panel = new JPanel(new BorderLayout());
        this.panel.add(new JScrollPane(this.table));
        JPanel tmp = new JPanel(new FlowLayout(0));
        tmp.add((Component)((Object)filterField));
        this.panel.add((Component)tmp, "North");
        final JCheckBox text = new JCheckBox("Text");
        final JCheckBox colorBar = new JCheckBox("Color bar");
        final JCheckBox colorText = new JCheckBox("Color text");
        final JCheckBox toolTip = new JCheckBox("Tooltip", true);
        final JCheckBox showInDataset = new JCheckBox("Show in dataset");
        final JComboBox chartTypeComboBox = UIUtil.createComboBox(ChartStyle.values());
        final JComboBox dataTypeComboBox = UIUtil.createComboBox((Object[])MetadataDataType.getAllowedValues());
        JButton deleteButton = new JButton("Delete");
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MetadataEditor.this.delete(MetadataEditor.this.getSelection());
            }
        });
        JButton editColorButton = new JButton("Color\u2026");
        editColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MetadataEditor.showColorEditorDialog(MetadataEditor.this.metadataModel.get((String)MetadataEditor.this.getSelection().get(0)), MetadataEditor.this.rows ? MetadataEditor.this.project.getRowColorModel() : MetadataEditor.this.project.getColumnColorModel());
            }
        });
        JButton sortOrderButton = new JButton("Custom Sort Order\u2026");
        sortOrderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MetadataEditor.showCustomSortOrderDialog(MetadataEditor.this.project, MetadataEditor.this.rows, MetadataEditor.this.metadataModel.get((String)MetadataEditor.this.getSelection().get(0)));
            }
        });
        final FormBuilder actionsBuilder = new FormBuilder();
        actionsBuilder.nextRow();
        actionsBuilder.addSpanned(new JLabel("For selected annotation(s):"));
        actionsBuilder.nextSmallRow();
        actionsBuilder.addSpanned(text);
        actionsBuilder.nextSmallRow();
        actionsBuilder.addSpanned(colorBar);
        actionsBuilder.nextSmallRow();
        actionsBuilder.addSpanned(colorText);
        actionsBuilder.nextSmallRow();
        actionsBuilder.addSpanned(toolTip);
        actionsBuilder.nextSmallRow();
        if (!this.rows) {
            actionsBuilder.addSpanned(showInDataset);
            actionsBuilder.nextSmallRow();
        }
        actionsBuilder.addLabel("Chart:");
        actionsBuilder.add(chartTypeComboBox);
        actionsBuilder.nextRow();
        JButton applyButton = new JButton("Apply");
        actionsBuilder.addSpanned(UIUtil.buildLeftBar(applyButton));
        actionsBuilder.nextSmallRow();
        actionsBuilder.addSpanned(UIUtil.buildLeftBar(deleteButton));
        actionsBuilder.addSeparator();
        final FormBuilder actions2Builder = new FormBuilder();
        actions2Builder.nextRow();
        actions2Builder.addSpanned(UIUtil.buildLeftBar(editColorButton));
        actions2Builder.nextSmallRow();
        actions2Builder.addSpanned(UIUtil.buildLeftBar(sortOrderButton));
        actions2Builder.nextSmallRow();
        actions2Builder.addLabel("Data type:");
        JPanel dt = new JPanel((LayoutManager)new FormLayout("p, p", "p"));
        JButton changeBtn = new JButton("Convert");
        dt.add((Component)dataTypeComboBox, CC.xy((int)1, (int)1));
        dt.add((Component)changeBtn, CC.xy((int)2, (int)1));
        actions2Builder.add(dt);
        actionsBuilder.addSpanned(actions2Builder.getPanel());
        changeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MetadataDataType type = (MetadataDataType)((Object)dataTypeComboBox.getSelectedItem());
                    int[] selectedRows = MetadataEditor.this.table.getSelectedRows();
                    Vector v = MetadataEditor.this.metadataModel.get((String)MetadataEditor.this.table.getValueAt(selectedRows[0], 0));
                    DatasetUtil.changeDataType(MetadataEditor.this.project, MetadataEditor.this.rows, v.getName(), type);
                }
                catch (Exception x) {
                    UIUtil.showErrorDialog(MetadataEditor.this.table, x.getMessage());
                }
            }
        });
        applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isText = text.isSelected();
                boolean isColor = colorBar.isSelected();
                boolean isColorText = colorText.isSelected();
                boolean isToolTip = toolTip.isSelected();
                boolean isShowInDataset = showInDataset.isSelected();
                ChartStyle chartStyle = (ChartStyle)chartTypeComboBox.getSelectedItem();
                for (int row : MetadataEditor.this.table.getSelectedRows()) {
                    Vector v = MetadataEditor.this.metadataModel.get((String)MetadataEditor.this.table.getValueAt(row, 0));
                    v.setProperty("Text Visible", isText);
                    v.setProperty("Color Visible", isColor);
                    v.setProperty("Text Color Visible", isColorText);
                    v.setProperty("Tooltip Visible", isToolTip);
                    v.setProperty("In Dataset", isShowInDataset);
                    if (chartStyle.style == -1) {
                        v.removeProperty("Chart Style");
                        continue;
                    }
                    v.setProperty("Chart Style", chartStyle.style);
                }
                if (MetadataEditor.this.rows) {
                    MetadataEditor.this.project.fireRowMetadataChanged();
                } else {
                    MetadataEditor.this.project.fireColumnMetadataChanged();
                }
            }
        });
        this.panel.add((Component)actionsBuilder.getPanel(), "East");
        UIUtil.setChildrenEnabledRecursively(actionsBuilder.getPanel(), false);
        UIUtil.setChildrenEnabledRecursively(actions2Builder.getPanel(), false);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int count = MetadataEditor.this.table.getSelectedRowCount();
                UIUtil.setChildrenEnabledRecursively(actionsBuilder.getPanel(), count > 0);
                UIUtil.setChildrenEnabledRecursively(actions2Builder.getPanel(), count == 1);
            }
        });
    }

    public static Action createAction(boolean rows) {
        final boolean _rows = rows;
        return new AbstractAction("Edit " + (_rows ? "Row" : "Column") + " Annotations"){
            private GENEEWindow dialog;

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackerUtil.trackPageView((String)this.getValue("Name"));
                if (this.dialog == null) {
                    this.dialog = Application.createDialog("Edit " + (_rows ? "Row" : "Column") + " Annotations");
                    this.dialog.getContentPane().add(new MetadataEditor(Application.getProject(), _rows).getComponent());
                    this.dialog.pack();
                    this.dialog.setSize(this.dialog.getWidth() + 270, this.dialog.getHeight());
                }
                this.dialog.setVisible(true);
            }
        };
    }

    public static void showColorEditorDialog(final Vector v, final VectorColorModel colorModel) {
        JPanel colorComponent = null;
        boolean continuous = MetadataUtil.getBoolean(v, "Continuous Key");
        colorComponent = !continuous ? new DiscreteColorEditorPanel(v, colorModel) : new ContinuousColorEditorPanel(v, colorModel);
        final GENEEWindow window = Application.getWindowManager().createInputWindow(v.getName() + " color", null);
        ((Dialog)((Object)window)).setModal(true);
        window.getContentPane().add((Component)UIUtil.createNoBorderScrollPane(colorComponent), "Center");
        FormBuilder fb = new FormBuilder();
        fb.nextRow();
        final JCheckBox discreteCheckBox = new JCheckBox("Discrete", !continuous);
        discreteCheckBox.setEnabled(Number.class.isAssignableFrom(v.getColumnClass()));
        discreteCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPanel c = null;
                if (discreteCheckBox.isSelected()) {
                    v.removeProperty("Continuous Key");
                    c = new DiscreteColorEditorPanel(v, colorModel);
                } else {
                    v.setProperty("Continuous Key", true);
                    c = new ContinuousColorEditorPanel(v, colorModel);
                }
                int cc = window.getContentPane().getComponentCount();
                for (int i = 0; i < cc; ++i) {
                    Component tmp = window.getContentPane().getComponent(i);
                    if (!(tmp instanceof JScrollPane)) continue;
                    window.getContentPane().remove(i);
                    --i;
                    --cc;
                }
                window.getContentPane().add((Component)UIUtil.createNoBorderScrollPane(c), "Center");
                window.getContentPane().invalidate();
                window.getContentPane().validate();
                c.revalidate();
                c.repaint();
                window.pack();
            }
        });
        fb.addSpanned(discreteCheckBox);
        window.getContentPane().add(UIUtil.createNoBorderScrollPane(colorComponent));
        window.getContentPane().add((Component)fb.getPanel(), "South");
        window.pack();
        window.setVisible(true);
    }

    public static void showCustomSortOrderDialog(Project project, boolean rows, Vector v) {
        new CustomSortOrderChooser(project, rows, v);
    }

    private static class MetadataEditorTableModel
    extends AbstractTableModel {
        private MetadataModel metadataModel;
        private boolean rows;

        public MetadataEditorTableModel(MetadataModel metadataModel, boolean rows) {
            this.metadataModel = metadataModel;
            this.rows = rows;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return COLUMN_CLASSES[columnIndex];
        }

        @Override
        public int getColumnCount() {
            return COLUMN_NAMES.length - (this.rows ? 1 : 0);
        }

        @Override
        public String getColumnName(int columnIndex) {
            return COLUMN_NAMES[columnIndex];
        }

        @Override
        public int getRowCount() {
            return this.metadataModel.getMetadataCount();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.metadataModel.getColumnName(rowIndex);
            }
            if (columnIndex == 1) {
                return MetadataUtil.getBoolean(this.metadataModel.get(rowIndex), "Color Visible");
            }
            if (columnIndex == 2) {
                return MetadataUtil.getBoolean(this.metadataModel.get(rowIndex), "Text Color Visible");
            }
            if (columnIndex == 3) {
                return MetadataUtil.isTextVisible(this.metadataModel.get(rowIndex));
            }
            if (columnIndex == 4) {
                return MetadataUtil.isToolTipVisible(this.metadataModel.get(rowIndex));
            }
            if (columnIndex == 5) {
                Integer style = (Integer)this.metadataModel.get(rowIndex).getProperty("Chart Style");
                if (style == null) {
                    return new ChartStyle(-1, false);
                }
                return new ChartStyle(style, false);
            }
            if (columnIndex == 6) {
                return MetadataDataType.getType(this.metadataModel.get(rowIndex).getColumnClass());
            }
            if (columnIndex == 7) {
                Comparator<Object> c = this.metadataModel.get(rowIndex).getComparator();
                return c instanceof Comparators.CustomSortOrderComparator;
            }
            if (columnIndex == 8) {
                return MetadataUtil.getBoolean(this.metadataModel.get(rowIndex), "In Dataset");
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }

    private static class ChartStyle
    implements Comparable<ChartStyle> {
        private int style;
        private String text;

        public ChartStyle(int style) {
            this(style, true);
        }

        public ChartStyle(int style, boolean showNone) {
            this.style = style;
            if (2 == style) {
                this.text = "Line";
            } else if (4 == style) {
                this.text = "Point";
            } else if (64 == style) {
                this.text = "Bar";
            } else {
                this.style = -1;
                this.text = showNone ? "(None)" : "";
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof ChartStyle) {
                ChartStyle other = (ChartStyle)obj;
                return this.style == other.style;
            }
            return false;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.style;
            return result;
        }

        public String toString() {
            return this.text;
        }

        public static ChartStyle[] values() {
            return new ChartStyle[]{new ChartStyle(-1), new ChartStyle(2), new ChartStyle(4), new ChartStyle(64)};
        }

        @Override
        public int compareTo(ChartStyle o) {
            return this.text.compareTo(o.text);
        }
    }
}

