/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import java.awt.event.KeyEvent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class MultiplexingTextField
extends JTextField {
    private KeyStroke[] strokes;

    MultiplexingTextField(int cols) {
        super(cols);
        this.setKeyStrokes(new KeyStroke[]{KeyStroke.getKeyStroke("ENTER")});
    }

    public void setKeyStrokes(KeyStroke[] strokes) {
        this.strokes = strokes;
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        boolean processed = super.processKeyBinding(ks, e, condition, pressed);
        if (processed && condition != 2) {
            for (int counter = this.strokes.length - 1; counter >= 0; --counter) {
                if (!this.strokes[counter].equals(ks)) continue;
                return false;
            }
        }
        return processed;
    }
}

