/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;

public class TiledImagePrintable
implements Printable {
    private BufferedImage image;
    private int maxPages = 1;
    private PrinterJob job;

    public boolean showDialog() {
        this.job = PrinterJob.getPrinterJob();
        this.job.setPrintable(this);
        return this.job.printDialog();
    }

    public void print(BufferedImage image) throws PrinterException {
        this.image = image;
        this.job.print();
    }

    @Override
    public int print(Graphics pg, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex >= this.maxPages || this.image == null) {
            return 1;
        }
        pg.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        int wPage = (int)pageFormat.getImageableWidth();
        int hPage = (int)pageFormat.getImageableHeight();
        int w = this.image.getWidth();
        int h = this.image.getHeight();
        if (w == 0 || h == 0) {
            return 1;
        }
        int nCol = Math.max((int)Math.ceil((double)w / (double)wPage), 1);
        int nRow = Math.max((int)Math.ceil((double)h / (double)hPage), 1);
        this.maxPages = nCol * nRow;
        int iCol = pageIndex % nCol;
        int iRow = pageIndex / nCol;
        int x = iCol * wPage;
        int y = iRow * hPage;
        int wImage = Math.min(wPage, w - x);
        int hImage = Math.min(hPage, h - y);
        pg.drawImage(this.image, 0, 0, wImage, hImage, x, y, x + wImage, y + hImage, null);
        System.gc();
        return 0;
    }
}

