/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.actions;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import gnu.trove.list.array.TIntArrayList;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.category.VectorColorModel;
import org.broadinstitute.genee.gui.BackgroundTask;
import org.broadinstitute.genee.gui.FileChooserUtil;
import org.broadinstitute.genee.gui.IconManager;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.excel.AddToMetadataContentHandler;
import org.broadinstitute.genee.io.excel.ExcelReader;
import org.broadinstitute.genee.io.excel.ExcelReaderContentHandler;
import org.broadinstitute.genee.io.excel.HeaderContentHandler;
import org.broadinstitute.genee.io.matrix.cls.ClsReader;
import org.broadinstitute.genee.io.matrix.geneset.GeneSet;
import org.broadinstitute.genee.io.matrix.geneset.GeneSetIO;
import org.broadinstitute.genee.io.util.TrackerUtil;
import org.broadinstitute.genee.matrix.ClassVector;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DefaultClassVector;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;

public class AnnotateAction
extends AbstractAction {
    private boolean isRows;

    public AnnotateAction(boolean rows) {
        this.putValue("Name", "Annotate " + (rows ? "Rows" : "Columns") + "\u2026");
        this.isRows = rows;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TrackerUtil.trackPageView((String)this.getValue("Name"));
        String title = "Select File";
        File f = FileChooserUtil.showOpenDialog(UIUtil.getCurrentFrame(), title);
        if (f != null) {
            try {
                this.load(f.getCanonicalPath());
            }
            catch (IOException e1) {
                UIUtil.showErrorDialog(UIUtil.getCurrentFrame(), "Unable to read " + f.getName() + ".");
            }
        }
    }

    public void load(final String f) {
        if (f != null) {
            final Project project = Application.getProject();
            final MetadataModel metadataModel = this.isRows ? project.getOriginalDataset().getRowMetadata() : project.getOriginalDataset().getColumnMetadata();
            final VectorColorModel colorModel = this.isRows ? project.getRowColorModel() : project.getColumnColorModel();
            final Dataset fullDataset = project.getOriginalDataset();
            final MetadataModel sortedFilteredMetadata = this.isRows ? project.getSortedFilteredDataset().getRowMetadata() : project.getSortedFilteredDataset().getColumnMetadata();
            new BackgroundTask<ReturnValue>("Reading " + new File(f).getName()){

                @Override
                protected ReturnValue doInBackground() throws Exception {
                    ReturnValue r = new ReturnValue();
                    if (f.toLowerCase().endsWith(".gmx") || f.toLowerCase().endsWith(".grp") || f.toLowerCase().endsWith(".gmt")) {
                        List<GeneSet> geneSets = GeneSetIO.readGeneSetMatrix(new File(f)).getGeneSets();
                        r.geneSets = geneSets.toArray(new GeneSet[geneSets.size()]);
                    } else if (f.toLowerCase().endsWith(".cls")) {
                        DefaultClassVector cls;
                        r.classVector = cls = new ClsReader().read(f);
                    }
                    return r;
                }

                @Override
                protected void succeeded(ReturnValue ret) {
                    if (ret.geneSets != null) {
                        String datasetMetadataName = AnnotateAction.getDatasetMetadataNameToMatchOn(AnnotateAction.this.isRows ? fullDataset.getRowMetadata() : fullDataset.getColumnMetadata(), new File(f).getName());
                        if (datasetMetadataName == null) {
                            return;
                        }
                        Map<Object, TIntArrayList> keyToIndices = AnnotateAction.this.isRows ? VectorUtil.createValueToIndicesMap(fullDataset.getRowMetadata().get(datasetMetadataName)) : VectorUtil.createValueToIndicesMap(fullDataset.getColumnMetadata().get(datasetMetadataName));
                        AnnotateAction.loadGeneSets(metadataModel, keyToIndices, ret.geneSets);
                        if (AnnotateAction.this.isRows) {
                            project.fireRowMetadataChanged();
                        } else {
                            project.fireColumnMetadataChanged();
                        }
                    } else if (ret.classVector != null) {
                        AnnotateAction.loadClassVector(sortedFilteredMetadata, ret.classVector);
                        if (AnnotateAction.this.isRows) {
                            project.fireRowMetadataChanged();
                        } else {
                            project.fireColumnMetadataChanged();
                        }
                    } else {
                        String sheet = null;
                        if (ExcelReader.isExcelFile(f)) {
                            Object[] sheets = ExcelReader.getSheetNames(f);
                            sheet = sheets[0];
                            if (sheets.length > 1) {
                                sheet = (String)JOptionPane.showInputDialog(UIUtil.getCurrentFrame(), "Select Excel Sheet", "Select Excel Sheet", -1, IconManager.loadIcon("heatmap-64.gif"), sheets, sheets[0]);
                            }
                        }
                        try {
                            HeaderContentHandler headerHandler = new HeaderContentHandler();
                            new ExcelReader(f, sheet, (ExcelReaderContentHandler)headerHandler);
                            Object[] result = AnnotateAction.getDatasetMetadataNameAndFileColumnIndexToMatchOn(AnnotateAction.this.isRows ? fullDataset.getRowMetadata() : fullDataset.getColumnMetadata(), headerHandler.getColumnNames().toArray(new String[0]));
                            if (result == null) {
                                return;
                            }
                            String datasetMetadataName = (String)result[0];
                            Map<String, TIntArrayList> keyToIndices = AnnotateAction.this.isRows ? VectorUtil.createStringValueToIndicesMap(fullDataset.getRowMetadata().get(datasetMetadataName)) : VectorUtil.createStringValueToIndicesMap(fullDataset.getColumnMetadata().get(datasetMetadataName));
                            new ExcelReader(f, sheet, (ExcelReaderContentHandler)new AddToMetadataContentHandler(metadataModel, colorModel, null, keyToIndices, AnnotateAction.this.isRows, (Integer)result[1]));
                            if (AnnotateAction.this.isRows) {
                                project.fireRowMetadataChanged();
                            } else {
                                project.fireColumnMetadataChanged();
                            }
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                            UIUtil.showErrorDialog(UIUtil.getCurrentFrame(), "An error occurred while reading the file " + new File(f).getName() + ".");
                        }
                    }
                }
            }.execute();
        }
    }

    public static String getDatasetMetadataNameToMatchOn(MetadataModel model, String file) {
        List<String> datasetMetadataNames = MetadataUtil.getNames(model);
        String metadataName = datasetMetadataNames.get(0);
        if (datasetMetadataNames.size() > 1) {
            String prompt = file != null ? "Select the annotation in the dataset to match with the 1st column in " + file : "Select the annotation to match on";
            metadataName = (String)JOptionPane.showInputDialog(UIUtil.getCurrentFrame(), prompt, "Select Annotation", -1, IconManager.loadIcon("heatmap-64.gif"), datasetMetadataNames.toArray(), datasetMetadataNames.get(0));
        }
        return metadataName;
    }

    public static Object[] getDatasetMetadataNameAndFileColumnIndexToMatchOn(MetadataModel model, String[] fileColumnNames) {
        List<String> datasetMetadataNames = MetadataUtil.getNames(model);
        JComboBox<Object> datasetComboBox = new JComboBox<Object>(datasetMetadataNames.toArray());
        JComboBox<String> fileComboBox = new JComboBox<String>(fileColumnNames);
        JPanel panel = new JPanel((LayoutManager)new FormLayout("p, 6px, p", "p, 4px, p, 4px, p"));
        CellConstraints cc = new CellConstraints();
        panel.add((Component)new JLabel("Dataset"), cc.xy(1, 1));
        panel.add((Component)new JLabel("File"), cc.xy(3, 1));
        panel.add(datasetComboBox, cc.xy(1, 3));
        panel.add(fileComboBox, cc.xy(3, 3));
        if (UIUtil.showOkCancelDialog(UIUtil.getCurrentFrame(), panel, "Select fields")) {
            return new Object[]{datasetComboBox.getSelectedItem(), fileComboBox.getSelectedIndex()};
        }
        return null;
    }

    public static Vector loadClassVector(MetadataModel metadata, ClassVector classVector) {
        Vector v = MetadataUtil.addColumnVector(metadata, classVector.getDescription(), String.class);
        v.setProperty("Color Visible", true);
        v.setProperty("Text Visible", false);
        int length = classVector.size();
        for (int j = 0; j < length; ++j) {
            v.setValue(j, classVector.getClassName(classVector.getAssignment(j)));
        }
        return v;
    }

    public static void loadGeneSets(MetadataModel metadata, Map<Object, TIntArrayList> keyToIndices, GeneSet[] geneSets) {
        for (GeneSet geneSet : geneSets) {
            String geneSetName = new File(geneSet.getName()).getName();
            Vector v = MetadataUtil.addColumnVector(metadata, geneSetName, String.class);
            for (String key : geneSet.getMembers()) {
                TIntArrayList indices = keyToIndices.get(key);
                if (indices == null) continue;
                int nIndices = indices.size();
                for (int j = 0; j < nIndices; ++j) {
                    int index = indices.getQuick(j);
                    v.setValue(index, "1");
                }
            }
        }
    }

    private static class ReturnValue {
        protected DefaultClassVector classVector;
        protected GeneSet[] geneSets;

        private ReturnValue() {
        }
    }
}

