/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.actions;

import gnu.trove.list.array.TIntArrayList;
import java.util.Map;
import javax.swing.tree.MutableTreeNode;
import org.broadinstitute.genee.application.GENEEFolderNode;
import org.broadinstitute.genee.application.History;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.gui.parameters.ComboBoxParameter;
import org.broadinstitute.genee.gui.parameters.RadioButtonParameter;
import org.broadinstitute.genee.heatmap.AbstractNodesAction;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.menu.analysis.NearestNeighborsAction;
import org.broadinstitute.genee.math.stat.function.bivariate.BivariateFloatListFunction;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetAdapter;
import org.broadinstitute.genee.matrix.DatasetRowView;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;

public class CorrelationAcrossDatasetsAction
extends AbstractNodesAction {
    private static final String ROWS_OR_COLUMNS = "Compute similarity for";
    private static final String ROWS = "rows";
    private static final String COLS = "columns";

    public CorrelationAcrossDatasetsAction() {
        super("Similarity Across Datasets", true, true);
        this.setDescription("Compute the similarity of matched rows/columns across datasets");
        this.addParameter("Metric", new ComboBoxParameter((Object[])NearestNeighborsAction.FUNCTIONS, NearestNeighborsAction.FUNCTIONS[0]), true);
        this.addParameter(ROWS_OR_COLUMNS, new RadioButtonParameter(new String[]{ROWS, COLS}, 0), true);
    }

    @Override
    protected boolean accept(ProjectGENEEResultTreeNode selectedNode, ProjectGENEEResultTreeNode child) {
        return true;
    }

    @Override
    protected MutableTreeNode execute(Map<String, Object> map, ProjectGENEEResultTreeNode selectedNode, String selectedNodeRowField, String selectedNodeColumnField, ProjectGENEEResultTreeNode childNode, String childNodeRowField, String childNodeColumnField) {
        boolean isRows = map.get(ROWS_OR_COLUMNS).equals(ROWS);
        Dataset ref = DatasetUtil.shallowCopy(selectedNode.getProject().getSortedFilteredDataset());
        Dataset child = childNode.getProject().getSortedFilteredDataset();
        if (!isRows) {
            ref = DatasetUtil.transposeView(ref);
            child = DatasetUtil.transposeView(child);
            String tmp = selectedNodeRowField;
            selectedNodeRowField = selectedNodeColumnField;
            selectedNodeColumnField = tmp;
            tmp = childNodeRowField;
            childNodeRowField = childNodeColumnField;
            childNodeColumnField = tmp;
        }
        if (ref.getRowMetadata().get(selectedNodeRowField) == null) {
            throw new RuntimeException(selectedNodeRowField + " not found in " + ref.getName() + ". Options are " + MetadataUtil.getNames(ref.getRowMetadata()));
        }
        Map valueToIndex = VectorUtil.createValueToIndexMap(ref.getRowMetadata().get(selectedNodeRowField));
        TIntArrayList refColumns = new TIntArrayList();
        TIntArrayList childColumns = new TIntArrayList();
        Vector refColumnVector = ref.getColumnMetadata().get(selectedNodeColumnField);
        if (refColumnVector == null) {
            throw new RuntimeException(selectedNodeColumnField + " not found in " + ref.getName() + ". Options are " + MetadataUtil.getNames(ref.getColumnMetadata()));
        }
        Map childValueToIndex = VectorUtil.createValueToIndexMap(child.getColumnMetadata().get(childNodeColumnField));
        int ncols = ref.getColumnCount();
        for (int i = 0; i < ncols; ++i) {
            Integer index = childValueToIndex.get(refColumnVector.getValue(i));
            if (index == null) continue;
            refColumns.add(i);
            childColumns.add(index.intValue());
        }
        if (childColumns.size() == 0) {
            throw new RuntimeException("No matching columns found");
        }
        Vector childRowVector = child.getRowMetadata().get(childNodeRowField);
        DatasetRowView refView = new DatasetRowView(ref, refColumns.toArray());
        DatasetRowView childView = new DatasetRowView(child, childColumns.toArray());
        BivariateFloatListFunction f = (BivariateFloatListFunction)map.get("Metric");
        Vector corr = MetadataUtil.addRowVector(ref.getRowMetadata(), f.toString(), Float.class, true);
        int nrows = child.getRowCount();
        for (int i = 0; i < nrows; ++i) {
            childView.setIndex(i);
            Integer index = valueToIndex.get(childRowVector.getValue(i));
            if (index == null) continue;
            refView.setIndex(index);
            corr.setValue(index, Float.valueOf(f.evaluate(refView, childView)));
        }
        History history = this.getHistory(map);
        Project project = (Project)map.get("project");
        if (!isRows) {
            ref = ((DatasetAdapter)ref).getDataset();
        }
        DefaultProject newProject = new DefaultProject(ref, project);
        ProjectGENEEResultTreeNode resultNode = new ProjectGENEEResultTreeNode(newProject, history);
        return new GENEEFolderNode((String)map.get("Operation"), history, resultNode);
    }
}

