/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.actions;

import com.google.common.collect.Sets;
import gnu.trove.list.array.TIntArrayList;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.MutableTreeNode;
import org.apache.commons.math3.distribution.HypergeometricDistribution;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEFolderNode;
import org.broadinstitute.genee.application.History;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.gui.AbstractInputAction;
import org.broadinstitute.genee.gui.ProgressNotifier;
import org.broadinstitute.genee.gui.parameters.ComboBoxParameter;
import org.broadinstitute.genee.gui.parameters.FileInputParameter;
import org.broadinstitute.genee.gui.parameters.FloatInputParameter;
import org.broadinstitute.genee.gui.parameters.IntegerInputParameter;
import org.broadinstitute.genee.gui.parameters.MetadataComboBoxInputParameter;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.io.matrix.geneset.GeneSet;
import org.broadinstitute.genee.io.matrix.geneset.GeneSetIO;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;
import org.broadinstitute.genee.matrix.geneset.DefaultGeneSet;

public class HypergeometricAction
extends AbstractInputAction {
    private static final String QUERY_SETS = "Query sets";
    private static final String REFERENCE_SETS = "Reference sets";
    private static final String REFERENCE_DATABASE = "Reference GMT/GMX database";
    private static final String SET_ANNOTATION = "Query set annotation";
    private static final String ID_ANNOTATION = "Query identifier annotation";
    private static final String RESTRICT_IDS = "Restrict identifiers to";
    private static final String MIN_SET_SIZE = "Minimum set size to include";
    private static final String MAX_SET_SIZE = "Maximum set size to include";
    private static final String P_VALUE = "Include sets with at least one p-value <=";

    public HypergeometricAction() {
        super("Hypergeometric Test");
        this.addParameter(REFERENCE_DATABASE, new FileInputParameter(FileInputParameter.OPEN_FILE), true);
        this.addParameter(SET_ANNOTATION, new MetadataComboBoxInputParameter(true), true);
        this.addParameter(ID_ANNOTATION, new MetadataComboBoxInputParameter(true), true);
        this.addParameter(RESTRICT_IDS, new ComboBoxParameter((Object[])new String[]{QUERY_SETS, REFERENCE_SETS}, 0), true);
        this.addParameter(MIN_SET_SIZE, new IntegerInputParameter(3), true);
        this.addParameter(MAX_SET_SIZE, new IntegerInputParameter(1000), true);
        this.addParameter(P_VALUE, new FloatInputParameter(0.1f), true);
    }

    @Override
    public boolean beforeWindowShown() {
        this.getInputPanelBuilder().getInputParameter(ID_ANNOTATION).init(Application.getProject());
        this.getInputPanelBuilder().getInputParameter(SET_ANNOTATION).init(Application.getProject());
        return true;
    }

    @Override
    protected MutableTreeNode execute(Map<String, Object> inputMap, ProgressNotifier status) throws Exception {
        Iterator[] iterators;
        String idAnnotationName = (String)inputMap.get(ID_ANNOTATION);
        String setAnnotationName = (String)inputMap.get(SET_ANNOTATION);
        Dataset dataset = (Dataset)inputMap.get("dataset");
        Map setValueToRowIndices = VectorUtil.createValueToIndicesMap(dataset.getRowMetadata().get(setAnnotationName));
        File[] file = (File[])inputMap.get(REFERENCE_DATABASE);
        List<GeneSet> referenceSets = GeneSetIO.readGeneSetMatrix(file[0]).getGeneSets();
        Vector queryIdVector = dataset.getRowMetadata().get(idAnnotationName);
        ArrayList<DefaultGeneSet> querySets = new ArrayList<DefaultGeneSet>();
        for (Object value : setValueToRowIndices.keySet()) {
            TIntArrayList rowIndices = setValueToRowIndices.get(value);
            HashSet<String> ids = new HashSet<String>();
            int size = rowIndices.size();
            for (int i = 0; i < size; ++i) {
                ids.add(Formatter.toString(queryIdVector.getValue(i)));
            }
            DefaultGeneSet set = new DefaultGeneSet(Formatter.toString(value), ids);
            querySets.add(set);
        }
        int minSize = (Integer)inputMap.get(MIN_SET_SIZE);
        int maxSize = (Integer)inputMap.get(MAX_SET_SIZE);
        for (Iterator it : iterators = new Iterator[]{querySets.iterator(), referenceSets.iterator()}) {
            while (it.hasNext()) {
                GeneSet set = (GeneSet)it.next();
                int n = set.size();
                if (n >= minSize && n <= maxSize) continue;
                it.remove();
            }
        }
        String restrictIds = (String)inputMap.get(RESTRICT_IDS);
        List<Object> filterTo = QUERY_SETS.equals(restrictIds) ? querySets : referenceSets;
        List<Object> filter = !QUERY_SETS.equals(restrictIds) ? querySets : referenceSets;
        HashSet<String> background = new HashSet<String>();
        for (GeneSet geneSet : filterTo) {
            background.addAll(geneSet.getMembers());
        }
        for (GeneSet geneSet : filter) {
            Set<String> members = geneSet.getMembers();
            Iterator<String> it = members.iterator();
            while (it.hasNext()) {
                String id = it.next();
                if (background.contains(id)) continue;
                it.remove();
            }
        }
        RowMajorArray2DDataset queryDatabase = new RowMajorArray2DDataset(dataset.getName(), querySets.size(), referenceSets.size());
        Vector vector = MetadataUtil.addRowVector(queryDatabase.getColumnMetadata(), "Reference", GeneSet.class, true);
        int ncols = queryDatabase.getColumnCount();
        for (int j = 0; j < ncols; ++j) {
            vector.setValue(j, referenceSets.get(j));
        }
        Vector queryGeneSetVector = MetadataUtil.addRowVector(queryDatabase.getRowMetadata(), "Query", GeneSet.class, true);
        int nrows = queryDatabase.getRowCount();
        for (int i = 0; i < nrows; ++i) {
            queryGeneSetVector.setValue(i, querySets.get(i));
        }
        int backgroundSize = background.size();
        int nrows2 = queryDatabase.getRowCount();
        for (int i = 0; i < nrows2; ++i) {
            Set<String> query = ((GeneSet)queryGeneSetVector.getValue(i)).getMembers();
            int ncols2 = queryDatabase.getColumnCount();
            for (int j = 0; j < ncols2; ++j) {
                Set<String> database = ((GeneSet)vector.getValue(j)).getMembers();
                HypergeometricDistribution dist = new HypergeometricDistribution(backgroundSize, database.size(), query.size());
                float p = (float)dist.cumulativeProbability(Sets.intersection(query, database).size());
                queryDatabase.setValue(i, j, p);
            }
        }
        float p = ((Float)inputMap.get(P_VALUE)).floatValue();
        TIntArrayList columnIndices = new TIntArrayList();
        int ncols3 = queryDatabase.getColumnCount();
        for (int j = 0; j < ncols3; ++j) {
            boolean include = false;
            int nrows3 = queryDatabase.getRowCount();
            for (int i = 0; i < nrows3; ++i) {
                if (!(queryDatabase.getValue(i, j) <= p)) continue;
                include = true;
                break;
            }
            if (!include) continue;
            columnIndices.add(j);
        }
        History history = this.getHistory(inputMap);
        DefaultProject newProject = new DefaultProject(DatasetUtil.sliceView(queryDatabase, null, columnIndices.toArray()));
        ProjectGENEEResultTreeNode resultNode = new ProjectGENEEResultTreeNode(newProject, history);
        HeatMapPanel hm = (HeatMapPanel)resultNode.getDisplayInfo().getComponent();
        hm.getColorScheme().setRelative(false);
        hm.getColorScheme().setGlobalMax(1.0f);
        hm.getColorScheme().setGlobalMin(0.0f);
        return new GENEEFolderNode((String)inputMap.get("Operation"), history, resultNode);
    }
}

