/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.tree.MutableTreeNode;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEFolderNode;
import org.broadinstitute.genee.application.History;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.filter.CombinedFilter;
import org.broadinstitute.genee.filter.Filters;
import org.broadinstitute.genee.gui.AbstractInputAction;
import org.broadinstitute.genee.gui.IconManager;
import org.broadinstitute.genee.gui.ProgressNotifier;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.parameters.BasicMapEntry;
import org.broadinstitute.genee.gui.parameters.CheckBoxParameter;
import org.broadinstitute.genee.gui.parameters.ComboBoxParameter;
import org.broadinstitute.genee.gui.parameters.HiddenInputLabel;
import org.broadinstitute.genee.gui.parameters.InputPanelBuilder;
import org.broadinstitute.genee.gui.parameters.InputParameter;
import org.broadinstitute.genee.gui.parameters.IntegerInputParameter;
import org.broadinstitute.genee.gui.parameters.RadioButtonParameter;
import org.broadinstitute.genee.gui.parameters.TwoClassComparison;
import org.broadinstitute.genee.gui.parameters.TwoClassComparisonInputParameter;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.ProjectEvent;
import org.broadinstitute.genee.heatmap.ProjectListener;
import org.broadinstitute.genee.heatmap.ProjectSortKey;
import org.broadinstitute.genee.heatmap.SortKeys;
import org.broadinstitute.genee.heatmap.SortOrder;
import org.broadinstitute.genee.marker.MarkerSelection;
import org.broadinstitute.genee.math.adjust.InverseLog2;
import org.broadinstitute.genee.math.stat.function.Mean;
import org.broadinstitute.genee.math.stat.function.bivariate.AbstractTwoClassStatistic;
import org.broadinstitute.genee.math.stat.function.bivariate.AsymptoticTTest;
import org.broadinstitute.genee.math.stat.function.bivariate.BivariateFloatListFunction;
import org.broadinstitute.genee.math.stat.function.bivariate.FisherExactTest;
import org.broadinstitute.genee.math.stat.function.bivariate.RatioOfMeans;
import org.broadinstitute.genee.math.stat.function.bivariate.RatioOfMedians;
import org.broadinstitute.genee.math.stat.function.bivariate.SignalToNoise;
import org.broadinstitute.genee.math.stat.function.bivariate.TTest;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetRowView;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.DefaultClassVector;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.stats.Sorting;

public class MarkerSelectionAction
extends AbstractInputAction {
    public static final String ASYMPTOTIC_P_VALUES = "Asymptotic p-values";
    public static final String COMPARISON = "Comparison(s)";
    public static final String COMPUTE = "Compute";
    public static final String INCLUDE_ALL_COLUMNS_IN_HEATMAP = "Include all columns in result dataset";
    public static final String IS_LOG_SCALE = "Data is in log scale (used for fold change calculation)";
    public static final String NUMBER_OF_MARKERS = "Markers";
    public static final String PERMUTATION_P_VALUES = "Permutation p-values";
    public static final String PERMUTATIONS = "Permutations";
    public static final String RANDOM_NUMBER_GENERATOR_SEED = "Random number seed";
    public static final String SAVE_PERMUTED_SCORES = "Save permuted scores";
    public static final String SAVE_SCORES_MATRIX = "Create scores matrix";
    public static final String TEST_DIRECTION = "Test direction";
    public static final String TEST_STATISTIC = "Test statistic";
    public static final String THRESHOLD_STDEV = "Ensure standard deviation is at least 5% of the class mean/median";
    public static final String USE_MEDIAN = "Use median instead of mean";
    private static final BasicMapEntry[] TEST_DIR_OPTS = new BasicMapEntry[]{new BasicMapEntry<Integer>("Class A", 0), new BasicMapEntry<Integer>("Class B", 1), new BasicMapEntry<Integer>("Two sided", 2)};
    private InputParameter<TwoClassComparison[]> categoryChooserParameter;
    private boolean moreOptionsVisible;
    private Project project;
    private ProjectListener projectListener;

    public MarkerSelectionAction() {
        super("Marker Selection");
        this.putValue("SmallIcon", IconManager.loadIcon("16x16/marker-selection.png"));
        this.putValue("ShortDescription", "Marker selection");
        this.projectListener = new ProjectListener(){

            @Override
            public void projectChanged(ProjectEvent e) {
                if (e.isColumnChanged()) {
                    MarkerSelectionAction.this.categoryChooserParameter.init(MarkerSelectionAction.this.project);
                }
            }
        };
        this.categoryChooserParameter = new TwoClassComparisonInputParameter();
        this.addParameter(COMPARISON, this.categoryChooserParameter, true);
        IntegerInputParameter permutationsTextField = new IntegerInputParameter(1000);
        this.addParameter(PERMUTATIONS, permutationsTextField, "Enter -1 to perform all possible permutations. Number of possible exhaustive permutations is choose(A + B, A).", false);
        this.addParameter(NUMBER_OF_MARKERS, new IntegerInputParameter(100), "The number of markers to show in each direction initially. Enter zero to show all markers. Select Tools>Filter Rows to change.", true);
        this.addParameter(new HiddenInputLabel(INCLUDE_ALL_COLUMNS_IN_HEATMAP), new CheckBoxParameter(INCLUDE_ALL_COLUMNS_IN_HEATMAP, false), false);
        this.addParameter(new HiddenInputLabel(IS_LOG_SCALE), new CheckBoxParameter(IS_LOG_SCALE, false), false);
        final RadioButtonParameter computeParameter = new RadioButtonParameter(new String[]{PERMUTATION_P_VALUES, ASYMPTOTIC_P_VALUES}, 0);
        computeParameter.getButtonGroupHelper().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean enabled = computeParameter.getSelectedIndex() == 0;
                InputPanelBuilder inputPanelBuilder = MarkerSelectionAction.this.getInputPanelBuilder();
                for (String name : inputPanelBuilder.getParameterNames()) {
                    inputPanelBuilder.setEnabled(name, enabled);
                }
                inputPanelBuilder.setEnabled(MarkerSelectionAction.COMPUTE, true);
                inputPanelBuilder.setEnabled(MarkerSelectionAction.COMPARISON, true);
                inputPanelBuilder.setEnabled(MarkerSelectionAction.IS_LOG_SCALE, true);
                inputPanelBuilder.setEnabled(MarkerSelectionAction.NUMBER_OF_MARKERS, true);
            }
        });
        final JButton moreOptionsButton = new JButton("More options", (Icon)UIManager.get("Tree.collapsedIcon"));
        UIUtil.setLabelProperties(moreOptionsButton);
        moreOptionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                moreOptionsButton.setIcon(MarkerSelectionAction.this.moreOptionsVisible ? (Icon)UIManager.get("Tree.expandedIcon") : (Icon)UIManager.get("Tree.collapsedIcon"));
                moreOptionsButton.setText(MarkerSelectionAction.this.moreOptionsVisible ? "Hide more options" : "More options");
                UIUtil.setLabelProperties(moreOptionsButton);
                MarkerSelectionAction.this.toggleMoreOptions();
            }
        });
        this.getInputPanelBuilder().getFormBuilder().addFirstColumn(moreOptionsButton);
        this.getInputPanelBuilder().getFormBuilder().nextRow();
        this.addParameter(COMPUTE, computeParameter, true);
        final ComboBoxParameter testStatComboBox = new ComboBoxParameter((Object[])new BivariateFloatListFunction[]{new FisherExactTest(), new RatioOfMeans(), new RatioOfMedians(), new SignalToNoise(), new TTest()}, 3);
        this.addParameter(TEST_STATISTIC, testStatComboBox, false);
        final CheckBoxParameter useMedian = new CheckBoxParameter(USE_MEDIAN, false);
        final CheckBoxParameter thresholdStandardDeviation = new CheckBoxParameter(THRESHOLD_STDEV, false);
        this.addParameter(new HiddenInputLabel(USE_MEDIAN), useMedian, false);
        this.addParameter(new HiddenInputLabel(THRESHOLD_STDEV), thresholdStandardDeviation, false);
        testStatComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BivariateFloatListFunction f = (BivariateFloatListFunction)testStatComboBox.getSelectedItem();
                boolean isFisher = f instanceof FisherExactTest;
                boolean isFC = f instanceof RatioOfMeans || f instanceof RatioOfMedians;
                useMedian.setEnabled(!isFisher && !isFC);
                thresholdStandardDeviation.setEnabled(useMedian.isEnabled());
            }
        });
        this.addParameter(RANDOM_NUMBER_GENERATOR_SEED, new IntegerInputParameter(779948241), false);
        this.addParameter(new HiddenInputLabel(SAVE_PERMUTED_SCORES), new CheckBoxParameter(SAVE_PERMUTED_SCORES, false), false);
        this.addParameter(new HiddenInputLabel(SAVE_SCORES_MATRIX), new CheckBoxParameter(SAVE_SCORES_MATRIX, false), false);
        this.addParameter(TEST_DIRECTION, new RadioButtonParameter(TEST_DIR_OPTS, 2), true);
        this.toggleMoreOptions();
    }

    @Override
    public boolean beforeWindowShown() {
        if (this.project != null) {
            this.project.removeProjectListener(this.projectListener);
        }
        if (this.project == null) {
            this.project = Application.getProject();
        }
        this.project.addProjectListener(this.projectListener);
        this.categoryChooserParameter.init(this.project);
        return true;
    }

    @Override
    public void notifyHidden() {
        super.notifyHidden();
        if (this.project != null) {
            this.project.removeProjectListener(this.projectListener);
        }
    }

    @Override
    protected void customizeMap(Project p, Map<String, Object> map) {
        TwoClassComparison[] categoryGroup = (TwoClassComparison[])map.get(COMPARISON);
        if (categoryGroup.length == 0) {
            throw new RuntimeException("Please assign columns to class A and class B.");
        }
    }

    @Override
    protected MutableTreeNode execute(Map<String, Object> map, ProgressNotifier status) throws Exception {
        TwoClassComparison[] comparisons = (TwoClassComparison[])map.get(COMPARISON);
        History history = this.getHistory(map);
        GENEEFolderNode operationNode = new GENEEFolderNode((String)map.get("Operation"), history, new MutableTreeNode[0]);
        Boolean saveScoreMatrix = (Boolean)map.get(SAVE_SCORES_MATRIX);
        if (saveScoreMatrix == null) {
            saveScoreMatrix = false;
        }
        Dataset markerSelectionDataset = (Dataset)map.get("dataset");
        HashSet<String> rowMetadataFields = new HashSet<String>(MetadataUtil.getNames(markerSelectionDataset.getRowMetadata()));
        ArrayList<Dataset> resultDatasets = new ArrayList<Dataset>();
        ArrayList<BivariateFloatListFunction> functions = new ArrayList<BivariateFloatListFunction>();
        for (int i = 0; i < comparisons.length; ++i) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            TwoClassComparison c = comparisons[i];
            MarkerSelectionResult result = this.runOne(c, map, history);
            ProjectGENEEResultTreeNode[] nodes = result.nodes;
            functions.add(result.function);
            if (nodes.length == 0) {
                throw new RuntimeException("Wrong array length.");
            }
            String comparisonName = c.getComparisonName();
            if (comparisons.length == 1 && !"".equals(comparisonName) || comparisons.length > 1) {
                if ("".equals(comparisonName)) {
                    comparisonName = "Comparison " + (i + 1);
                }
                nodes[0].setNodeName(comparisonName);
                if (nodes.length == 2) {
                    nodes[1].setNodeName(comparisonName + " Permuted Scores");
                }
            }
            resultDatasets.add(nodes[0].getProject().getOriginalDataset());
            for (ProjectGENEEResultTreeNode node : nodes) {
                operationNode.add(node);
            }
        }
        if (saveScoreMatrix.booleanValue()) {
            RowMajorArray2DDataset scores = new RowMajorArray2DDataset("", ((Dataset)resultDatasets.get(0)).getRowCount(), resultDatasets.size());
            Vector ids = scores.getColumnMetadata().add("id", String.class);
            MetadataUtil.copy(((Dataset)resultDatasets.get(0)).getRowMetadata(), scores.getRowMetadata());
            for (BivariateFloatListFunction f : functions) {
                String name = f.toString();
                rowMetadataFields.remove(name);
            }
            for (String field : rowMetadataFields) {
                scores.getRowMetadata().remove(scores.getRowMetadata().getColumnIndex(field));
            }
            for (int j = 0; j < resultDatasets.size(); ++j) {
                Dataset d = (Dataset)resultDatasets.get(j);
                Vector scoreVector = d.getRowMetadata().get(((BivariateFloatListFunction)functions.get(j)).toString());
                int nrows = d.getRowCount();
                for (int i = 0; i < nrows; ++i) {
                    scores.setValue(i, j, ((Float)scoreVector.getValue(i)).floatValue());
                }
                ids.setValue(j, d.getName());
            }
            operationNode.add(new ProjectGENEEResultTreeNode(new DefaultProject(scores), history));
        }
        return operationNode;
    }

    protected MarkerSelectionResult runOne(TwoClassComparison comparison, Map<String, Object> map, History history) {
        int j;
        int cols;
        boolean dataIsInLogScale = (Boolean)map.get(IS_LOG_SCALE);
        int numMarkers = (Integer)map.get(NUMBER_OF_MARKERS);
        Dataset markerSelectionDataset = (Dataset)map.get("dataset");
        DefaultClassVector covariate = null;
        markerSelectionDataset = DatasetUtil.sliceView(markerSelectionDataset, null, comparison.getAllIndices());
        Object[] x = new String[markerSelectionDataset.getColumnCount()];
        Arrays.fill(x, "B");
        int length = comparison.getClassOneIndices().size();
        for (int i = 0; i < length; ++i) {
            x[i] = "A";
        }
        DefaultClassVector classVector = new DefaultClassVector(x, new String[]{"A", "B"});
        boolean includeAllColumns = (Boolean)map.get(INCLUDE_ALL_COLUMNS_IN_HEATMAP);
        boolean asymptotic = map.get(COMPUTE).equals(ASYMPTOTIC_P_VALUES);
        Integer permutations = asymptotic ? 0 : (Integer)map.get(PERMUTATIONS);
        if (permutations == null) {
            permutations = 0;
        }
        boolean complete = permutations < 0;
        int seed = asymptotic || complete ? 0 : (Integer)map.get(RANDOM_NUMBER_GENERATOR_SEED);
        boolean useMedian = asymptotic ? false : (Boolean)map.get(USE_MEDIAN);
        boolean thresholdStdev = asymptotic ? false : (Boolean)map.get(THRESHOLD_STDEV);
        BivariateFloatListFunction testStatisticFunction = (BivariateFloatListFunction)map.get(TEST_STATISTIC);
        if (testStatisticFunction instanceof RatioOfMedians) {
            ((RatioOfMedians)testStatisticFunction).setLogScale(dataIsInLogScale);
        }
        if (testStatisticFunction instanceof RatioOfMeans) {
            ((RatioOfMeans)testStatisticFunction).setLogScale(dataIsInLogScale);
        }
        if (testStatisticFunction instanceof AbstractTwoClassStatistic) {
            AbstractTwoClassStatistic f = (AbstractTwoClassStatistic)testStatisticFunction;
            f.setEnableMinStandardDeviationPercent(thresholdStdev);
            f.setUseMedian(useMedian);
        }
        if (asymptotic) {
            testStatisticFunction = new AsymptoticTTest();
        }
        int testDir = (Integer)((BasicMapEntry)map.get(TEST_DIRECTION)).getValue();
        if (testStatisticFunction instanceof FisherExactTest) {
            ((FisherExactTest)testStatisticFunction).setSide(testDir);
            asymptotic = true;
        }
        MarkerSelection ms = new MarkerSelection(markerSelectionDataset, classVector, permutations, testDir, false, complete, testStatisticFunction, seed, covariate, asymptotic, null);
        ms.setSavePermutedScores(asymptotic ? false : (Boolean)map.get(SAVE_PERMUTED_SCORES));
        ms.execute();
        complete = ms.isComplete();
        Dataset dataset = markerSelectionDataset;
        if (includeAllColumns) {
            dataset = (Dataset)map.get("dataset");
        }
        dataset = DatasetUtil.shallowCopy(dataset);
        MarkerSelectionAction.addResults(dataset, ms);
        Vector foldChangeVector = MetadataUtil.addRowVector(dataset.getRowMetadata(), "Fold Change", Float.class);
        Mean mean = new Mean();
        DatasetRowView rowView = new DatasetRowView(markerSelectionDataset);
        int rows = markerSelectionDataset.getRowCount();
        for (int i = 0; i < rows; ++i) {
            float ratio;
            rowView.setIndex(i);
            int[] classZeroIndices = classVector.getIndices(0);
            rowView.setIndices(classZeroIndices);
            float classZeroMean = mean.evaluate(rowView);
            int[] classOneIndices = classVector.getIndices(1);
            rowView.setIndices(classOneIndices);
            float classOneMean = mean.evaluate(rowView);
            if (dataIsInLogScale) {
                classZeroMean = InverseLog2.inverselog2(classZeroMean);
                classOneMean = InverseLog2.inverselog2(classOneMean);
            }
            if ((ratio = classZeroMean / classOneMean) < 1.0f) {
                ratio = -classOneMean / classZeroMean;
            }
            foldChangeVector.setValue(i, Float.valueOf(ratio));
        }
        float[][] permutedScores = ms.getSavedPermutedScores();
        DefaultProject newProject = new DefaultProject(dataset, (Project)map.get("project"));
        SortKeys.VectorSortKey rowSortKey = new SortKeys.VectorSortKey(testStatisticFunction.toString(), SortOrder.DESCENDING, true);
        List<ProjectSortKey> rowSortKeys = Arrays.asList(rowSortKey);
        newProject.setRowSortOrder(rowSortKeys);
        Vector comparisonVector = MetadataUtil.addColumnVector(dataset.getColumnMetadata(), comparison.getComparisonName(), String.class, true);
        Set<Integer> classOneIndices = comparison.getClassOneIndices();
        Set<Integer> classTwoIndices = comparison.getClassTwoIndices();
        if (includeAllColumns) {
            cols = dataset.getColumnCount();
            for (j = 0; j < cols; ++j) {
                if (classOneIndices.contains(j)) {
                    comparisonVector.setValue(j, "A");
                    continue;
                }
                if (!classTwoIndices.contains(j)) continue;
                comparisonVector.setValue(j, "B");
            }
        } else {
            cols = dataset.getColumnCount();
            for (j = 0; j < cols; ++j) {
                comparisonVector.setValue(j, j < classOneIndices.size() ? "A" : "B");
            }
        }
        SortKeys.VectorSortKey columnSortKey = new SortKeys.VectorSortKey(comparisonVector.getName(), SortOrder.ASCENDING, false);
        newProject.setColumnSortOrder(Arrays.asList(columnSortKey));
        if (numMarkers > 0) {
            CombinedFilter combinedFilter = new CombinedFilter();
            Filters.TopFilter topFilter = new Filters.TopFilter();
            topFilter.setTop(true);
            topFilter.setMetadataColumnName("Rank");
            topFilter.setN(numMarkers);
            combinedFilter.add(topFilter);
            Filters.TopFilter bottomFilter = new Filters.TopFilter();
            bottomFilter.setTop(false);
            bottomFilter.setMetadataColumnName("Rank");
            bottomFilter.setN(numMarkers);
            combinedFilter.add(bottomFilter);
            newProject.setRowFilter(combinedFilter);
            combinedFilter.fireFilterChanged();
        }
        ProjectGENEEResultTreeNode signatureNode = new ProjectGENEEResultTreeNode(newProject, history);
        ProjectGENEEResultTreeNode permutedScoresNode = null;
        if (permutedScores != null) {
            RowMajorArray2DDataset tmp = new RowMajorArray2DDataset("Permuted Scores", permutedScores);
            Dataset permutedDataset = DatasetUtil.transposeView(tmp);
            MetadataUtil.copy(dataset.getRowMetadata(), permutedDataset.getRowMetadata());
            DefaultProject permutedProject = new DefaultProject(permutedDataset, null);
            permutedScoresNode = new ProjectGENEEResultTreeNode(permutedProject, history);
        }
        return permutedScoresNode != null ? new MarkerSelectionResult(new ProjectGENEEResultTreeNode[]{signatureNode, permutedScoresNode}, testStatisticFunction) : new MarkerSelectionResult(new ProjectGENEEResultTreeNode[]{signatureNode}, testStatisticFunction);
    }

    private void toggleMoreOptions() {
        for (String name : this.getInputPanelBuilder().getParameterNames()) {
            this.getInputPanelBuilder().setVisible(name, this.moreOptionsVisible);
        }
        this.getInputPanelBuilder().setVisible(INCLUDE_ALL_COLUMNS_IN_HEATMAP, true);
        this.getInputPanelBuilder().setVisible(COMPARISON, true);
        this.getInputPanelBuilder().setVisible(IS_LOG_SCALE, true);
        this.getInputPanelBuilder().setVisible(NUMBER_OF_MARKERS, true);
        this.getInputPanelBuilder().setVisible(PERMUTATIONS, true);
        this.moreOptionsVisible = !this.moreOptionsVisible;
    }

    public static void addResults(Dataset dataset, MarkerSelection ms) {
        float[] pLow = null;
        float[] pHigh = null;
        float[] fwer = null;
        float[] maxT = null;
        if (!ms.isAsymptotic() && !ms.isComplete()) {
            pLow = ms.getLowerBound();
            pHigh = ms.getUpperBound();
        }
        int[] k = ms.getKArray();
        Vector kVector = null;
        if (!ms.isAsymptotic()) {
            fwer = ms.getFwer();
            maxT = ms.getMaxT();
        }
        float[] fdr = ms.getFdr();
        float[] p = ms.getRowSpecificPValues();
        int permutations = ms.getNumPermutations();
        if (!ms.isAsymptotic() && !ms.isComplete() && permutations == 0) {
            fdr = null;
            p = null;
            fwer = null;
            pLow = null;
            pHigh = null;
        }
        float[] scores = ms.getScores();
        int[] index = Sorting.index(scores, false);
        int[] ranks = Sorting.rank(index);
        Vector scoreVector = MetadataUtil.addRowVector(dataset.getRowMetadata(), ms.getFunction().toString(), Float.class);
        Vector rankVector = MetadataUtil.addRowVector(dataset.getRowMetadata(), "Rank", Integer.class);
        Vector pValueVector = null;
        Vector fdrVector = null;
        Vector bonferroniVector = null;
        if (p != null) {
            pValueVector = MetadataUtil.addRowVector(dataset.getRowMetadata(), "p-value", Float.class);
            fdrVector = MetadataUtil.addRowVector(dataset.getRowMetadata(), "FDR(BH)", Float.class);
            bonferroniVector = MetadataUtil.addRowVector(dataset.getRowMetadata(), "Bonferroni", Float.class);
        }
        if (!ms.isAsymptotic() && p != null) {
            kVector = MetadataUtil.addRowVector(dataset.getRowMetadata(), "k", Float.class);
        }
        Vector pValueLowVector = null;
        Vector pValueHighVector = null;
        if (pLow != null) {
            pValueLowVector = MetadataUtil.addRowVector(dataset.getRowMetadata(), "p-value low", Float.class);
            pValueHighVector = MetadataUtil.addRowVector(dataset.getRowMetadata(), "p-value high", Float.class);
        }
        Vector fwerVector = null;
        Vector maxTVector = null;
        if (fwer != null) {
            fwerVector = MetadataUtil.addRowVector(dataset.getRowMetadata(), "FWER", Float.class);
            maxTVector = MetadataUtil.addRowVector(dataset.getRowMetadata(), "maxT", Float.class);
        }
        int rows = dataset.getRowCount();
        for (int i = 0; i < rows; ++i) {
            scoreVector.setValue(i, Float.valueOf(scores[i]));
            rankVector.setValue(i, ranks[i]);
            if (p != null) {
                pValueVector.setValue(i, Float.valueOf(p[i]));
                fdrVector.setValue(i, Float.valueOf(fdr[i]));
                bonferroniVector.setValue(i, Float.valueOf(ms.getBonferroni(i)));
            }
            if (kVector != null) {
                kVector.setValue(i, k[i]);
            }
            if (pLow != null) {
                pValueLowVector.setValue(i, Float.valueOf(pLow[i]));
                pValueHighVector.setValue(i, Float.valueOf(pHigh[i]));
            }
            if (fwer == null) continue;
            fwerVector.setValue(i, Float.valueOf(fwer[i]));
            maxTVector.setValue(i, Float.valueOf(maxT[i]));
        }
    }

    public static void validateComparison(int classOne, int classTwo) {
        if (classOne == 0 && classTwo == 0) {
            throw new RuntimeException("Please assign columns to class A and class B.");
        }
        if (classOne == 0) {
            throw new RuntimeException("Please assign columns to class A.");
        }
        if (classTwo == 0) {
            throw new RuntimeException("Please assign columns to class B.");
        }
    }

    private static class MarkerSelectionResult {
        BivariateFloatListFunction function;
        ProjectGENEEResultTreeNode[] nodes;

        public MarkerSelectionResult(ProjectGENEEResultTreeNode[] nodes, BivariateFloatListFunction function) {
            this.nodes = nodes;
            this.function = function;
        }
    }
}

