/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.swing.KeyStroke;
import javax.swing.tree.MutableTreeNode;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.gui.AbstractGenericInputAction;
import org.broadinstitute.genee.gui.BlockingThread;
import org.broadinstitute.genee.gui.FileChooserUtil;
import org.broadinstitute.genee.gui.IconManager;
import org.broadinstitute.genee.gui.ProgressNotifier;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.parameters.ComboBoxParameter;
import org.broadinstitute.genee.gui.parameters.IntegerInputParameter;
import org.broadinstitute.genee.gui.parameters.MetadataComboBoxInputParameter;
import org.broadinstitute.genee.gui.parameters.TextFieldInputParameter;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.matrix.geneset.GeneSet;
import org.broadinstitute.genee.io.matrix.geneset.GeneSetIO;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ProjectIO;
import org.broadinstitute.genee.io.util.ToStringUtil;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.geneset.DefaultGeneSet;
import org.broadinstitute.genee.matrix.geneset.DefaultGeneSetMatrix;
import org.broadinstitute.genee.matrix.geneset.GeneSetMatrix;
import org.broadinstitute.genee.stats.Sorting;

public class SaveDatasetAction
extends AbstractGenericInputAction<Void> {
    private static final String BASE_OUTPUT_FILE_NAME_PARAM = "Base output file name";
    private static final FileFormat[] DEFAULT_FILE_FORMATS = new FileFormat[]{new FileFormat("GCT Version 1.3", "gct", ".gct"), new FileFormat("GCT Version 1.2", "gct#1.2", ".gct"), new FileFormat("GCTX", "gctx", ".gctx"), new FileFormat("Tab Delimited", "txt", ".txt", ".tab", ".xls", ".xlsx"), new FileFormat("Tableau Tab Delimited", "Tableau", ".tab", ".txt"), new FileFormat("GMT", "gmt", ".gmt")};
    private static final String FILE_FORMAT_PARAM = "File Format";
    private static final String RANKED_BY_PARAM = "Ranked By";
    private static final String ID_FOR_RANKED_BY_PARAM = "Identifier";
    private static final String N_GENES_PARAM = "Number of up/down genes";
    private TextFieldInputParameter baseOutputFileNameTextField;
    private ActionListener fileFormatsActionListener;
    private ComboBoxParameter fileFormatsComboBox;
    private Project project;
    private ComboBoxParameter rankedListByComboBox;
    private MetadataComboBoxInputParameter rankIdComboBox;

    public SaveDatasetAction() {
        super("Save Dataset");
        this.putValue("ShortDescription", "Save Dataset");
        this.putValue("SmallIcon", IconManager.loadIcon("16x16/43215.sc_savebasicas.png"));
        this.setResetButtonVisible(false);
        this.setRunInBackground(false);
        this.fileFormatsComboBox = new ComboBoxParameter((Object[])DEFAULT_FILE_FORMATS, DEFAULT_FILE_FORMATS[0]);
        this.fileFormatsActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileFormat fileFormat = (FileFormat)SaveDatasetAction.this.fileFormatsComboBox.getSelectedItem();
                SaveDatasetAction.this.getInputPanelBuilder().setVisible(SaveDatasetAction.N_GENES_PARAM, fileFormat == null ? false : fileFormat.formatName.equals("gmt"));
                SaveDatasetAction.this.getInputPanelBuilder().setVisible(SaveDatasetAction.RANKED_BY_PARAM, fileFormat == null ? false : fileFormat.formatName.equals("rnk") || fileFormat.formatName.equals("grp"));
                SaveDatasetAction.this.getInputPanelBuilder().setVisible(SaveDatasetAction.ID_FOR_RANKED_BY_PARAM, fileFormat == null ? false : fileFormat.formatName.equals("rnk") || fileFormat.formatName.equals("gmt"));
                SaveDatasetAction.this.getInputPanelBuilder().setVisible(SaveDatasetAction.BASE_OUTPUT_FILE_NAME_PARAM, fileFormat == null ? false : fileFormat.formatName.equals("grp") || fileFormat.formatName.equals("gmt"));
                SaveDatasetAction.this.pack();
            }
        };
        this.rankedListByComboBox = new ComboBoxParameter(String.class);
        this.rankIdComboBox = new MetadataComboBoxInputParameter(true);
        this.addParameter(FILE_FORMAT_PARAM, this.fileFormatsComboBox, false);
        this.addParameter(RANKED_BY_PARAM, this.rankedListByComboBox, false);
        this.addParameter(ID_FOR_RANKED_BY_PARAM, this.rankIdComboBox, false);
        this.baseOutputFileNameTextField = new TextFieldInputParameter();
        this.addParameter(BASE_OUTPUT_FILE_NAME_PARAM, this.baseOutputFileNameTextField, false);
        this.addParameter(N_GENES_PARAM, new IntegerInputParameter(50), false);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, UIUtil.getMenuShortcutKeyMask() | 1));
    }

    @Override
    public boolean beforeWindowShown() {
        this.fileFormatsComboBox.removeActionListener(this.fileFormatsActionListener);
        Project project = this.getProject();
        boolean cdt = false;
        boolean rnk = false;
        if (project != null) {
            cdt = project.getRowDendrogram() != null || project.getColumnDendrogram() != null;
            MetadataModel numberMetadata = MetadataUtil.getColumns(project.getOriginalDataset().getRowMetadata(), Number.class);
            rnk = numberMetadata.getMetadataCount() > 0;
            Object rankedBy = this.rankedListByComboBox.getSelectedItem();
            this.rankedListByComboBox.removeAllItems();
            int size = numberMetadata.getMetadataCount();
            for (int i = 0; i < size; ++i) {
                this.rankedListByComboBox.addItem(numberMetadata.get(i).getName());
            }
            if (rankedBy != null) {
                this.rankedListByComboBox.setSelectedItem(rankedBy);
            } else if (this.rankedListByComboBox.getItemCount() > 0) {
                this.rankedListByComboBox.setSelectedIndex(0);
            }
            this.rankIdComboBox.init(project);
        }
        Object selectedFileFormat = this.fileFormatsComboBox.getSelectedItem();
        this.fileFormatsComboBox.removeAllItems();
        ArrayList<FileFormat> options = new ArrayList<FileFormat>();
        options.addAll(Arrays.asList(DEFAULT_FILE_FORMATS));
        if (cdt) {
            FileFormat cdtFileFormat = new FileFormat("Clustered Data Table", "cdt", ".cdt");
            options.add(cdtFileFormat);
        }
        if (rnk) {
            FileFormat rnkFileFormat = new FileFormat("Ranked List", "rnk", ".rnk");
            options.add(rnkFileFormat);
            FileFormat grpFileFormat = new FileFormat("GRP", "grp", ".grp");
            options.add(grpFileFormat);
        }
        Collections.sort(options, new Comparator<FileFormat>(){

            @Override
            public int compare(FileFormat o1, FileFormat o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        for (FileFormat option : options) {
            this.fileFormatsComboBox.addItem(option);
        }
        this.fileFormatsComboBox.addActionListener(this.fileFormatsActionListener);
        this.fileFormatsComboBox.setSelectedItem(selectedFileFormat);
        this.fileFormatsActionListener.actionPerformed(null);
        return true;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    @Override
    protected void customizeMap(Project p, Map<String, Object> map) {
        if (this.project != null) {
            map.put("project", this.project);
        }
    }

    @Override
    protected Void execute(Map<String, Object> map, ProgressNotifier status) throws Exception {
        final FileFormat fileFormat = (FileFormat)map.get(FILE_FORMAT_PARAM);
        final Project project = (Project)map.get("project");
        if (fileFormat.formatName.equals("gmt")) {
            final String metadataId = (String)map.get(ID_FOR_RANKED_BY_PARAM);
            final Integer nGenes = (Integer)map.get(N_GENES_PARAM);
            if (nGenes < 1) {
                throw new RuntimeException("Number of genes must be greater than zero");
            }
            final String baseFileName = (String)map.get(BASE_OUTPUT_FILE_NAME_PARAM);
            if ("".equals(baseFileName)) {
                throw new RuntimeException("Please enter a value for Base output file name.");
            }
            final File directory = FileChooserUtil.showSelectDirectoryDialog(this.getInputPanelBuilder().getFormBuilder().getPanel(), "Select Output Directory");
            if (directory == null) {
                return null;
            }
            new BlockingThread("Saving GMT files to " + directory.getName(), true){

                @Override
                public void doInBackground() throws Exception {
                    Dataset dataset = project.getSortedFilteredDataset();
                    MetadataModel metadata = dataset.getRowMetadata();
                    Vector ids = dataset.getRowMetadata().get(metadataId);
                    ArrayList<GeneSet> upList = new ArrayList<GeneSet>();
                    ArrayList<GeneSet> dnList = new ArrayList<GeneSet>();
                    int ncols = dataset.getColumnCount();
                    for (int j = 0; j < ncols; ++j) {
                        ArrayList<Sorting.FloatIntPair> list = new ArrayList<Sorting.FloatIntPair>();
                        int nrows = dataset.getRowCount();
                        for (int i = 0; i < nrows; ++i) {
                            float value = dataset.getValue(i, j);
                            if (Float.isNaN(value)) continue;
                            list.add(new Sorting.FloatIntPair(value, i));
                        }
                        int[] index = Sorting.index(list.toArray(new Sorting.FloatIntPair[0]), true);
                        LinkedHashSet<String> dn = new LinkedHashSet<String>();
                        int length = Math.min(nGenes, index.length);
                        for (int i = 0; i < length; ++i) {
                            dn.add(ids.getValue(index[i]).toString());
                        }
                        LinkedHashSet<String> up = new LinkedHashSet<String>();
                        int i = 0;
                        int length2 = Math.min(nGenes, index.length);
                        int k = index.length - 1;
                        while (i < length2) {
                            up.add(ids.getValue(index[k]).toString());
                            ++i;
                            --k;
                        }
                        String name = ToStringUtil.toString(dataset.getColumnMetadata(), j, "_");
                        upList.add(new DefaultGeneSet(name + "_UP", up));
                        dnList.add(new DefaultGeneSet(name + "_DN", dn));
                    }
                    GeneSetIO.saveGmt((GeneSetMatrix)new DefaultGeneSetMatrix("", dnList), new File(directory, baseFileName + "_DN.gmt").getCanonicalPath());
                    GeneSetIO.saveGmt((GeneSetMatrix)new DefaultGeneSetMatrix("", upList), new File(directory, baseFileName + "_UP.gmt").getCanonicalPath());
                }
            };
            return null;
        }
        if (fileFormat.formatName.equals("grp")) {
            final String rankedBy = (String)map.get(RANKED_BY_PARAM);
            final String baseFileName = (String)map.get(BASE_OUTPUT_FILE_NAME_PARAM);
            if ("".equals(baseFileName)) {
                throw new RuntimeException("Please enter a value for Base output file name.");
            }
            final File directory = FileChooserUtil.showSelectDirectoryDialog(this.fileFormatsComboBox, "Select Output Directory");
            if (directory == null) {
                return null;
            }
            new BlockingThread("Saving GRP files to " + directory.getName(), true){

                @Override
                public void doInBackground() throws Exception {
                    PrintWriter up = new PrintWriter(new BufferedWriter(new FileWriter(new File(directory, baseFileName + "-up.grp"))));
                    PrintWriter down = new PrintWriter(new BufferedWriter(new FileWriter(new File(directory, baseFileName + "-dn.grp"))));
                    Dataset dataset = project.getSortedFilteredDataset();
                    MetadataModel metadata = dataset.getRowMetadata();
                    Vector ids = dataset.getRowMetadata().get(0);
                    Vector valueVector = metadata.get(rankedBy);
                    int nrows = dataset.getRowCount();
                    for (int i = 0; i < nrows; ++i) {
                        Number value = (Number)valueVector.getValue(i);
                        if (value == null) continue;
                        float floatValue = value.floatValue();
                        if (floatValue > 0.0f) {
                            up.println(Formatter.toString(ids.getValue(i)));
                            continue;
                        }
                        if (!(floatValue < 0.0f)) continue;
                        down.println(Formatter.toString(ids.getValue(i)));
                    }
                    up.close();
                    down.close();
                }
            };
            return null;
        }
        final File file = FileChooserUtil.showSaveDialog(UIUtil.getCurrentFrame(), fileFormat.extensions, null);
        if (file == null) {
            return null;
        }
        if (fileFormat.formatName.equals("rnk")) {
            final String rankedBy = (String)map.get(RANKED_BY_PARAM);
            final String metadataId = (String)map.get(ID_FOR_RANKED_BY_PARAM);
            new BlockingThread("Saving " + file.getName(), true){

                @Override
                public void doInBackground() throws Exception {
                    PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(file)));
                    Dataset dataset = project.getSortedFilteredDataset();
                    MetadataModel metadata = dataset.getRowMetadata();
                    int columnIndex = metadata.getColumnIndex(rankedBy);
                    pw.println("Name\tScore");
                    Vector ids = dataset.getRowMetadata().get(metadataId);
                    int nrows = dataset.getRowCount();
                    for (int i = 0; i < nrows; ++i) {
                        pw.print(Formatter.toString(ids.getValue(i)));
                        pw.print("\t");
                        pw.println(Formatter.format((Number)metadata.get(columnIndex).getValue(i)));
                    }
                    pw.close();
                }
            };
        } else {
            new BlockingThread("Saving " + file.getName(), true){

                @Override
                public void doInBackground() throws Exception {
                    ProjectIO.writeProject(project, fileFormat.formatName, IOUtil.getPath(file), false);
                }
            };
        }
        return null;
    }

    protected Project getProject() {
        return this.project != null ? this.project : Application.getProject();
    }

    @Override
    protected void succeeded(Map<String, Object> map, MutableTreeNode parentNode, Void result) {
    }

    private static class FileFormat {
        private String[] extensions;
        private String formatName;
        private String ui;

        public FileFormat(String ui, String formatName, String ... extensions) {
            this.ui = ui;
            this.extensions = extensions;
            this.formatName = formatName;
        }

        public String toString() {
            return this.ui;
        }

        public int hashCode() {
            return this.formatName.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof FileFormat) {
                return this.formatName.equals(((FileFormat)object).formatName);
            }
            return false;
        }
    }
}

