/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.actions;

import gnu.trove.list.array.TIntArrayList;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEWindow;
import org.broadinstitute.genee.application.GENEEWindowNotifier;
import org.broadinstitute.genee.filter.AbstractFilter;
import org.broadinstitute.genee.filter.CombinedFilter;
import org.broadinstitute.genee.filter.Filters;
import org.broadinstitute.genee.gui.Combination;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.TimerTextField;
import org.broadinstitute.genee.gui.TwoClassComparisonComponent;
import org.broadinstitute.genee.gui.parameters.TwoClassComparison;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.ProjectEvent;
import org.broadinstitute.genee.heatmap.ProjectListener;
import org.broadinstitute.genee.heatmap.ProjectSortKey;
import org.broadinstitute.genee.heatmap.SortKeys;
import org.broadinstitute.genee.heatmap.SortOrder;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.math.stat.function.bivariate.SignalToNoise;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetRowView;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.stats.Sorting;

public class SignatureBrowserAction
extends AbstractAction
implements GENEEWindowNotifier,
ProjectListener {
    private GENEEWindow dialog;
    private TwoClassComparisonComponent twoClassComparisonComponent;
    private Project project;
    private JTextField numberOfMarkersInput;
    private JCheckBox adjustStandardDeviationCheckBox;
    private JCheckBox useMedianCheckBox;

    public SignatureBrowserAction() {
        super("Signature Browser\u2026");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.dialog == null) {
            FormBuilder fb = new FormBuilder();
            fb.nextRow();
            fb.addLabel("Signatures:");
            this.twoClassComparisonComponent = new TwoClassComparisonComponent(true, false, "Negative Control", "Signatures"){

                @Override
                protected List<Combination> createCombinations(Dataset dataset, List<Combination> combinations, List<String> selectedMetadataNames, boolean intersection, boolean classA) {
                    if (classA) {
                        return super.createCombinations(dataset, combinations, selectedMetadataNames, intersection, classA);
                    }
                    return combinations;
                }
            };
            fb.add(this.twoClassComparisonComponent.getJComponent());
            fb.nextRow();
            fb.addLabel("Number of markers:");
            this.numberOfMarkersInput = new TimerTextField("50"){

                @Override
                public void update() {
                    SignatureBrowserAction.this.updateView();
                }
            };
            fb.add(this.numberOfMarkersInput);
            fb.nextRow();
            this.adjustStandardDeviationCheckBox = new JCheckBox("Ensure standard deviation is at least 20% of the class mean/median", true);
            fb.addSpanned(this.adjustStandardDeviationCheckBox);
            this.useMedianCheckBox = new JCheckBox("Use median instead of mean", false);
            fb.nextRow();
            fb.addSpanned(this.useMedianCheckBox);
            this.dialog = Application.getWindowManager().createInputWindow("Signature Browser", this);
            this.dialog.getContentPane().add(fb.getPanel());
            this.adjustStandardDeviationCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SignatureBrowserAction.this.updateView();
                }
            });
            this.useMedianCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SignatureBrowserAction.this.updateView();
                }
            });
            this.twoClassComparisonComponent.addComparisonListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    SignatureBrowserAction.this.updateView();
                }
            });
            this.dialog.pack();
        }
        this.dialog.setVisible(true);
    }

    @Override
    public void notifyHidden() {
        this.project.removeProjectListener(this);
    }

    @Override
    public void notifyShowing() {
        Project project;
        this.project = project = Application.getProject();
        project.addProjectListener(this);
        this.twoClassComparisonComponent.init(project);
    }

    @Override
    public void projectChanged(ProjectEvent e) {
    }

    private void updateView() {
        Dataset dataset = this.project.getOriginalDataset();
        boolean useMedian = this.useMedianCheckBox.isSelected();
        boolean adjust = this.adjustStandardDeviationCheckBox.isSelected();
        SignalToNoise f = new SignalToNoise();
        f.setUseMedian(useMedian);
        f.setEnableMinStandardDeviationPercent(adjust);
        TwoClassComparison[] comparisons = this.twoClassComparisonComponent.getTwoClassComparisons();
        Dataset controlDataset = DatasetUtil.sliceView(dataset, null, IOUtil.toIntArray(comparisons[0].getClassOneIndices()));
        Vector signatureVector = MetadataUtil.addColumnVector(dataset.getColumnMetadata(), "Signature", Integer.class);
        int size = signatureVector.size();
        for (int j = 0; j < size; ++j) {
            signatureVector.setValue(j, Integer.MAX_VALUE);
        }
        Set<Integer> classOneIndices = comparisons[0].getClassOneIndices();
        if (classOneIndices.size() == 0) {
            return;
        }
        TIntArrayList testIndices = new TIntArrayList();
        for (TwoClassComparison c : comparisons) {
            testIndices.addAll(IOUtil.toIntArray(c.getClassTwoIndices()));
        }
        if (testIndices.size() == 0) {
            return;
        }
        for (Integer index : classOneIndices) {
            signatureVector.setValue(index, 0);
        }
        for (int i = 0; i < comparisons.length; ++i) {
            TwoClassComparison c = comparisons[i];
            for (Integer index : c.getClassTwoIndices()) {
                signatureVector.setValue(index, i + 1);
            }
        }
        DatasetRowView controlRowView = new DatasetRowView(controlDataset);
        int numMarkers = Integer.parseInt(this.numberOfMarkersInput.getText().trim());
        float[] values = new float[dataset.getRowCount()];
        Dataset testDataset = DatasetUtil.sliceView(dataset, null, testIndices.toArray());
        DatasetRowView testRowView = new DatasetRowView(testDataset);
        int nrows = dataset.getRowCount();
        for (int i = 0; i < nrows; ++i) {
            testRowView.setIndex(i);
            controlRowView.setIndex(i);
            values[i] = f.evaluate(controlRowView, testRowView);
        }
        int[] index = Sorting.index(values, false);
        int[] ranks = Sorting.rank(index);
        this.project.setColumnFilter(new AbstractFilter(){
            Vector vector;

            @Override
            public void init(Object object) {
                Dataset dataset = (Dataset)object;
                this.vector = dataset.getRowMetadata().get("Signature");
            }

            @Override
            public boolean accept(int index) {
                return Integer.MAX_VALUE != (Integer)this.vector.getValue(index);
            }

            @Override
            public boolean isEmpty() {
                return false;
            }
        });
        Vector rankVector = MetadataUtil.addRowVector(dataset.getRowMetadata(), "Rank", Integer.class);
        int nrows2 = dataset.getRowCount();
        for (int i = 0; i < nrows2; ++i) {
            rankVector.setValue(i, ranks[i]);
        }
        ArrayList<SortKeys.VectorSortKey> columnSortOrder = new ArrayList<SortKeys.VectorSortKey>();
        columnSortOrder.add(new SortKeys.VectorSortKey("Signature", SortOrder.DESCENDING, false));
        this.project.setColumnSortOrder(columnSortOrder);
        this.project.setColumnGroupBy(columnSortOrder.toArray(new ProjectSortKey[0]));
        SortKeys.VectorSortKey rowSortKey = new SortKeys.VectorSortKey("Rank", SortOrder.DESCENDING, true);
        List<ProjectSortKey> rowSortKeys = Arrays.asList(rowSortKey);
        this.project.setRowSortOrder(rowSortKeys);
        if (numMarkers > 0) {
            CombinedFilter combinedFilter = new CombinedFilter();
            Filters.TopFilter topFilter = new Filters.TopFilter();
            topFilter.setTop(true);
            topFilter.setMetadataColumnName("Rank");
            topFilter.setN(numMarkers);
            combinedFilter.add(topFilter);
            Filters.TopFilter bottomFilter = new Filters.TopFilter();
            bottomFilter.setTop(false);
            bottomFilter.setMetadataColumnName("Rank");
            bottomFilter.setN(numMarkers);
            combinedFilter.add(bottomFilter);
            this.project.setRowFilter(combinedFilter);
            combinedFilter.fireFilterChanged();
        }
    }
}

