/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.tree.MutableTreeNode;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.ComponentCustomizer;
import org.broadinstitute.genee.application.GENEEFolderNode;
import org.broadinstitute.genee.application.History;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.application.ViewableGENEETreeNode;
import org.broadinstitute.genee.gui.AbstractInputAction;
import org.broadinstitute.genee.gui.Drawable;
import org.broadinstitute.genee.gui.DrawableWrapper;
import org.broadinstitute.genee.gui.ProgressNotifier;
import org.broadinstitute.genee.gui.actions.SynergyCalculator;
import org.broadinstitute.genee.gui.actions.SynergyCompoundHeatMaps;
import org.broadinstitute.genee.gui.parameters.CheckBoxParameter;
import org.broadinstitute.genee.gui.parameters.ComboBoxParameter;
import org.broadinstitute.genee.gui.parameters.FileInputParameter;
import org.broadinstitute.genee.gui.parameters.HiddenInputLabel;
import org.broadinstitute.genee.gui.parameters.MetadataCheckBoxListParameter;
import org.broadinstitute.genee.gui.parameters.MetadataComboBoxInputParameter;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.GENEEResultNodeGroup;
import org.broadinstitute.genee.heatmap.HeatMapColorSchemeOptionsPanel;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.SortKeys;
import org.broadinstitute.genee.heatmap.SortOrder;
import org.broadinstitute.genee.heatmap.menu.GENEEMenuBar;
import org.broadinstitute.genee.heatmap.menu.HorizontalDrawableArray;
import org.broadinstitute.genee.heatmap.menu.VerticalDrawableArray;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.io.util.ImageUtil;
import org.broadinstitute.genee.math.stat.function.Mean;
import org.broadinstitute.genee.math.stat.function.UnivariateFloatFunction;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.Vector;

public class SynergyAction
extends AbstractInputAction {
    private static final String STANDARD = "Standard, formula is combo - (a + b)";
    private static final String BLISS = "Bliss independence model, formula is combo - (a + b - a * b)";
    private static final String COMPOUND1_FIELD = "Compound one field";
    private static final String COMPOUND2_FIELD = "Compound two field";
    private static final String CONC1_FIELD = "Concentration one field";
    private static final String CONC2_FIELD = "Concentration two field";
    private static final String COMPUTE_SYNERGY = "Additional fields that identify a treament";
    private static final String COMPUTE_SYNERGY_DESC = "In addition to the compound and concentration fields, additional fields that uniquely identify a treatment combination.";
    private static final String[] INPUT_VALUE_OPTIONS = new String[]{"Inhibition (0-100)", "% Inhibition (0-1)", "Viability (0-100)", "% Viability (0-1)"};
    private static final String SYNERGY_CALC = "Synergy calculation";
    private static final String INPUT_VALUES = "Input values are";
    private static final String EXPORT_HEAT_MAPS_FIELD = "Save synergy heat maps";
    private static final String EXPORT_DIR_FIELD = "Directory to save synergy heat maps";

    public SynergyAction() {
        super("Synergy");
        this.addParameter(INPUT_VALUES, new ComboBoxParameter((Object[])INPUT_VALUE_OPTIONS, 2), true);
        this.addParameter(COMPOUND1_FIELD, new MetadataComboBoxInputParameter(true), true);
        this.addParameter(COMPOUND2_FIELD, new MetadataComboBoxInputParameter(true), true);
        this.addParameter(CONC1_FIELD, new MetadataComboBoxInputParameter(true, Number.class), true);
        this.addParameter(CONC2_FIELD, new MetadataComboBoxInputParameter(true, Number.class), true);
        this.addParameter(COMPUTE_SYNERGY, new MetadataCheckBoxListParameter(true, null), COMPUTE_SYNERGY_DESC, true);
        this.addParameter(SYNERGY_CALC, new ComboBoxParameter((Object[])new String[]{BLISS, STANDARD}, 1), true);
        this.addParameter(new HiddenInputLabel(EXPORT_HEAT_MAPS_FIELD), new CheckBoxParameter(EXPORT_HEAT_MAPS_FIELD), true);
        this.addParameter(EXPORT_DIR_FIELD, new FileInputParameter(FileInputParameter.OPEN_DIRECTORY), false);
        this.getInputPanelBuilder().setEnabled(EXPORT_DIR_FIELD, false);
        final JCheckBox cb = (JCheckBox)this.getInputPanelBuilder().getInputParameter(EXPORT_HEAT_MAPS_FIELD).getJComponent();
        cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SynergyAction.this.getInputPanelBuilder().setEnabled(SynergyAction.EXPORT_DIR_FIELD, cb.isEnabled());
            }
        });
    }

    @Override
    public boolean beforeWindowShown() {
        Project p = Application.getProject();
        if (p != null) {
            this.getInputPanelBuilder().getInputParameter(COMPOUND1_FIELD).init(p);
            this.getInputPanelBuilder().getInputParameter(COMPOUND2_FIELD).init(p);
            this.getInputPanelBuilder().getInputParameter(CONC1_FIELD).init(p);
            this.getInputPanelBuilder().getInputParameter(CONC2_FIELD).init(p);
            this.getInputPanelBuilder().getInputParameter(COMPUTE_SYNERGY).init(p);
        }
        return true;
    }

    @Override
    protected MutableTreeNode execute(Map<String, Object> map, ProgressNotifier status) throws Exception {
        String compound2Field;
        History history = this.getHistory(map);
        Dataset filteredSortedDataset = (Dataset)map.get("dataset");
        String concentration1Field = (String)map.get(CONC1_FIELD);
        String concentration2Field = (String)map.get(CONC2_FIELD);
        String compound1Field = (String)map.get(COMPOUND1_FIELD);
        if (compound1Field.equals(compound2Field = (String)map.get(COMPOUND2_FIELD))) {
            throw new RuntimeException("Please choose different fields that identify compound 1 and compound 2.");
        }
        if (concentration1Field.equals(concentration2Field)) {
            throw new RuntimeException("Please choose different fields that identify concentration 1 and concentration 2.");
        }
        boolean bliss = map.get(SYNERGY_CALC).equals(BLISS);
        File[] exportSynergyHeatMapDir = (File[])map.get(EXPORT_DIR_FIELD);
        boolean exportSynergyHeatMaps = (Boolean)map.get(EXPORT_HEAT_MAPS_FIELD);
        if (exportSynergyHeatMaps && exportSynergyHeatMapDir.length == 0) {
            throw new RuntimeException("Please provide a directory to save the heat maps.");
        }
        HashSet<Object> additionalFieldsSet = new HashSet<Object>(Arrays.asList((Object[])map.get(COMPUTE_SYNERGY)));
        additionalFieldsSet.remove(concentration1Field);
        additionalFieldsSet.remove(concentration2Field);
        additionalFieldsSet.remove(compound1Field);
        additionalFieldsSet.remove(compound2Field);
        String[] additionalFields = additionalFieldsSet.toArray(new String[0]);
        String inputValue = (String)map.get(INPUT_VALUES);
        UnivariateFloatFunction transformation = inputValue.equals(INPUT_VALUE_OPTIONS[2]) ? new UnivariateFloatFunction(){

            @Override
            public float evaluate(float x) {
                return (100.0f - x) / 100.0f;
            }
        } : (inputValue.equals(INPUT_VALUE_OPTIONS[3]) ? new UnivariateFloatFunction(){

            @Override
            public float evaluate(float x) {
                return 100.0f - x;
            }
        } : (inputValue.equals(INPUT_VALUE_OPTIONS[0]) ? new UnivariateFloatFunction(){

            @Override
            public float evaluate(float x) {
                return x / 100.0f;
            }
        } : new UnivariateFloatFunction(){

            @Override
            public float evaluate(float x) {
                return x;
            }
        }));
        SynergyCalculator calc = new SynergyCalculator(filteredSortedDataset, concentration1Field, concentration2Field, compound1Field, compound2Field, bliss, additionalFields, transformation);
        calc.execute();
        DefaultProject newSynergyProject = new DefaultProject(calc.getSynergy(), (Project)map.get("project"));
        DefaultProject viabilityProject = new DefaultProject(calc.getViability());
        ViewableGENEETreeNode activeNode = (ViewableGENEETreeNode)map.get("active.node");
        SynergyCompoundHeatMaps syn = new SynergyCompoundHeatMaps(concentration1Field, concentration2Field, compound1Field, compound2Field, additionalFields, newSynergyProject, viabilityProject);
        SynergyCustomizer synergyCustomizer1 = new SynergyCustomizer(syn, true);
        SynergyCustomizer synergyCustomizer2 = new SynergyCustomizer(syn, false);
        ProjectGENEEResultTreeNode synergyNode = new ProjectGENEEResultTreeNode((Project)newSynergyProject, history, synergyCustomizer1);
        ProjectGENEEResultTreeNode viabilityNode = new ProjectGENEEResultTreeNode((Project)viabilityProject, history, synergyCustomizer2);
        HeatMapPanel synergyHeatMapPanel = (HeatMapPanel)synergyNode.getDisplayInfo().getComponent();
        HeatMapPanel viabilityHeatMapPanel = (HeatMapPanel)activeNode.getDisplayInfo().getComponent();
        synergyCustomizer1.init(synergyHeatMapPanel, viabilityHeatMapPanel);
        synergyCustomizer2.init(synergyHeatMapPanel, viabilityHeatMapPanel);
        GENEEResultNodeGroup group = new GENEEResultNodeGroup();
        synergyNode.setGroup(group);
        group.setParentNode(synergyNode);
        viabilityNode.setGroup(group);
        group.addChild(viabilityNode);
        ArrayList<SortKeys.VectorSortKey> sortOrder = new ArrayList<SortKeys.VectorSortKey>();
        for (String field : additionalFields) {
            sortOrder.add(new SortKeys.VectorSortKey(field, SortOrder.ASCENDING, true));
        }
        sortOrder.add(new SortKeys.VectorSortKey(concentration1Field, SortOrder.DESCENDING, true));
        sortOrder.add(new SortKeys.VectorSortKey(concentration2Field, SortOrder.DESCENDING, true));
        newSynergyProject.setRowSortOrder(sortOrder);
        Dataset summarySynergyScores = calc.createSummarySynergyScoreMatrix(new Mean());
        ProjectGENEEResultTreeNode scoreNode = new ProjectGENEEResultTreeNode((Project)new DefaultProject(summarySynergyScores), history, new ComponentCustomizer(){

            @Override
            public boolean inherits() {
                return false;
            }

            @Override
            public void customize(Component c) {
                HeatMapPanel p = (HeatMapPanel)c;
                HeatMapColorSchemeOptionsPanel.loadPredefinedColorScheme(p.getColorScheme(), "synergy");
            }
        });
        GENEEFolderNode folder = new GENEEFolderNode((String)map.get("Operation"), history, synergyNode, viabilityNode, scoreNode);
        if (exportSynergyHeatMapDir != null && exportSynergyHeatMapDir.length > 0) {
            File outputDir = exportSynergyHeatMapDir[0];
            outputDir.mkdirs();
            List<Dataset[]> allSynergyDatasets = syn.createSynergyAndViabilityDatasets(null, null);
            String[] cellNames = new String[]{"Cell", "cell", "cell line", "Name", "id", "Id"};
            Vector cellVector = null;
            for (String name : cellNames) {
                cellVector = syn.getSynergyProject().getOriginalDataset().getColumnMetadata().get(name);
                if (cellVector != null) break;
            }
            if (cellVector == null) {
                cellVector = syn.getSynergyProject().getOriginalDataset().getColumnMetadata().get(0);
            }
            HashMap<String, ArrayList<Dataset[]>> pairNameToSynergyAndViability = new HashMap<String, ArrayList<Dataset[]>>();
            for (Dataset[] pair : allSynergyDatasets) {
                String compound1Name = (String)pair[0].getRowMetadata().get(compound1Field).getValue(0);
                String compound2Name = (String)pair[1].getColumnMetadata().get(compound2Field).getValue(0);
                String name = compound1Name + "_" + compound2Name;
                ArrayList<Dataset[]> list = (ArrayList<Dataset[]>)pairNameToSynergyAndViability.get(name);
                if (list == null) {
                    list = new ArrayList<Dataset[]>();
                    pairNameToSynergyAndViability.put(name, list);
                }
                list.add(pair);
            }
            Vector _cellVector = cellVector;
            ArrayList<Drawable> currentList = new ArrayList<Drawable>();
            ArrayList<Drawable> verticalList = new ArrayList<Drawable>();
            int ncols = 3;
            for (int j = 0; j < cellVector.size(); ++j) {
                currentList = new ArrayList();
                String cell = (String)_cellVector.getValue(j);
                for (String pairName : pairNameToSynergyAndViability.keySet()) {
                    List cells = (List)pairNameToSynergyAndViability.get(pairName);
                    Dataset[] pair = null;
                    for (Dataset[] d : cells) {
                        int index = (Integer)d[0].getProperty("columnIndex");
                        if (index != j) continue;
                        pair = d;
                        break;
                    }
                    void synergyDataset = pair[0];
                    void viabilityDataset = pair[1];
                    float meanSynergy = new Mean().evaluate(DatasetUtil.floatListView((Dataset)synergyDataset));
                    float meanViability = new Mean().evaluate(DatasetUtil.floatListView((Dataset)viabilityDataset));
                    HeatMapPanel synergyPanel = new HeatMapPanel(new DefaultProject((Dataset)synergyDataset));
                    HeatMapColorSchemeOptionsPanel.loadPredefinedColorScheme(synergyPanel.getColorScheme(), "synergy");
                    synergyPanel.getColorSchemeLegend().setVisible(false);
                    HeatMapPanel viabilityPanel = new HeatMapPanel(new DefaultProject((Dataset)viabilityDataset));
                    HeatMapColorSchemeOptionsPanel.loadPredefinedColorScheme(viabilityPanel.getColorScheme(), "viability");
                    viabilityPanel.getColorSchemeLegend().setVisible(false);
                    currentList.add(new HorizontalDrawableArray(new VerticalDrawableArray(new DrawableWrapper(new JLabel(cell + ", mean viability " + Formatter.format(meanViability))), viabilityPanel), new VerticalDrawableArray(new DrawableWrapper(new JLabel(cell + ", mean synergy " + Formatter.format(meanSynergy))), synergyPanel)));
                    if (currentList.size() != ncols) continue;
                    verticalList.add(new HorizontalDrawableArray(currentList));
                    currentList = new ArrayList();
                }
                if (currentList.size() <= 0) continue;
                verticalList.add(new HorizontalDrawableArray(currentList));
            }
            ImageUtil.saveImage(new VerticalDrawableArray(verticalList), "png", new File(outputDir, "synergy_and_viability_pairs"), true);
        }
        return folder;
    }

    private static class SynergyCustomizer
    implements ComponentCustomizer {
        public HeatMapPanel viabilityHeatMapPanel;
        public HeatMapPanel synergyHeatMapPanel;
        private SynergyCompoundHeatMaps syn;
        private boolean isSynergy;

        public SynergyCustomizer(SynergyCompoundHeatMaps syn, boolean isSynergy) {
            this.syn = syn;
            this.isSynergy = isSynergy;
        }

        public void init(HeatMapPanel synergyHeatMapPanel, HeatMapPanel viabilityHeatMapPanel) {
            this.synergyHeatMapPanel = synergyHeatMapPanel;
            this.viabilityHeatMapPanel = viabilityHeatMapPanel;
        }

        @Override
        public boolean inherits() {
            return false;
        }

        private void addToMenuBar(final HeatMapPanel heatMapPanel) {
            GENEEMenuBar menuBar = (GENEEMenuBar)heatMapPanel.getClientProperty("GENE-E.menuBar");
            JMenuItem synergyHeatMap = new JMenuItem("Synergy Heat Map Details");
            synergyHeatMap.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Project project = heatMapPanel.getProject();
                    List<Dataset[]> datasets = SynergyCustomizer.this.syn.createSynergyAndViabilityDatasets(project.getModelRowIndices(true, false), project.getModelColumnIndices(true, false));
                    for (Dataset[] pair : datasets) {
                        Dataset s = pair[0];
                        Dataset v = pair[1];
                        SynergyCustomizer.this.syn.createHeatMap(SynergyCustomizer.this.synergyHeatMapPanel, SynergyCustomizer.this.viabilityHeatMapPanel, s, v);
                    }
                }
            });
            JMenu visMenu = null;
            for (int i = 0; i < menuBar.getMenuCount(); ++i) {
                if (!menuBar.getMenu(i).getText().equals("Visualization")) continue;
                visMenu = menuBar.getMenu(i);
                break;
            }
            visMenu.add(synergyHeatMap);
        }

        @Override
        public void customize(Component c) {
            final HeatMapPanel heatMapPanel = (HeatMapPanel)c;
            if (this.isSynergy) {
                HeatMapColorSchemeOptionsPanel.loadPredefinedColorScheme(heatMapPanel.getColorScheme(), "synergy");
            } else {
                HeatMapColorSchemeOptionsPanel.loadPredefinedColorScheme(heatMapPanel.getColorScheme(), "viability");
            }
            heatMapPanel.addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                }

                @Override
                public void ancestorMoved(AncestorEvent event) {
                }

                @Override
                public void ancestorAdded(AncestorEvent event) {
                    heatMapPanel.removeAncestorListener(this);
                    SynergyCustomizer.this.addToMenuBar(heatMapPanel);
                }
            });
        }
    }
}

