/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.actions;

import gnu.trove.list.array.TIntArrayList;
import java.util.HashMap;
import java.util.Map;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.math.stat.function.FloatListFunction;
import org.broadinstitute.genee.math.stat.function.UnivariateFloatFunction;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.Identifier;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.ResizableRowsDataset;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;
import org.broadinstitute.genee.matrix.TroveFloatList;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;

public class SynergyCalculator {
    private String[] additionalFields;
    private boolean bliss;
    private String compoundOneField;
    private String compoundTwoField;
    private String concentrationOneField;
    private String concentrationTwoField;
    private Dataset filteredSortedDataset;
    private ResizableRowsDataset synergy;
    private UnivariateFloatFunction transformation;
    private ResizableRowsDataset viability;

    public SynergyCalculator(Dataset filteredSortedDataset, String concentrationOneField, String concentrationTwoField, String compoundOneField, String compoundTwoField, boolean bliss, String[] additionalFields, UnivariateFloatFunction transformation) {
        this.filteredSortedDataset = filteredSortedDataset;
        this.concentrationOneField = concentrationOneField;
        this.concentrationTwoField = concentrationTwoField;
        this.compoundOneField = compoundOneField;
        this.compoundTwoField = compoundTwoField;
        this.bliss = bliss;
        this.additionalFields = additionalFields;
        this.transformation = transformation;
    }

    public void execute() {
        Vector concentrationOneVector = this.filteredSortedDataset.getRowMetadata().get(this.concentrationOneField);
        Vector concentrationTwoVector = this.filteredSortedDataset.getRowMetadata().get(this.concentrationTwoField);
        Vector[] compoundOneFields = new Vector[1 + this.additionalFields.length];
        compoundOneFields[0] = this.filteredSortedDataset.getRowMetadata().get(this.compoundOneField);
        Vector[] compoundTwoFields = new Vector[1 + this.additionalFields.length];
        compoundTwoFields[0] = this.filteredSortedDataset.getRowMetadata().get(this.compoundTwoField);
        for (int i = 0; i < this.additionalFields.length; ++i) {
            compoundOneFields[i + 1] = this.filteredSortedDataset.getRowMetadata().get(this.additionalFields[i]);
            compoundTwoFields[i + 1] = this.filteredSortedDataset.getRowMetadata().get(this.additionalFields[i]);
        }
        HashMap<Identifier, HashMap<Number, Integer>> compoundToDoseToTreatedSoloIndex = new HashMap<Identifier, HashMap<Number, Integer>>();
        HashMap<Identifier, Integer> additionalFieldsToBothUntreatedIndex = new HashMap<Identifier, Integer>();
        int nrows = this.filteredSortedDataset.getRowCount();
        for (int i = 0; i < nrows; ++i) {
            Map<Number, Integer> doseToIndex;
            Identifier compoundId;
            Number conc1 = (Number)concentrationOneVector.getValue(i);
            Number conc2 = (Number)concentrationTwoVector.getValue(i);
            if (SynergyCalculator.isUntreated(conc1) && SynergyCalculator.isUntreated(conc2)) {
                Identifier id = VectorUtil.createIdentifier(this.filteredSortedDataset.getRowMetadata(), this.additionalFields, i);
                additionalFieldsToBothUntreatedIndex.put(id, i);
                continue;
            }
            if (SynergyCalculator.isUntreated(conc1) && SynergyCalculator.isTreated(conc2)) {
                compoundId = VectorUtil.createIdentifier(this.filteredSortedDataset.getRowMetadata(), compoundTwoFields, i);
                doseToIndex = (HashMap<Number, Integer>)compoundToDoseToTreatedSoloIndex.get(compoundId);
                if (doseToIndex == null) {
                    doseToIndex = new HashMap<Number, Integer>();
                    compoundToDoseToTreatedSoloIndex.put(compoundId, (HashMap<Number, Integer>)doseToIndex);
                }
                doseToIndex.put(conc2, i);
                continue;
            }
            if (!SynergyCalculator.isUntreated(conc2) || !SynergyCalculator.isTreated(conc1)) continue;
            compoundId = VectorUtil.createIdentifier(this.filteredSortedDataset.getRowMetadata(), compoundOneFields, i);
            doseToIndex = (Map)compoundToDoseToTreatedSoloIndex.get(compoundId);
            if (doseToIndex == null) {
                doseToIndex = new HashMap();
                compoundToDoseToTreatedSoloIndex.put(compoundId, (HashMap<Number, Integer>)doseToIndex);
            }
            doseToIndex.put(conc1, i);
        }
        String[] pairFieldNames = new String[2 + this.additionalFields.length];
        pairFieldNames[0] = this.compoundOneField;
        pairFieldNames[1] = this.compoundTwoField;
        for (String pairFieldNames[i + 2] : this.additionalFields) {
        }
        Map<Identifier, TIntArrayList> pairToRows = VectorUtil.createValuesToIndicesMap(MetadataUtil.getVectors(this.filteredSortedDataset.getRowMetadata(), pairFieldNames));
        this.synergy = new ResizableRowsDataset(this.filteredSortedDataset.getName() + " synergy", this.filteredSortedDataset.getColumnCount());
        this.viability = new ResizableRowsDataset(this.filteredSortedDataset.getName() + " viability", this.filteredSortedDataset.getColumnCount());
        int count = this.filteredSortedDataset.getRowMetadata().getMetadataCount();
        for (int i = 0; i < count; ++i) {
            Vector src = this.filteredSortedDataset.getRowMetadata().get(i);
            Vector dest = this.synergy.getRowMetadata().add(src.getName(), this.filteredSortedDataset.getRowMetadata().get(i).getColumnClass());
            VectorUtil.copyProperties(src, dest);
        }
        this.synergy.addSeries("Synergy", SynergyRaw.class);
        this.viability.addSeries("Synergy", SynergyRaw.class);
        int resultRowIndex = 0;
        for (Identifier id : pairToRows.keySet()) {
            boolean addUntreated;
            Map dose1ToIndex;
            TIntArrayList rows = pairToRows.get(id);
            Identifier compoundOneId = VectorUtil.createIdentifier(this.filteredSortedDataset.getRowMetadata(), compoundOneFields, rows.getQuick(0));
            Identifier compoundTwoId = VectorUtil.createIdentifier(this.filteredSortedDataset.getRowMetadata(), compoundTwoFields, rows.getQuick(0));
            boolean added = false;
            int nrows2 = rows.size();
            for (int i = 0; i < nrows2; ++i) {
                int comboRowIndex = rows.getQuick(i);
                Object conc1 = concentrationOneVector.getValue(comboRowIndex);
                dose1ToIndex = (Map)compoundToDoseToTreatedSoloIndex.get(compoundOneId);
                Object conc2 = concentrationTwoVector.getValue(comboRowIndex);
                Map dose2ToIndex = (Map)compoundToDoseToTreatedSoloIndex.get(compoundTwoId);
                if (dose1ToIndex == null || dose2ToIndex == null) break;
                Integer treatedAloneRowIndex1 = (Integer)dose1ToIndex.get(conc1);
                Integer treatedAloneRowIndex2 = (Integer)dose2ToIndex.get(conc2);
                if (treatedAloneRowIndex1 == null || treatedAloneRowIndex2 == null) break;
                added = true;
                this.synergy.nextRow();
                this.viability.nextRow();
                this.computeSynergy(comboRowIndex, treatedAloneRowIndex1, treatedAloneRowIndex2, resultRowIndex);
                for (int k = 0; k < this.filteredSortedDataset.getRowMetadata().getMetadataCount(); ++k) {
                    this.synergy.getRowMetadata().get(k).setValue(resultRowIndex, this.filteredSortedDataset.getRowMetadata().get(k).getValue(comboRowIndex));
                }
                ++resultRowIndex;
            }
            if (!(addUntreated = true) || !added) continue;
            Identifier additionalFielsdId = VectorUtil.createIdentifier(this.filteredSortedDataset.getRowMetadata(), this.additionalFields, rows.getQuick(0));
            int bothUntreatedIndex = (Integer)additionalFieldsToBothUntreatedIndex.get(additionalFielsdId);
            this.synergy.nextRow();
            this.viability.nextRow();
            for (String field : pairFieldNames) {
                this.synergy.getRowMetadata().get(field).setValue(resultRowIndex, this.filteredSortedDataset.getRowMetadata().get(field).getValue(rows.getQuick(0)));
            }
            this.synergy.getRowMetadata().get(this.concentrationTwoField).setValue(resultRowIndex, Float.valueOf(0.0f));
            this.synergy.getRowMetadata().get(this.concentrationOneField).setValue(resultRowIndex, Float.valueOf(0.0f));
            this.computeSynergy(bothUntreatedIndex, bothUntreatedIndex, bothUntreatedIndex, resultRowIndex++);
            Map dose2ToIndex = (Map)compoundToDoseToTreatedSoloIndex.get(compoundTwoId);
            if (dose2ToIndex != null) {
                for (Object dose : dose2ToIndex.keySet()) {
                    this.synergy.nextRow();
                    this.viability.nextRow();
                    int comboRowIndex = (Integer)dose2ToIndex.get(dose);
                    for (Vector field : compoundTwoFields) {
                        this.synergy.getRowMetadata().get(field.getName()).setValue(resultRowIndex, this.filteredSortedDataset.getRowMetadata().get(field.getName()).getValue(comboRowIndex));
                    }
                    this.synergy.getRowMetadata().get(this.concentrationTwoField).setValue(resultRowIndex, dose);
                    this.synergy.getRowMetadata().get(this.concentrationOneField).setValue(resultRowIndex, Float.valueOf(0.0f));
                    this.synergy.getRowMetadata().get(this.compoundOneField).setValue(resultRowIndex, this.filteredSortedDataset.getRowMetadata().get(this.compoundOneField).getValue(rows.getQuick(0)));
                    this.computeSynergy(comboRowIndex, bothUntreatedIndex, comboRowIndex, resultRowIndex++);
                }
            }
            if ((dose1ToIndex = (Map)compoundToDoseToTreatedSoloIndex.get(compoundOneId)) == null) continue;
            for (Object dose : dose1ToIndex.keySet()) {
                this.synergy.nextRow();
                this.viability.nextRow();
                int comboRowIndex = (Integer)dose1ToIndex.get(dose);
                for (Vector field : compoundOneFields) {
                    this.synergy.getRowMetadata().get(field.getName()).setValue(resultRowIndex, this.filteredSortedDataset.getRowMetadata().get(field.getName()).getValue(comboRowIndex));
                }
                this.synergy.getRowMetadata().get(this.concentrationOneField).setValue(resultRowIndex, dose);
                this.synergy.getRowMetadata().get(this.concentrationTwoField).setValue(resultRowIndex, Float.valueOf(0.0f));
                this.synergy.getRowMetadata().get(this.compoundTwoField).setValue(resultRowIndex, this.filteredSortedDataset.getRowMetadata().get(this.compoundTwoField).getValue(rows.getQuick(0)));
                this.computeSynergy(comboRowIndex, comboRowIndex, bothUntreatedIndex, resultRowIndex++);
            }
        }
        this.viability.setRowMetadata(this.synergy.getRowMetadata());
        this.viability.setColumnMetadata(this.synergy.getColumnMetadata());
        MetadataUtil.copy(this.filteredSortedDataset.getColumnMetadata(), this.synergy.getColumnMetadata());
    }

    public ResizableRowsDataset getSynergy() {
        return this.synergy;
    }

    public ResizableRowsDataset getViability() {
        return this.viability;
    }

    public void setSynergy(ResizableRowsDataset synergy) {
        this.synergy = synergy;
    }

    public void setViability(ResizableRowsDataset viability) {
        this.viability = viability;
    }

    private void computeSynergy(int comboRowIndex, int treatedAloneRowIndex1, int treatedAloneRowIndex2, int resultRowIndex) {
        int ncols = this.filteredSortedDataset.getColumnCount();
        for (int j = 0; j < ncols; ++j) {
            float _combo = this.filteredSortedDataset.getValue(comboRowIndex, j);
            float _a = this.filteredSortedDataset.getValue(treatedAloneRowIndex1, j);
            float _b = this.filteredSortedDataset.getValue(treatedAloneRowIndex2, j);
            float combo = this.transformation.evaluate(_combo);
            float a = this.transformation.evaluate(_a);
            float b = this.transformation.evaluate(_b);
            float c = this.bliss ? combo - (a + b - a * b) : combo - (a + b);
            this.synergy.setValue(resultRowIndex, j, c);
            this.viability.setValue(resultRowIndex, j, this.filteredSortedDataset.getValue(comboRowIndex, j));
            SynergyRaw raw = new SynergyRaw(_a, _b, _combo);
            this.synergy.setObjectValue(resultRowIndex, j, raw, 1);
            this.viability.setObjectValue(resultRowIndex, j, raw, 1);
        }
    }

    public Dataset createSummarySynergyScoreMatrix(FloatListFunction summaryFunction) {
        String[] vectorNames = new String[2 + this.additionalFields.length];
        vectorNames[0] = this.compoundOneField;
        vectorNames[1] = this.compoundTwoField;
        for (String vectorNames[i + 2] : this.additionalFields) {
        }
        ResizableRowsDataset synergy = this.synergy;
        Map<Identifier, TIntArrayList> pairToRowIndices = VectorUtil.createValuesToIndicesMap(MetadataUtil.getVectors(synergy.getRowMetadata(), vectorNames));
        RowMajorArray2DDataset scores = new RowMajorArray2DDataset(summaryFunction + " synergy", pairToRowIndices.size(), synergy.getColumnCount());
        scores.setColumnMetadata(synergy.getColumnMetadata());
        for (String name : vectorNames) {
            Vector v = synergy.getRowMetadata().get(name);
            Vector scoreVector = scores.getRowMetadata().add(name, v.getColumnClass());
            scoreVector.setComparator(v.getComparator());
            VectorUtil.copyProperties(v, scoreVector);
        }
        int resultRowIndex = 0;
        for (Identifier id : pairToRowIndices.keySet()) {
            int[] rows = pairToRowIndices.get(id).toArray();
            Dataset synergySubset = DatasetUtil.sliceView(synergy, rows, null);
            for (String name : vectorNames) {
                Vector v = synergySubset.getRowMetadata().get(name);
                scores.getRowMetadata().get(name).setValue(resultRowIndex, v.getValue(0));
            }
            int ncols = synergy.getColumnCount();
            for (int j = 0; j < ncols; ++j) {
                TroveFloatList values = new TroveFloatList();
                int nrows = synergySubset.getRowCount();
                for (int i = 0; i < nrows; ++i) {
                    float conc1 = ((Number)synergySubset.getRowMetadata().get(this.concentrationOneField).getValue(i)).floatValue();
                    float conc2 = ((Number)synergySubset.getRowMetadata().get(this.concentrationTwoField).getValue(i)).floatValue();
                    if (conc1 == 0.0f || conc2 == 0.0f) continue;
                    float val = synergySubset.getValue(i, j);
                    if (val < 0.0f) {
                        val = 0.0f;
                    }
                    values.add(val);
                }
                scores.setValue(resultRowIndex, j, summaryFunction.evaluate(values));
            }
            ++resultRowIndex;
        }
        return scores;
    }

    public static boolean isTreated(Number n) {
        return n != null && n.floatValue() > 0.0f;
    }

    public static boolean isUntreated(Number n) {
        return n != null && n.floatValue() == 0.0f;
    }

    private static class SynergyRaw {
        private float val1;
        private float val2;
        private float joint;

        public SynergyRaw(float val1, float val2, float joint) {
            this.val1 = val1;
            this.val2 = val2;
            this.joint = joint;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("a:");
            sb.append(Formatter.format(this.val1));
            sb.append(", b:");
            sb.append(Formatter.format(this.val2));
            sb.append(", combined:");
            sb.append(Formatter.format(this.joint));
            return sb.toString();
        }
    }
}

