/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.parameters;

import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.broadinstitute.genee.gui.parameters.InputParameter;
import org.broadinstitute.genee.io.util.Formatter;

public class ComboBoxParameter
extends JComboBox
implements InputParameter {
    private Class<?> c;

    public ComboBoxParameter(Class<?> c) {
        this.c = c;
    }

    public ComboBoxParameter(Object[] choices, int selectedIndex) {
        if (choices != null) {
            for (Object choice : choices) {
                this.addItem(choice);
            }
        }
        if (selectedIndex >= 0) {
            this.setSelectedIndex(selectedIndex);
        } else if (this.getItemCount() > 0) {
            this.setSelectedIndex(0);
        }
    }

    public ComboBoxParameter(Object[] choices, Object defaultValue) {
        if (choices != null) {
            for (Object choice : choices) {
                this.addItem(choice);
            }
        }
        if (defaultValue != null) {
            this.setSelectedItem(defaultValue);
        }
    }

    @Override
    public JComponent getJComponent() {
        return this;
    }

    public Object getParameterValue() {
        return !this.isEnabled() ? null : this.getSelectedItem();
    }

    @Override
    public Class<?> getValueClass() {
        return this.c;
    }

    @Override
    public void init(Object obj) {
        Object selection = this.getSelectedItem();
        this.removeAllItems();
        if (obj != null) {
            Object[] value = (Object[])obj;
            for (int i = 0; i < value.length; ++i) {
                this.addItem(value[i]);
            }
        }
        this.setSelectedItem(selection);
    }

    @Override
    public void setValueFromString(String s) {
        String itemText;
        int i;
        int index = -1;
        int cc = this.getItemCount();
        for (i = 0; i < cc; ++i) {
            itemText = Formatter.toString(this.getItemAt(i));
            if (!s.equals(itemText)) continue;
            index = i;
            break;
        }
        if (index != -1) {
            this.setSelectedIndex(index);
        } else {
            s = s.toLowerCase();
            cc = this.getItemCount();
            for (i = 0; i < cc; ++i) {
                itemText = Formatter.toString(this.getItemAt(i)).toLowerCase();
                if (!s.contains(itemText)) continue;
                index = i;
                break;
            }
            if (index != -1) {
                this.setSelectedIndex(index);
            }
        }
    }
}

