/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.parameters;

import com.google.common.base.Supplier;
import com.jgoodies.forms.factories.ButtonBarFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEWindow;
import org.broadinstitute.genee.gui.ClassInputPanel;
import org.broadinstitute.genee.gui.CloseablePanelList;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.parameters.AbstractComparisonInputList;
import org.broadinstitute.genee.gui.parameters.TwoClassComparison;

class DefaultSupplier
extends JPanel
implements Supplier<Component>,
CloseablePanelList.CloseButtonSupplier {
    private final AbstractComparisonInputList categoryChooserParameter2;
    protected ClassInputPanel classInputPanel;
    private JTextField comparisonNameTextField;
    private JButton deleteButton;
    private GENEEWindow inputWindow;

    public DefaultSupplier(AbstractComparisonInputList categoryChooserParameter2) {
        this.categoryChooserParameter2 = categoryChooserParameter2;
    }

    protected void copy(DefaultSupplier dest) {
        this.categoryChooserParameter2.closeablePanelList.addCloseable(dest);
        ClassInputPanel newClassInputPanel = dest.classInputPanel;
    }

    public Component get() {
        this.comparisonNameTextField = new JTextField(20);
        this.comparisonNameTextField.setText("Comparison " + (this.categoryChooserParameter2.supplierList.size() + 1));
        this.deleteButton = new JButton("Delete");
        final JButton editBtn = new JButton("Edit");
        JButton duplicateBtn = new JButton("Duplicate");
        this.classInputPanel = new ClassInputPanel();
        this.classInputPanel.setProject(this.categoryChooserParameter2.project);
        duplicateBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultSupplier c = (DefaultSupplier)DefaultSupplier.this.categoryChooserParameter2.createNewComponentSupplier();
                DefaultSupplier.this.copy(c);
            }
        });
        editBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DefaultSupplier.this.inputWindow == null) {
                    DefaultSupplier.this.inputWindow = Application.createDialog(UIUtil.getWindowForComponent(editBtn), "Edit Comparison");
                    DefaultSupplier.this.inputWindow.getContentPane().add(DefaultSupplier.this.classInputPanel.getJComponent());
                    JButton okButton = new JButton("OK");
                    okButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            DefaultSupplier.this.inputWindow.dispose();
                        }
                    });
                    DefaultSupplier.this.inputWindow.getContentPane().add((Component)UIUtil.buildOKBar(okButton), "South");
                    DefaultSupplier.this.inputWindow.pack();
                }
                DefaultSupplier.this.inputWindow.setVisible(true);
            }
        });
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)ButtonBarFactory.buildLeftAlignedBar((JButton[])new JButton[]{editBtn, duplicateBtn, this.deleteButton}), "South");
        FormBuilder formBuilder = new FormBuilder();
        formBuilder.nextRow();
        formBuilder.addLabel("Comparison name:");
        formBuilder.add(this.comparisonNameTextField);
        this.addCustomComponents(formBuilder);
        formBuilder.nextRow();
        p.add(formBuilder.getPanel());
        return p;
    }

    public Object getValue() {
        TwoClassComparison[] comparisons = this.classInputPanel.getTwoClassComparison();
        if (comparisons.length == 1) {
            comparisons[0].setComparisonName(this.comparisonNameTextField.getText().trim());
        }
        return comparisons;
    }

    protected void addCustomComponents(FormBuilder formBuilder) {
    }

    @Override
    public JButton getCloseButton() {
        return this.deleteButton;
    }

    @Override
    public String toString() {
        return "";
    }
}

