/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.parameters;

import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.gui.parameters.CheckBoxParameter;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.ProjectEvent;
import org.broadinstitute.genee.heatmap.ProjectListener;

public class ExcludeMaskedCheckBoxParameter
extends CheckBoxParameter {
    private ProjectListener projectListener;
    private Project project;
    private boolean rows;

    public ExcludeMaskedCheckBoxParameter(final boolean rows) {
        super(rows ? "Masked Rows" : "Masked Columns", false);
        this.projectListener = new ProjectListener(){

            @Override
            public void projectChanged(ProjectEvent e) {
                if (rows && e.getType() == 1) {
                    ExcludeMaskedCheckBoxParameter.this.updateEnabled();
                } else if (!rows && e.getType() == 12) {
                    ExcludeMaskedCheckBoxParameter.this.updateEnabled();
                }
            }
        };
        this.rows = rows;
    }

    public void notifyHidden() {
        if (this.project != null) {
            this.project.removeProjectListener(this.projectListener);
        }
    }

    public void notifyShowing() {
        this.project = Application.getProject();
        this.project.addProjectListener(this.projectListener);
        this.updateEnabled();
    }

    private void updateEnabled() {
        if (this.rows) {
            this.setEnabled(this.project.getViewRowMask().size() > 0);
        } else {
            this.setEnabled(this.project.getViewColumnMask().size() > 0);
        }
    }
}

