/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.parameters;

import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.gui.parameters.CheckBoxParameter;
import org.broadinstitute.genee.gui.parameters.InputParameter;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.SelectionEvent;
import org.broadinstitute.genee.heatmap.SelectionListener;

public class IncludeSelectedRowsCheckBox
extends CheckBoxParameter
implements InputParameter<Boolean> {
    private boolean enableOverride = true;
    private SelectionListener rowSelectionListener = new SelectionListener(){

        @Override
        public void valueChanged(SelectionEvent e) {
            IncludeSelectedRowsCheckBox.this.updateSelectedRowsText();
        }
    };
    private Project project;

    public IncludeSelectedRowsCheckBox() {
        this((String)null, false);
    }

    public IncludeSelectedRowsCheckBox(String text, boolean selected) {
        super(text, selected);
    }

    public boolean isEnableOverride() {
        return this.enableOverride;
    }

    public void notifyHidden() {
        if (this.project != null) {
            this.project.getRowSelectionModel().removeSelectionListener(this.rowSelectionListener);
        }
    }

    public void notifyShowing() {
        this.updateSelectedRowsText();
        this.project = Application.getProject();
        if (this.project != null) {
            this.project.getRowSelectionModel().addSelectionListener(this.rowSelectionListener);
        }
    }

    public void setEnableOverride(boolean enableOverride) {
        this.enableOverride = enableOverride;
        this.updateSelectedRowsText();
    }

    private void updateSelectedRowsText() {
        Project project = Application.getProject();
        int count = project == null ? 0 : project.getRowSelectionModel().getSelectionCount();
        this.setEnabled(count > 0 && this.enableOverride);
    }
}

