/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.parameters;

import gnu.trove.list.array.TIntArrayList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.broadinstitute.genee.gui.ClassInputPanel;
import org.broadinstitute.genee.gui.parameters.InputParameter;
import org.broadinstitute.genee.gui.parameters.TwoClassComparison;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.matrix.geneset.GeneSet;
import org.broadinstitute.genee.io.matrix.geneset.GeneSetIO;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;
import org.broadinstitute.genee.matrix.geneset.GeneSetMatrix;

public class TwoClassComparisonInputParameter
implements InputParameter<TwoClassComparison[]> {
    private ClassInputPanel classInputPanel = new ClassInputPanel();
    private TwoClassComparison[] comparisonForCommandLineUsage;

    @Override
    public JComponent getJComponent() {
        return this.classInputPanel.getJComponent();
    }

    @Override
    public TwoClassComparison[] getParameterValue() {
        return this.comparisonForCommandLineUsage != null ? this.comparisonForCommandLineUsage : this.classInputPanel.getTwoClassComparison();
    }

    @Override
    public Class<?> getValueClass() {
        return TwoClassComparison[].class;
    }

    @Override
    public void init(Object value) {
        if (value instanceof Project) {
            Project project = (Project)value;
            this.classInputPanel.setProject(project);
        }
    }

    @Override
    public void setValueFromString(String text) {
        if (new File(text).exists()) {
            try {
                GeneSetMatrix m = GeneSetIO.readGeneSetMatrix(text);
                Project project = this.classInputPanel.getProject();
                Dataset dataset = project.getOriginalDataset();
                Vector ids = dataset.getColumnMetadata().get("id");
                if (ids == null) {
                    ids = dataset.getColumnMetadata().get("Id");
                }
                if (ids == null) {
                    ids = dataset.getColumnMetadata().get(0);
                }
                Map idToIndices = VectorUtil.createValueToIndicesMap(ids);
                ArrayList<TwoClassComparison> comparisons = new ArrayList<TwoClassComparison>();
                for (int i = 0; i < m.getNumGeneSets(); i += 2) {
                    GeneSet up = m.get(i);
                    LinkedHashSet<Integer> upIndices = new LinkedHashSet<Integer>();
                    for (String id : up.getMembers()) {
                        TIntArrayList indices = idToIndices.get(id);
                        if (indices == null) continue;
                        int size = indices.size();
                        for (int j = 0; j < size; ++j) {
                            upIndices.add(indices.getQuick(j));
                        }
                    }
                    GeneSet dn = m.get(i + 1);
                    LinkedHashSet<Integer> dnIndices = new LinkedHashSet<Integer>();
                    for (String id : dn.getMembers()) {
                        TIntArrayList indices = idToIndices.get(id);
                        if (indices == null) continue;
                        int size = indices.size();
                        for (int j = 0; j < size; ++j) {
                            dnIndices.add(indices.getQuick(j));
                        }
                    }
                    comparisons.add(new TwoClassComparison(up.getName() + " vs. " + dn.getName(), upIndices, dnIndices));
                }
                this.comparisonForCommandLineUsage = comparisons.toArray(new TwoClassComparison[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            int bIndex = text.indexOf(66);
            if (bIndex != -1) {
                String b;
                String a = text.substring(0, bIndex);
                int index = a.indexOf(58);
                if (index != -1) {
                    a = a.substring(index + 1);
                }
                if ((index = (b = text.substring(bIndex + 1)).indexOf(58)) != -1) {
                    b = b.substring(index + 1);
                }
                this.comparisonForCommandLineUsage = new TwoClassComparison[]{new TwoClassComparison("", TwoClassComparisonInputParameter.toSet(a), TwoClassComparisonInputParameter.toSet(b))};
            }
        }
    }

    private static Set<Integer> toSet(String text) {
        int[] indices = IOUtil.rangeToIntArray(text);
        LinkedHashSet<Integer> set = new LinkedHashSet<Integer>();
        for (int idx : indices) {
            set.add(idx);
        }
        return set;
    }
}

