/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.scroll;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import javax.swing.JScrollBar;
import javax.swing.JTable;
import javax.swing.plaf.ScrollBarUI;
import org.broadinstitute.genee.cmap.rankedlist.HighlightTrack;
import org.broadinstitute.genee.cmap.rankedlist.HighlightTrackEvent;
import org.broadinstitute.genee.cmap.rankedlist.HighlightTrackListener;
import org.broadinstitute.genee.gui.scroll.ScrollBarUIHelper;
import org.broadinstitute.genee.gui.scroll.SearchScrollBarUI;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.matrix.rankedlist.RankedList;

public class RankedListVerticalScrollBarUIHelper
implements ScrollBarUIHelper {
    private MouseListener mouseListener;
    private MouseMotionListener mouseMotionListener;
    private int offset;
    private float scale;
    private JScrollBar scrollbar;
    private JTable table;
    private HighlightTrack highlightTrack;
    private RankedList rankedList;
    private HighlightTrackListener highlightTrackListener;

    public RankedListVerticalScrollBarUIHelper(JTable table, HighlightTrack highlightTrack, RankedList rankedList) {
        this.table = table;
        this.highlightTrack = highlightTrack;
        this.highlightTrackListener = new HighlightTrackListener(){

            @Override
            public void trackChanged(HighlightTrackEvent e) {
                RankedListVerticalScrollBarUIHelper.this.scrollbar.revalidate();
                RankedListVerticalScrollBarUIHelper.this.scrollbar.repaint();
            }
        };
        highlightTrack.addHighlightTrackListener(this.highlightTrackListener);
        this.rankedList = rankedList;
    }

    @Override
    public void draw(Graphics g, int width, int height, int offset) {
        Graphics2D g2 = (Graphics2D)g;
        width -= 2;
        AffineTransform transform = g2.getTransform();
        g2.translate(1, 0);
        Rectangle rect = this.table.getCellRect(this.table.getRowCount() - 1, 0, true);
        this.scale = (float)height / (float)rect.y;
        this.offset = offset;
        if (!this.highlightTrack.isEmpty()) {
            this.draw(g2, width);
        }
        g2.setTransform(transform);
    }

    @Override
    public void install(final JScrollBar scrollbar) {
        this.scrollbar = scrollbar;
        this.mouseListener = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index = RankedListVerticalScrollBarUIHelper.this.getIndex(e);
                if (index != -1 && RankedListVerticalScrollBarUIHelper.this.highlightTrack.contains(RankedListVerticalScrollBarUIHelper.this.rankedList.getId(index))) {
                    Rectangle rect = RankedListVerticalScrollBarUIHelper.this.table.getCellRect(index, 0, true);
                    RankedListVerticalScrollBarUIHelper.this.table.scrollRectToVisible(rect);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        };
        this.mouseMotionListener = new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                int index = RankedListVerticalScrollBarUIHelper.this.getIndex(e);
                if (index != -1 && RankedListVerticalScrollBarUIHelper.this.highlightTrack.contains(RankedListVerticalScrollBarUIHelper.this.rankedList.getId(index))) {
                    scrollbar.setCursor(Cursor.getPredefinedCursor(12));
                    scrollbar.setToolTipText(Formatter.toString(RankedListVerticalScrollBarUIHelper.this.rankedList.getId(index)));
                } else {
                    scrollbar.setCursor(Cursor.getPredefinedCursor(0));
                    scrollbar.setToolTipText(null);
                }
            }
        };
        scrollbar.addMouseListener(this.mouseListener);
        scrollbar.addMouseMotionListener(this.mouseMotionListener);
    }

    private int getIndex(MouseEvent e) {
        int lowy = (int)((float)(e.getY() - this.offset - 1) / this.scale);
        int highy = (int)((float)(e.getY() - this.offset + 1) / this.scale);
        int low = this.table.rowAtPoint(new Point(0, lowy));
        int high = this.table.rowAtPoint(new Point(0, highy));
        for (int i = low; i <= high; ++i) {
            if (!this.highlightTrack.contains(this.rankedList.getId(i))) continue;
            this.scrollbar.setCursor(Cursor.getPredefinedCursor(12));
            return i;
        }
        return -1;
    }

    public void setRankedList(RankedList rl) {
        this.rankedList = rl;
        this.scrollbar.revalidate();
        this.scrollbar.repaint();
    }

    @Override
    public void uninstall() {
        this.scrollbar.removeMouseListener(this.mouseListener);
        this.scrollbar.removeMouseMotionListener(this.mouseMotionListener);
        this.highlightTrack.removeHighlightTrackListener(this.highlightTrackListener);
    }

    private void draw(Graphics2D g2, int width) {
        Color oldColor = g2.getColor();
        Rectangle2D.Float rect = new Rectangle2D.Float();
        Collection<Object> ids = this.highlightTrack.getAllInstanceIds();
        for (Object id : ids) {
            int index = this.rankedList.getIndex(id);
            float ypix = this.table.getCellRect((int)index, (int)0, (boolean)true).y;
            g2.setColor(this.highlightTrack.getColor(id));
            ypix = this.scale * ypix;
            rect.setRect(0.0f, ypix + (float)this.offset - 1.0f, width, 2.0f);
            g2.fill(rect);
        }
        g2.setColor(oldColor);
    }

    public static ScrollBarUI createScrollBarUI(RankedListVerticalScrollBarUIHelper helper) {
        return new SearchScrollBarUI(helper);
    }
}

