/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.scroll;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.lang.reflect.Method;
import javax.accessibility.Accessible;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.UIManager;
import javax.swing.plaf.ScrollBarUI;
import javax.swing.plaf.basic.BasicScrollBarUI;
import org.broadinstitute.genee.gui.scroll.ScrollBarUIHelper;

public class SearchScrollBarUI
extends ScrollBarUI {
    private ScrollBarUI delegate;
    private JScrollBar scrollBar;
    private ScrollBarUIHelper searchResultsScrollBarUIHelper;
    private Method method;

    public SearchScrollBarUI(ScrollBarUIHelper searchResultsScrollBarUIHelper) {
        this.searchResultsScrollBarUIHelper = searchResultsScrollBarUIHelper;
        try {
            this.delegate = (ScrollBarUI)Class.forName(UIManager.getString("ScrollBarUI")).newInstance();
        }
        catch (Exception x) {
            this.delegate = new BasicScrollBarUI();
        }
        try {
            this.method = this.delegate.getClass().getDeclaredMethod("getTrackBounds", null);
        }
        catch (Exception x) {
            Class<?> c = this.delegate.getClass();
            while ((c = c.getSuperclass()) != null) {
                try {
                    this.method = c.getDeclaredMethod("getTrackBounds", null);
                }
                catch (Exception x2) {
                    // empty catch block
                }
                if (this.method == null) continue;
            }
        }
        if (this.method != null) {
            this.method.setAccessible(true);
        }
    }

    @Override
    public boolean contains(JComponent c, int x, int y) {
        return this.delegate.contains(c, x, y);
    }

    @Override
    public Accessible getAccessibleChild(JComponent c, int i) {
        return this.delegate.getAccessibleChild(c, i);
    }

    @Override
    public int getAccessibleChildrenCount(JComponent c) {
        return this.delegate.getAccessibleChildrenCount(c);
    }

    @Override
    public int getBaseline(JComponent c, int width, int height) {
        return this.delegate.getBaseline(c, width, height);
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(JComponent c) {
        return this.delegate.getBaselineResizeBehavior(c);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this.delegate.getMaximumSize(c);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.delegate.getMinimumSize(c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.delegate.getPreferredSize(c);
    }

    protected Rectangle getTrackBounds() {
        if (this.method == null) {
            return new Rectangle(0, 0, this.scrollBar.getWidth(), this.scrollBar.getHeight());
        }
        try {
            return (Rectangle)this.method.invoke((Object)this.delegate, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Rectangle(0, 0, this.scrollBar.getWidth(), this.scrollBar.getHeight());
        }
    }

    @Override
    public void installUI(JComponent c) {
        this.delegate.installUI(c);
        this.scrollBar = (JScrollBar)c;
        this.searchResultsScrollBarUIHelper.install(this.scrollBar);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.delegate.paint(g, c);
        Rectangle trackBounds = this.getTrackBounds();
        this.searchResultsScrollBarUIHelper.draw(g, trackBounds.width, trackBounds.height, trackBounds.y);
    }

    public void paintSearchBar(Graphics g, Rectangle trackBounds) {
        this.searchResultsScrollBarUIHelper.draw(g, trackBounds.width, trackBounds.height, trackBounds.y);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.delegate.uninstallUI(c);
        this.scrollBar = null;
        this.searchResultsScrollBarUIHelper.uninstall();
    }
}

