/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import gnu.trove.list.array.TIntArrayList;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import org.broadinstitute.genee.gui.ActionListenerHelper;
import org.broadinstitute.genee.heatmap.AbstractIndexedQuickSearch;
import org.broadinstitute.genee.heatmap.LuceneSearchParser;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.ProjectEvent;
import org.broadinstitute.genee.heatmap.ProjectListener;
import org.broadinstitute.genee.heatmap.QuickFilter;
import org.broadinstitute.genee.matrix.Dataset;

public abstract class AbstractProjectQuickSearch
extends AbstractIndexedQuickSearch
implements QuickFilter {
    protected Dataset dataset;
    protected int[] highlightedIndices;
    protected int matchIndex = -1;
    protected Project project;
    protected ProjectListener projectListener;

    public AbstractProjectQuickSearch(Project project) {
        this.project = project;
        this.projectListener = new ProjectListener(){

            @Override
            public void projectChanged(ProjectEvent e) {
                AbstractProjectQuickSearch.this.update();
            }
        };
        project.addProjectListener(this.projectListener);
        this.dataset = project.getSortedFilteredDataset();
    }

    @Override
    public final void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    @Override
    public final int[] getHighlightedIndices() {
        return this.highlightedIndices;
    }

    public int getNumberOfMatches() {
        return this.highlightedIndices == null ? 0 : this.highlightedIndices.length;
    }

    @Override
    public final Project getProject() {
        return this.project;
    }

    public final boolean isHighlighted(int index) {
        return this.highlightedIndices != null ? Arrays.binarySearch(this.highlightedIndices, index) >= 0 : false;
    }

    public final int nextMatch() {
        ++this.matchIndex;
        int match = this.match();
        return match;
    }

    public final int previousMatch() {
        --this.matchIndex;
        int match = this.match();
        return match;
    }

    @Override
    public final void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    @Override
    protected LuceneSearchParser.SearchPredicateAdapterCreator createSearchPredicateAdapterCreator() {
        return new LuceneSearchParser.SearchPredicateAdapterCreator(){

            @Override
            public LuceneSearchParser.IndexedSearchPredicate create(LuceneSearchParser.InternalSearchPredicate internalSearchPredicate) {
                return new LuceneSearchParser.DatasetSearchPredicateAdapter(internalSearchPredicate);
            }
        };
    }

    protected abstract int getCurrentSize();

    @Override
    protected final void notifyFilterChanged() {
        this.matchIndex = -1;
        if (this.searchPredicate == null) {
            this.highlightedIndices = null;
            this.clearLabelText();
        } else {
            this.highlightedIndices = this.updateHighlightedIndices();
            this.setLabelText(this.highlightedIndices.length, this.getCurrentSize());
        }
        ActionListenerHelper.fireActionPerformed(this.listenerList, new ActionEvent(this, 1001, null));
    }

    protected abstract int[] updateHighlightedIndices();

    private int match() {
        if (this.matchIndex >= this.highlightedIndices.length) {
            this.matchIndex = 0;
        }
        if (this.matchIndex < 0) {
            this.matchIndex = this.highlightedIndices.length - 1;
        }
        return this.highlightedIndices[this.matchIndex];
    }

    private void update() {
        this.matchIndex = -1;
        this.dataset = this.project.getSortedFilteredDataset();
        this.notifyFilterChanged();
    }

    public static int[] getMatches(LuceneSearchParser.IndexedSearchPredicate filter, int count) {
        TIntArrayList highlightIndices = new TIntArrayList();
        for (int i = 0; i < count; ++i) {
            if (!filter.accept(i)) continue;
            highlightIndices.add(i);
        }
        return highlightIndices.toArray();
    }
}

