/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEFolderNode;
import org.broadinstitute.genee.application.History;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.clustering.hierarchical.AtrGtrDendrogram;
import org.broadinstitute.genee.gui.BackgroundTask;
import org.broadinstitute.genee.gui.actions.AnnotateAction;
import org.broadinstitute.genee.heatmap.HeatMapColorSchemeOptionsPanel;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.SortKeys;
import org.broadinstitute.genee.heatmap.SortOrder;
import org.broadinstitute.genee.io.excel.AddToMetadataContentHandler;
import org.broadinstitute.genee.io.excel.ExcelReader;
import org.broadinstitute.genee.io.matrix.ProjectReader;
import org.broadinstitute.genee.io.matrix.gct.GctReader;
import org.broadinstitute.genee.io.matrix.gctx.GctxProjectReader;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ProjectIO;
import org.broadinstitute.genee.math.stat.function.Median;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetRowView;
import org.broadinstitute.genee.matrix.DefaultClassVector;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;

public class ApplicationArgsLauncher {
    private Application.ApplicationArgs args;

    public ApplicationArgsLauncher(Application.ApplicationArgs args) {
        this.args = args;
    }

    public boolean containsData() {
        return this.args.getData() != null;
    }

    private static String decodeUrl(String s) throws IOException {
        URL url = new URL(s);
        String query = url.getQuery();
        if (query == null) {
            return s;
        }
        String[] tokens = query.split("&");
        StringBuilder q = new StringBuilder();
        for (int i = 0; i < tokens.length; ++i) {
            String[] pair = tokens[i].split("=");
            if (i > 0) {
                q.append("&");
            }
            q.append(URLEncoder.encode(pair[0], "UTF-8"));
            q.append("=");
            q.append(URLEncoder.encode(pair[1], "UTF-8"));
        }
        StringBuilder sb = new StringBuilder();
        sb.append(url.getProtocol()).append("://").append(url.getHost());
        if (url.getPort() != -1) {
            sb.append(":" + url.getPort());
        }
        sb.append(url.getPath() + "?" + q);
        return sb.toString();
    }

    private static Map<String, List<String>> getUrlParams(String s) {
        HashMap<String, List<String>> nameToValue = new HashMap<String, List<String>>();
        try {
            URL url = new URL(s);
            String[] tokens = url.getQuery().split("&");
            for (int i = 0; i < tokens.length; ++i) {
                String[] pair = tokens[i].split("=");
                ArrayList<String> list = (ArrayList<String>)nameToValue.get(pair[0]);
                if (list == null) {
                    list = new ArrayList<String>();
                    nameToValue.put(pair[0], list);
                }
                list.add(pair[1]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nameToValue;
    }

    public void open() {
        final String filename = IOUtil.getName(this.args.getData());
        new BackgroundTask<GENEEFolderNode>("Loading " + filename){

            @Override
            protected GENEEFolderNode doInBackground() throws Exception {
                if (ApplicationArgsLauncher.this.args.getData() == null) {
                    return null;
                }
                History history = new History("Opened " + filename);
                String urlString = ApplicationArgsLauncher.this.args.getData();
                try {
                    urlString = ApplicationArgsLauncher.decodeUrl(ApplicationArgsLauncher.this.args.getData());
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
                Map nameToValue = ApplicationArgsLauncher.getUrlParams(urlString);
                if (ApplicationArgsLauncher.this.args.getUnparsed() != null) {
                    for (String name : ApplicationArgsLauncher.this.args.getUnparsed().keySet()) {
                        ArrayList list = (ArrayList)nameToValue.get(name);
                        if (list == null) {
                            list = new ArrayList();
                            nameToValue.put(name, list);
                        }
                        list.addAll(ApplicationArgsLauncher.this.args.getUnparsed().get(name));
                    }
                }
                Project p = ApplicationArgsLauncher.createProject(urlString, ApplicationArgsLauncher.this.args, nameToValue);
                ProjectGENEEResultTreeNode node = new ProjectGENEEResultTreeNode(p, history);
                try {
                    List color = (List)nameToValue.get("color");
                    if (color != null && color.size() == 1) {
                        HeatMapColorSchemeOptionsPanel.loadPredefinedColorScheme(((HeatMapPanel)node.getDisplayInfo().getComponent()).getColorScheme(), (String)color.get(0));
                    }
                    List up = (List)nameToValue.get("up");
                    List dn = (List)nameToValue.get("dn");
                    if (up != null || dn != null) {
                        Integer index;
                        Vector sig = MetadataUtil.addRowVector(p.getOriginalDataset().getRowMetadata(), "Signature", String.class);
                        Map idToIndex = VectorUtil.createValueToIndexMap(p.getOriginalDataset().getRowMetadata().get("id"));
                        if (up != null) {
                            for (String id : up) {
                                index = idToIndex.get(id);
                                if (index == null) continue;
                                sig.setValue(index, "up");
                            }
                        }
                        if (up != null) {
                            for (String id : dn) {
                                index = idToIndex.get(id);
                                if (index == null) continue;
                                sig.setValue(index, "dn");
                            }
                        }
                        Vector median = MetadataUtil.addRowVector(p.getOriginalDataset().getRowMetadata(), "Median", Float.class);
                        Median medianFunction = new Median();
                        DatasetRowView view = new DatasetRowView(p.getOriginalDataset());
                        int nrows = p.getOriginalDataset().getRowCount();
                        for (int i = 0; i < nrows; ++i) {
                            view.setIndex(i);
                            median.setValue(i, Float.valueOf(medianFunction.evaluate(view)));
                        }
                        p.setRowSortOrder(Arrays.asList(new SortKeys.VectorSortKey(sig.getName(), SortOrder.DESCENDING, true), new SortKeys.VectorSortKey(median.getName(), SortOrder.DESCENDING, true)));
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                return new GENEEFolderNode("Open File", history, node);
            }

            @Override
            protected void succeeded(GENEEFolderNode node) {
                if (node != null) {
                    Application.add(node);
                }
            }
        }.execute();
    }

    private static Project createProject(String url, Application.ApplicationArgs args, Map<String, List<String>> nameToValue) throws Exception {
        Vector v;
        int i;
        List<String> formatList = nameToValue.get("_fmt");
        ProjectReader reader = null;
        if (formatList != null && formatList.size() == 1) {
            String format = formatList.get(0);
            reader = ProjectIO.getProjectReaderBySuffix(format);
        } else {
            reader = ProjectIO.getProjectReader(url);
        }
        if (reader == null) {
            reader = new GctReader();
        }
        Project p = reader.read(url);
        Dataset dataset = p.getOriginalDataset();
        ArrayList<String> columnColorColumns = new ArrayList<String>();
        if (args.getColumnColorBarColumns() != null) {
            if (args.getColumnColorBarColumns().toLowerCase().endsWith(".cls")) {
                DefaultClassVector classVector = IOUtil.readCls(args.getColumnColorBarColumns());
                columnColorColumns.add(AnnotateAction.loadClassVector(dataset.getColumnMetadata(), classVector).getName());
            } else {
                columnColorColumns.addAll(((AddToMetadataContentHandler)new ExcelReader(args.getColumnColorBarColumns(), new AddToMetadataContentHandler(dataset.getColumnMetadata(), p.getColumnColorModel(), null, VectorUtil.createStringValueToIndicesMap(dataset.getColumnMetadata().get(0)), false)).getContentHandler()).getMetadataColumnNames());
            }
        }
        ArrayList<String> rowColorColumns = new ArrayList<String>();
        ArrayList<String> rowTextColumns = new ArrayList<String>();
        ArrayList<String> columnTextColumns = new ArrayList<String>();
        if (args.getRowColorBarColumns() != null) {
            rowColorColumns.addAll(((AddToMetadataContentHandler)new ExcelReader(args.getRowColorBarColumns(), new AddToMetadataContentHandler(dataset.getRowMetadata(), p.getRowColorModel(), null, VectorUtil.createStringValueToIndicesMap(dataset.getRowMetadata().get(0)), true)).getContentHandler()).getMetadataColumnNames());
        }
        if (args.getRowTextColumns() != null) {
            rowTextColumns.addAll(((AddToMetadataContentHandler)new ExcelReader(args.getRowTextColumns(), new AddToMetadataContentHandler(dataset.getRowMetadata(), p.getRowColorModel(), null, VectorUtil.createStringValueToIndicesMap(dataset.getRowMetadata().get(0)), true)).getContentHandler()).getMetadataColumnNames());
        }
        if (args.getColumnTextColumns() != null) {
            columnTextColumns.addAll(((AddToMetadataContentHandler)new ExcelReader(args.getColumnTextColumns(), new AddToMetadataContentHandler(dataset.getColumnMetadata(), p.getColumnColorModel(), null, VectorUtil.createStringValueToIndicesMap(dataset.getColumnMetadata().get(0)), false)).getContentHandler()).getMetadataColumnNames());
        }
        if (args.getAtr() != null) {
            String[] arrayIds = new String[dataset.getColumnCount()];
            int columns = dataset.getColumnCount();
            for (int j = 0; j < columns; ++j) {
                arrayIds[j] = (String)dataset.getColumnMetadata().getValue(j, "array id");
            }
            p.setColumnDendrogram(new AtrGtrDendrogram(arrayIds, args.getAtr()));
        }
        if (args.getGtr() != null) {
            String[] geneIds = new String[dataset.getRowCount()];
            int rows = dataset.getRowCount();
            for (i = 0; i < rows; ++i) {
                geneIds[i] = (String)dataset.getRowMetadata().getValue(i, "gene id");
            }
            p.setRowDendrogram(new AtrGtrDendrogram(geneIds, args.getGtr()));
        }
        MetadataUtil.maybeConvertMetadataClass(dataset, !(reader instanceof GctxProjectReader));
        if (!args.isJnlp()) {
            MetadataUtil.setRowMetadataVisibility(p.getOriginalDataset().getRowMetadata());
        }
        if (!args.isJnlp()) {
            MetadataUtil.setColumnMetadataVisibility(p.getOriginalDataset().getColumnMetadata());
        }
        MetadataModel model = p.getOriginalDataset().getRowMetadata();
        int size = model.getMetadataCount();
        for (i = 0; i < size; ++i) {
            v = model.get(i);
            if (!v.getName().toLowerCase().endsWith("_query")) continue;
            v.removeProperty("Text Visible");
            v.setProperty("Color Visible", true);
        }
        for (String name : rowColorColumns) {
            v = dataset.getRowMetadata().get(name);
            v.removeProperty("Text Visible");
            v.setProperty("Color Visible", true);
        }
        for (String name : columnColorColumns) {
            v = dataset.getColumnMetadata().get(name);
            v.removeProperty("Text Visible");
            v.setProperty("Color Visible", true);
        }
        for (String name : rowTextColumns) {
            v = dataset.getRowMetadata().get(name);
            v.removeProperty("Color Visible");
            v.setProperty("Text Visible", true);
        }
        for (String name : columnTextColumns) {
            v = dataset.getColumnMetadata().get(name);
            v.removeProperty("Color Visible");
            v.setProperty("Text Visible", true);
        }
        model = p.getOriginalDataset().getColumnMetadata();
        ArrayList<String> rowQueryNames = new ArrayList<String>();
        int size2 = model.getMetadataCount();
        for (int i2 = 0; i2 < size2; ++i2) {
            Vector v2 = model.get(i2);
            if (!v2.getName().toLowerCase().endsWith("_query")) continue;
            v2.setProperty("Color Visible", true);
            v2.removeProperty("Text Visible");
            if (IOUtil.isNumber(v2.getColumnClass())) {
                v2.setProperty("Continuous Key", true);
            }
            rowQueryNames.add(model.getColumnName(i2));
        }
        if (nameToValue.get("rowSortOrder") == null && rowQueryNames.size() > 0) {
            ArrayList<SortKeys.VectorSortKey> rowSortKeys = new ArrayList<SortKeys.VectorSortKey>();
            for (String name : rowQueryNames) {
                rowSortKeys.add(new SortKeys.VectorSortKey(name, SortOrder.DESCENDING, true));
            }
            p.setRowSortOrder(rowSortKeys);
        }
        ApplicationArgsLauncher.setDisplayProperties(nameToValue, "rtext", "Text Visible", p.getOriginalDataset().getRowMetadata());
        ApplicationArgsLauncher.setDisplayProperties(nameToValue, "ctext", "Text Visible", p.getOriginalDataset().getColumnMetadata());
        ApplicationArgsLauncher.setDisplayProperties(nameToValue, "rcolor", "Color Visible", p.getOriginalDataset().getRowMetadata());
        ApplicationArgsLauncher.setDisplayProperties(nameToValue, "ccolor", "Color Visible", p.getOriginalDataset().getColumnMetadata());
        if (nameToValue.get("rowSortOrder") != null) {
            String delim = "%3B";
            ArrayList<SortKeys.VectorSortKey> rowSortKeys = new ArrayList<SortKeys.VectorSortKey>();
            List<String> rowSortOrder = nameToValue.get("rowSortOrder");
            for (String sort : rowSortOrder) {
                int index = sort.lastIndexOf(delim);
                if (index != -1) {
                    String field = sort.substring(0, index);
                    String dir = sort.substring(index + delim.length());
                    Vector v3 = p.getOriginalDataset().getRowMetadata().get(field);
                    if (v3 != null) {
                        rowSortKeys.add(new SortKeys.VectorSortKey(field, "desc".equals(dir) ? SortOrder.DESCENDING : SortOrder.ASCENDING, true));
                        continue;
                    }
                    System.out.println(sort + " not found.");
                    continue;
                }
                System.out.println(sort + " not found.");
            }
            if (rowSortKeys.size() > 0) {
                p.setRowSortOrder(rowSortKeys);
            }
        }
        return p;
    }

    private static void setDisplayProperties(Map<String, List<String>> nameToValue, String flag, String property, MetadataModel model) {
        if (nameToValue.get(flag) != null) {
            List<String> fields = nameToValue.get(flag);
            for (String field : fields) {
                Vector v = model.get(field);
                if (v == null) continue;
                v.setProperty(property, true);
            }
        }
    }
}

