/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.broadinstitute.genee.gui.ActionListenerHelper;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.io.util.ParserHelper;

class ColorSchemeLegendInputPanel
extends JPanel {
    private float min;
    private float mid;
    private float max;
    private JTextField minimumTextField = new JTextField(10);
    private JTextField maximumTextField = new JTextField(10);
    private JTextField meanTextField = new JTextField(10);
    private ActionListenerHelper actionListenerHelper = new ActionListenerHelper();

    ColorSchemeLegendInputPanel() {
        this.setMin(-3.0f);
        this.setMid(0.0f);
        this.setMax(3.0f);
        CellConstraints cc = new CellConstraints();
        this.setLayout((LayoutManager)new FormLayout("pref, 4dlu, pref", "pref, 2dlu, pref, 2dlu, pref, 2dlu, pref"));
        JButton updateButton = new JButton("Update");
        updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ColorSchemeLegendInputPanel.this.min = ParserHelper.parseFloat(ColorSchemeLegendInputPanel.this.minimumTextField.getText().trim());
                }
                catch (NumberFormatException e1) {
                    UIUtil.showErrorDialog(ColorSchemeLegendInputPanel.this, "Minimum is not a number.");
                    return;
                }
                try {
                    ColorSchemeLegendInputPanel.this.max = ParserHelper.parseFloat(ColorSchemeLegendInputPanel.this.maximumTextField.getText().trim());
                }
                catch (NumberFormatException e1) {
                    UIUtil.showErrorDialog(ColorSchemeLegendInputPanel.this, "Maximum is not a number.");
                    return;
                }
                try {
                    ColorSchemeLegendInputPanel.this.mid = ParserHelper.parseFloat(ColorSchemeLegendInputPanel.this.meanTextField.getText().trim());
                }
                catch (NumberFormatException e1) {
                    UIUtil.showErrorDialog(ColorSchemeLegendInputPanel.this, "Mean is not a number.");
                    return;
                }
                if (ColorSchemeLegendInputPanel.this.mid <= ColorSchemeLegendInputPanel.this.min) {
                    UIUtil.showErrorDialog(ColorSchemeLegendInputPanel.this, "Mean must be greater than minimum.");
                    return;
                }
                if (ColorSchemeLegendInputPanel.this.mid >= ColorSchemeLegendInputPanel.this.max) {
                    UIUtil.showErrorDialog(ColorSchemeLegendInputPanel.this, "Mean must be less than than maximum.");
                    return;
                }
                ColorSchemeLegendInputPanel.this.actionListenerHelper;
                ActionListenerHelper.fireActionPerformed(ColorSchemeLegendInputPanel.this.listenerList, ColorSchemeLegendInputPanel.this, e);
            }
        });
        this.add((Component)new JLabel("Minimum"), cc.xy(1, 1));
        this.add((Component)this.minimumTextField, cc.xy(3, 1));
        this.add((Component)new JLabel("Maximum"), cc.xy(1, 3));
        this.add((Component)this.maximumTextField, cc.xy(3, 3));
        this.add((Component)new JLabel("Mean"), cc.xy(1, 5));
        this.add((Component)this.meanTextField, cc.xy(3, 5));
        this.add((Component)updateButton, cc.xy(1, 7));
    }

    public void addActionListener(ActionListener l) {
        this.actionListenerHelper.addActionListener(this.listenerList, l);
    }

    public float getMax() {
        return this.max;
    }

    public float getMid() {
        return this.mid;
    }

    public float getMin() {
        return this.min;
    }

    public void removeActionListener(ActionListener l) {
        this.actionListenerHelper.removeActionListener(this.listenerList, l);
    }

    public void setMax(float max) {
        this.max = max;
        this.maximumTextField.setText("" + max);
    }

    public void setMid(float mid) {
        this.mid = mid;
        this.meanTextField.setText("" + mid);
    }

    public void setMin(float min) {
        this.min = min;
        this.minimumTextField.setText("" + min);
    }
}

