/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import org.broadinstitute.genee.heatmap.CurveElement;
import org.broadinstitute.genee.heatmap.CurveElementList;

public class CombinedCurveElement
implements CurveElement,
CurveElementList {
    private CurveElement element1;
    private CurveElement element2;

    public CombinedCurveElement(CurveElement element1, CurveElement element2) {
        this.element1 = element1;
        this.element2 = element2;
    }

    @Override
    public boolean containsFit() {
        return this.element1.containsFit();
    }

    @Override
    public float evaluate(float x) {
        return this.element1.evaluate(x) - this.element2.evaluate(x);
    }

    @Override
    public CurveElement get(int index) {
        return this;
    }

    @Override
    public int getSeriesCount() {
        return 1;
    }

    @Override
    public float getSpecialX() {
        return this.element1.getSpecialX() - this.element2.getSpecialX();
    }

    @Override
    public float getX(int i) {
        return this.element1.getX(i);
    }

    @Override
    public float getY(int i) {
        return this.element1.getY(i) - this.element2.getY(i);
    }

    @Override
    public float getYError(int i) {
        return this.element1.getYError(i) - this.element2.getYError(i);
    }

    @Override
    public int size() {
        return this.element1.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.element1.toString());
        sb.append("<br>");
        sb.append(this.element2.toString());
        return sb.toString();
    }
}

