/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.CoordinateMapper;
import org.broadinstitute.genee.heatmap.CurveElement;
import org.broadinstitute.genee.heatmap.CurveElementList;
import org.broadinstitute.genee.heatmap.ElementPainter;
import org.broadinstitute.genee.heatmap.HeatMapColorScheme;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.WorldCoordinateMapper;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;

public class CurveElementPainter
implements ElementPainter {
    public static final int SCALE_COLUMN_MIN_MAX = 0;
    public static final int SCALE_ELEMENT_MIN_MAX = 1;
    public static final int SCALE_ROW_MIN_MAX = 2;
    public static final int SCALE_CUSTOM = 3;
    public static final int SCALE_GLOBAL = 4;
    private static final int MIN_SIZE_TO_DRAW_CURVES = 8;
    private boolean autoconfigureColorScheme = true;
    private Color backgroundColor;
    private HeatMapColorScheme colorScheme;
    private CoordinateMapper coordinateMapper;
    private float customYMax = 100.0f;
    private float customYMin = 0.0f;
    private float customXMax = 10.0f;
    private float customXMin = 0.0f;
    private String[] groupCurvesBy;
    private int curveElementDatasetSeriesIndex;
    private Path2D.Float path = new Path2D.Float();
    private Project project;
    private Rectangle2D.Float rect = new Rectangle2D.Float();
    private Ellipse2D.Float circle = new Ellipse2D.Float();
    private int yScalingMode = 4;
    private int xScalingMode = 4;
    private float globalYMin = Float.NaN;
    private float globalYMax = Float.NaN;
    private float globalXMin = Float.NaN;
    private float globalXMax = Float.NaN;
    private int cachedRowIndexForYScale = -1;
    private int cachedColumnIndexForYScale = -1;
    private int cachedRowIndexForXScale = -1;
    private int cachedColumnIndexForXScale = -1;
    private float rowOrColumnYMin;
    private float rowOrColumnYMax;
    private float rowOrColumnXMin;
    private float rowOrColumnXMax;
    private boolean filled = true;
    private Color lineColor = Color.GRAY;
    private Color pointColor = new Color(110, 110, 110);
    private Color fillColor = new Color(190, 190, 190);
    private boolean drawPoints = true;
    private Dataset originalDataset;
    private boolean drawFit = true;
    private boolean drawIC50 = true;
    private boolean drawErrorBars = true;

    public void configureColorScheme(HeatMapColorScheme cs) {
        cs.setRelative(false);
    }

    @Override
    public ElementPainter copy() {
        CurveElementPainter c = new CurveElementPainter();
        c.autoconfigureColorScheme = this.autoconfigureColorScheme;
        c.filled = this.filled;
        c.drawPoints = this.drawPoints;
        c.yScalingMode = this.yScalingMode;
        c.customYMin = this.customYMin;
        c.customYMax = this.customYMax;
        c.backgroundColor = this.backgroundColor;
        return c;
    }

    public void draw(Graphics2D g2, CurveElementList elementList, float xpix, float ypix, float columnSize, float rowSize, float xmin, float xmax, float ymin, float ymax, float pointSize) {
        this.coordinateMapper.setXMin(xmin);
        this.coordinateMapper.setXMax(xmax);
        this.coordinateMapper.setYMin(ymin);
        this.coordinateMapper.setYMax(ymax);
        this.coordinateMapper.setXPixelScale(columnSize);
        this.coordinateMapper.setYPixelScale(rowSize);
        Shape oldClip = g2.getClip();
        this.rect.x = xpix;
        this.rect.y = ypix;
        this.rect.width = columnSize;
        this.rect.height = rowSize;
        this.circle.height = this.circle.width = pointSize;
        g2.setClip(this.rect);
        int nseries = elementList.getSeriesCount();
        for (int seriesIndex = 0; seriesIndex < nseries; ++seriesIndex) {
            boolean filled;
            float pathX;
            float pathY;
            float y;
            float x;
            this.path.reset();
            CurveElement element = elementList.get(seriesIndex);
            boolean fit = element.containsFit();
            int curveXStartIndex = -1;
            if (fit && this.drawFit) {
                int nsteps = 100;
                float inc = (xmax - xmin) / (float)nsteps;
                x = xmin;
                int i = 0;
                while (i < nsteps) {
                    y = element.evaluate(x);
                    if (!Float.isNaN(y)) {
                        float pathY2 = this.coordinateMapper.yToPix(y) + ypix;
                        float pathX2 = xpix + this.coordinateMapper.xToPix(x);
                        if (curveXStartIndex == -1) {
                            this.path.moveTo(pathX2, pathY2);
                            curveXStartIndex = i;
                        } else {
                            this.path.lineTo(pathX2, pathY2);
                        }
                    }
                    ++i;
                    x += inc;
                }
            } else {
                int i;
                xmax = -3.4028235E38f;
                int size = element.size();
                for (i = 0; i < size; ++i) {
                    float val = element.getX(i);
                    if (Float.isNaN(val)) continue;
                    xmax = Math.max(xmax, val);
                }
                size = element.size();
                for (i = 0; i < size; ++i) {
                    x = element.getX(i);
                    float y2 = element.getY(i);
                    if (Float.isNaN(y2)) continue;
                    pathY = this.coordinateMapper.yToPix(y2) + ypix;
                    pathX = xpix + this.coordinateMapper.xToPix(x);
                    if (curveXStartIndex == -1) {
                        this.path.moveTo(pathX, pathY);
                        curveXStartIndex = i;
                        continue;
                    }
                    this.path.lineTo(pathX, pathY);
                }
            }
            if (filled = this.filled) {
                g2.setStroke(new BasicStroke(2.0f));
            }
            g2.setColor(this.lineColor);
            g2.draw(this.path);
            if (filled) {
                g2.setColor(this.fillColor);
                g2.setStroke(new BasicStroke(1.0f));
                this.path.lineTo(xpix + this.coordinateMapper.xToPix(xmax), ypix + rowSize);
                float xPixStart = xpix + this.coordinateMapper.xToPix(xmin);
                this.path.lineTo(xPixStart, ypix + rowSize);
                this.path.closePath();
                g2.fill(this.path);
            }
            if (this.drawErrorBars) {
                g2.setColor(this.pointColor);
                Line2D.Float line = new Line2D.Float();
                int size = element.size();
                for (int i = 0; i < size; ++i) {
                    float lineX;
                    y = element.getY(i);
                    if (Float.isNaN(y)) continue;
                    float error = element.getYError(i);
                    float ylow = y - error;
                    float yhigh = y + error;
                    float lineYLow = this.coordinateMapper.yToPix(ylow) + ypix;
                    float lineYHigh = this.coordinateMapper.yToPix(yhigh) + ypix;
                    line.x2 = line.x1 = (lineX = xpix + this.coordinateMapper.xToPix(element.getX(i)));
                    line.y1 = lineYLow;
                    line.y2 = lineYHigh;
                    g2.draw(line);
                }
            }
            if (this.drawPoints) {
                g2.setColor(this.pointColor);
                int size = element.size();
                for (int i = 0; i < size; ++i) {
                    float y3 = element.getY(i);
                    if (Float.isNaN(y3)) continue;
                    pathY = this.coordinateMapper.yToPix(y3) + ypix;
                    pathX = xpix + this.coordinateMapper.xToPix(element.getX(i));
                    this.circle.x = pathX - this.circle.width / 2.0f;
                    this.circle.y = pathY - this.circle.height / 2.0f;
                    g2.fill(this.circle);
                }
            }
            if (!this.drawIC50) continue;
            float ic50x = xpix + this.coordinateMapper.xToPix(element.getSpecialX()) - pointSize / 2.0f;
            float ic50y = ypix + this.coordinateMapper.yToPix(element.evaluate(element.getSpecialX())) - this.circle.height / 2.0f;
            this.rect.x = ic50x;
            this.rect.y = ic50y;
            this.rect.width = pointSize;
            this.rect.height = pointSize;
            g2.setColor(UIUtil.HIGHLIGHT_COLOR);
            g2.fill(this.rect);
        }
        g2.setColor(this.lineColor);
        g2.setClip(oldClip);
    }

    @Override
    public void draw(Graphics2D g, Dataset dataset, int row, int column, float xpix, float ypix, float columnSize, float rowSize) {
        Graphics2D g2 = g;
        CurveElementList elementList = (CurveElementList)dataset.getObjectValue(row, column, this.curveElementDatasetSeriesIndex);
        if (this.backgroundColor != null) {
            g2.setColor(this.backgroundColor);
            this.rect.setRect(xpix, ypix, columnSize, rowSize);
            g2.fill(this.rect);
        }
        if (elementList == null) {
            return;
        }
        float xmin = 0.0f;
        float xmax = 0.0f;
        if (this.xScalingMode == 2 || this.xScalingMode == 0) {
            this.setRowOrColumnXMinMax(dataset, row, column);
            xmin = this.rowOrColumnXMin;
            xmax = this.rowOrColumnXMax;
        } else if (this.xScalingMode == 3) {
            xmin = this.customXMin;
            xmax = this.customXMax;
        } else if (this.xScalingMode == 4) {
            xmin = this.globalXMin;
            xmax = this.globalXMax;
        } else if (this.xScalingMode == 1) {
            xmin = Float.MAX_VALUE;
            xmax = -3.4028235E38f;
            int nseries = elementList.getSeriesCount();
            for (int seriesIndex = 0; seriesIndex < nseries; ++seriesIndex) {
                CurveElement element = elementList.get(seriesIndex);
                int size = element.size();
                for (int i = 0; i < size; ++i) {
                    float val = element.getX(i);
                    if (Float.isNaN(val)) continue;
                    xmin = Math.min(xmin, val);
                    xmax = Math.max(xmax, val);
                }
            }
        } else {
            System.err.println("Unknown x scaling mode: " + this.xScalingMode);
        }
        float ymin = 0.0f;
        float ymax = 0.0f;
        if (this.yScalingMode == 2 || this.yScalingMode == 0) {
            this.setRowOrColumnYMinMax(dataset, row, column);
            ymin = this.rowOrColumnYMin;
            ymax = this.rowOrColumnYMax;
        } else if (this.yScalingMode == 1) {
            ymin = Float.MAX_VALUE;
            ymax = -3.4028235E38f;
            int nseries = elementList.getSeriesCount();
            for (int seriesIndex = 0; seriesIndex < nseries; ++seriesIndex) {
                CurveElement element = elementList.get(seriesIndex);
                int size = element.size();
                for (int i = 0; i < size; ++i) {
                    float val = element.getY(i);
                    if (Float.isNaN(val)) continue;
                    float error = element.getYError(i);
                    float minVal = val - error;
                    float maxVal = val + error;
                    ymin = Math.min(ymin, minVal);
                    ymax = Math.max(ymax, maxVal);
                }
            }
        } else if (this.yScalingMode == 3) {
            ymin = this.customYMin;
            ymax = this.customYMax;
        } else if (this.yScalingMode == 4) {
            ymin = this.globalYMin;
            ymax = this.globalYMax;
        }
        if (columnSize <= 8.0f || rowSize <= 8.0f) {
            g2.setColor(this.colorScheme.getColor(row, column, dataset.getValue(row, column)));
            this.rect.setRect(xpix, ypix, columnSize, rowSize);
            g2.fill(this.rect);
            return;
        }
        float pointSize = Math.min(rowSize, columnSize) * 0.1f;
        pointSize = Math.min(pointSize, 6.0f);
        this.draw(g2, elementList, xpix, ypix, columnSize, rowSize, xmin, xmax, ymin, ymax, pointSize);
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public float getCustomXMax() {
        return this.customXMax;
    }

    public float getCustomXMin() {
        return this.customXMin;
    }

    public float getCustomYMax() {
        return this.customYMax;
    }

    public float getCustomYMin() {
        return this.customYMin;
    }

    public String[] getGroupCurvesBy() {
        return this.groupCurvesBy;
    }

    public Dataset getOriginalDataset() {
        return this.originalDataset;
    }

    public int getXScalingMode() {
        return this.xScalingMode;
    }

    public int getYScalingMode() {
        return this.yScalingMode;
    }

    public boolean isAutoconfigureColorScheme() {
        return this.autoconfigureColorScheme;
    }

    public boolean isDrawErrorBars() {
        return this.drawErrorBars;
    }

    public boolean isDrawFit() {
        return this.drawFit;
    }

    public boolean isDrawIC50() {
        return this.drawIC50;
    }

    public boolean isDrawPoints() {
        return this.drawPoints;
    }

    public boolean isFilled() {
        return this.filled;
    }

    public void setAutoconfigureColorScheme(boolean autoconfigureColorScheme) {
        this.autoconfigureColorScheme = autoconfigureColorScheme;
    }

    public void setBackgroundColor(Color backgroundColor) {
        if (backgroundColor != null && backgroundColor.equals(Color.WHITE)) {
            backgroundColor = null;
        }
        this.backgroundColor = backgroundColor;
    }

    @Override
    public boolean setColorScheme(HeatMapColorScheme colorScheme) {
        this.colorScheme = colorScheme;
        this.configureColorScheme(colorScheme);
        return !this.filled;
    }

    public void setCustomXMax(float max) {
        this.customXMax = max;
    }

    public void setCustomXMin(float min) {
        this.customXMin = min;
    }

    public void setCustomYMax(float customMax) {
        this.customYMax = customMax;
    }

    public void setCustomYMin(float customMin) {
        this.customYMin = customMin;
    }

    public void setDrawErrorBars(boolean drawErrorBars) {
        this.drawErrorBars = drawErrorBars;
    }

    public void setDrawFit(boolean b) {
        this.drawFit = b;
    }

    public void setDrawIC50(boolean b) {
        this.drawIC50 = b;
    }

    public void setDrawPoints(boolean drawPoints) {
        this.drawPoints = drawPoints;
    }

    public void setFilled(boolean filled) {
        this.filled = filled;
    }

    public void setGroupCurvesBy(String[] groupCurvesBy) {
        this.groupCurvesBy = groupCurvesBy;
    }

    public void setOriginalDataset(Dataset originalDataset) {
        this.originalDataset = originalDataset;
    }

    @Override
    public void setProject(Project p) {
        float val;
        int k;
        int size;
        CurveElement element;
        int seriesIndex;
        int nseries;
        CurveElementList elementList;
        int j;
        int cols;
        int i;
        int rows;
        float max;
        float min;
        this.project = p;
        Dataset dataset = this.project.getOriginalDataset();
        this.curveElementDatasetSeriesIndex = DatasetUtil.getSeriesIndex(dataset, CurveElementList.class);
        this.coordinateMapper = new WorldCoordinateMapper();
        this.coordinateMapper.setTopGutter(2.0f);
        this.coordinateMapper.setBottomGutter(2.0f);
        this.coordinateMapper.setLeftGutter(2.0f);
        this.coordinateMapper.setRightGutter(2.0f);
        this.cachedColumnIndexForXScale = -1;
        this.cachedColumnIndexForYScale = -1;
        this.cachedRowIndexForXScale = -1;
        this.cachedRowIndexForYScale = -1;
        if (this.yScalingMode == 4) {
            min = Float.MAX_VALUE;
            max = -3.4028235E38f;
            rows = dataset.getRowCount();
            for (i = 0; i < rows; ++i) {
                cols = dataset.getColumnCount();
                for (j = 0; j < cols; ++j) {
                    elementList = (CurveElementList)dataset.getObjectValue(i, j, this.curveElementDatasetSeriesIndex);
                    if (elementList == null) continue;
                    nseries = elementList.getSeriesCount();
                    for (seriesIndex = 0; seriesIndex < nseries; ++seriesIndex) {
                        element = elementList.get(seriesIndex);
                        size = element.size();
                        for (k = 0; k < size; ++k) {
                            val = element.getY(k);
                            if (Float.isNaN(val)) continue;
                            float error = element.getYError(k);
                            float minVal = val - error;
                            float maxVal = val + error;
                            max = Math.max(max, maxVal);
                            min = Math.min(min, minVal);
                        }
                    }
                }
            }
            this.globalYMin = min;
            this.globalYMax = max;
        }
        if (this.xScalingMode == 4) {
            min = Float.MAX_VALUE;
            max = -3.4028235E38f;
            rows = dataset.getRowCount();
            for (i = 0; i < rows; ++i) {
                cols = dataset.getColumnCount();
                for (j = 0; j < cols; ++j) {
                    elementList = (CurveElementList)dataset.getObjectValue(i, j, this.curveElementDatasetSeriesIndex);
                    if (elementList == null) continue;
                    nseries = elementList.getSeriesCount();
                    for (seriesIndex = 0; seriesIndex < nseries; ++seriesIndex) {
                        element = elementList.get(seriesIndex);
                        size = element.size();
                        for (k = 0; k < size; ++k) {
                            val = element.getX(k);
                            if (Float.isNaN(val)) continue;
                            max = Math.max(max, val);
                            min = Math.min(min, val);
                        }
                    }
                }
            }
            this.globalXMin = min;
            this.globalXMax = max;
        }
    }

    public void setXScalingMode(int xScalingMode) {
        this.xScalingMode = xScalingMode;
        this.cachedRowIndexForXScale = -1;
        this.cachedColumnIndexForXScale = -1;
    }

    public void setYScalingMode(int scaling) {
        this.yScalingMode = scaling;
        this.cachedRowIndexForYScale = -1;
        this.cachedColumnIndexForYScale = -1;
    }

    private void setRowOrColumnXMinMax(Dataset dataset, int rowIndex, int columnIndex) {
        int scalingMode = this.xScalingMode;
        if (scalingMode == 2 && this.cachedRowIndexForXScale == rowIndex) {
            return;
        }
        if (scalingMode == 0 && this.cachedColumnIndexForXScale == columnIndex) {
            return;
        }
        int index = rowIndex;
        if (scalingMode == 0) {
            dataset = DatasetUtil.transposeView(dataset);
            index = columnIndex;
            this.cachedColumnIndexForXScale = columnIndex;
        } else {
            this.cachedRowIndexForXScale = rowIndex;
        }
        this.rowOrColumnXMin = Float.MAX_VALUE;
        this.rowOrColumnXMax = -3.4028235E38f;
        int cols = dataset.getColumnCount();
        for (int j = 0; j < cols; ++j) {
            CurveElementList elementList = (CurveElementList)dataset.getObjectValue(index, j, this.curveElementDatasetSeriesIndex);
            if (elementList == null) continue;
            int nseries = elementList.getSeriesCount();
            for (int seriesIndex = 0; seriesIndex < nseries; ++seriesIndex) {
                CurveElement element = elementList.get(seriesIndex);
                int size = element.size();
                for (int k = 0; k < size; ++k) {
                    float val = element.getX(k);
                    if (Float.isNaN(val)) continue;
                    this.rowOrColumnXMax = Math.max(this.rowOrColumnXMax, val);
                    this.rowOrColumnXMin = Math.min(this.rowOrColumnXMin, val);
                }
            }
        }
    }

    private void setRowOrColumnYMinMax(Dataset dataset, int rowIndex, int columnIndex) {
        int scalingMode = this.yScalingMode;
        if (scalingMode == 2 && this.cachedRowIndexForYScale == rowIndex) {
            return;
        }
        if (scalingMode == 0 && this.cachedColumnIndexForYScale == columnIndex) {
            return;
        }
        int index = rowIndex;
        if (scalingMode == 0) {
            dataset = DatasetUtil.transposeView(dataset);
            index = columnIndex;
            this.cachedColumnIndexForYScale = columnIndex;
        } else {
            this.cachedRowIndexForYScale = rowIndex;
        }
        this.rowOrColumnYMin = Float.MAX_VALUE;
        this.rowOrColumnYMax = -3.4028235E38f;
        int cols = dataset.getColumnCount();
        for (int j = 0; j < cols; ++j) {
            CurveElementList elementList = (CurveElementList)dataset.getObjectValue(index, j, this.curveElementDatasetSeriesIndex);
            if (elementList == null) continue;
            int nseries = elementList.getSeriesCount();
            for (int seriesIndex = 0; seriesIndex < nseries; ++seriesIndex) {
                CurveElement element = elementList.get(seriesIndex);
                int size = element.size();
                for (int k = 0; k < size; ++k) {
                    float val = element.getY(k);
                    if (Float.isNaN(val)) continue;
                    float error = element.getYError(k);
                    float minVal = val - error;
                    float maxVal = val + error;
                    this.rowOrColumnYMax = Math.max(this.rowOrColumnYMax, maxVal);
                    this.rowOrColumnYMin = Math.min(this.rowOrColumnYMin, minVal);
                }
            }
        }
    }
}

