/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.broadinstitute.genee.gui.TableToolTip;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.CurveElement;
import org.broadinstitute.genee.heatmap.CurveElementList;
import org.broadinstitute.genee.heatmap.CurveElementPainter;
import org.broadinstitute.genee.heatmap.ElementPainter;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.matrix.AbstractDatasetView;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetColumnView;
import org.broadinstitute.genee.matrix.DatasetRowView;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.table.BasicHeatMapColumnTable;
import org.broadinstitute.genee.table.HeatMapColumnTable;
import org.broadinstitute.genee.table.HeatMapRowTable;

public class CurveTableCellRenderer
extends DefaultTableCellRenderer {
    private HeatMapPanel heatMapPanel;
    private boolean rows;

    public CurveTableCellRenderer(HeatMapPanel heatMapPanel, boolean rows) {
        this.setPreferredSize(new Dimension(150, 50));
        this.heatMapPanel = heatMapPanel;
        this.rows = rows;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        AbstractDatasetView view = null;
        try {
            int height;
            int width;
            TableToolTip table2;
            Dataset dataset = (Dataset)value;
            if (this.rows) {
                table2 = (HeatMapRowTable)table;
                view = new DatasetRowView(dataset);
                view.setIndex(row);
                width = table.getColumnModel().getColumn(column).getWidth();
                height = (int)Math.floor(((HeatMapRowTable)table2).getViewSizesAndPositions().getSize());
            } else {
                table2 = (HeatMapColumnTable)((Object)table);
                view = new DatasetColumnView(dataset);
                view.setIndex(column);
                height = table.getRowHeight(row);
                width = (int)Math.floor(((BasicHeatMapColumnTable)((Object)table2)).getViewSizesAndPositions().getSize());
            }
            ElementPainter p = this.heatMapPanel.getElementPainter();
            if (dataset == null || !(p instanceof CurveElementPainter)) {
                this.setIcon(null);
                return this;
            }
            CurveElementPainter painter = (CurveElementPainter)p;
            boolean savedFilled = painter.isFilled();
            boolean savedErrorBars = painter.isDrawErrorBars();
            boolean savedDrawPoints = painter.isDrawPoints();
            painter.setFilled(false);
            painter.setDrawPoints(false);
            painter.setDrawErrorBars(false);
            int curveElementDatasetSeriesIndex = DatasetUtil.getSeriesIndex(view.getDataset(), CurveElementList.class);
            if (curveElementDatasetSeriesIndex == -1) {
                this.setIcon(null);
                return this;
            }
            float ymin = Float.MAX_VALUE;
            float xmin = Float.MAX_VALUE;
            float ymax = -3.4028235E38f;
            float xmax = -3.4028235E38f;
            float pointSize = (float)Math.min(width, height) * 0.08f;
            pointSize = Math.min(pointSize, 6.0f);
            int viewSize = view.size();
            for (int i = 0; i < viewSize; ++i) {
                CurveElementList elementList = (CurveElementList)view.getObjectValue(i, curveElementDatasetSeriesIndex);
                if (elementList == null) continue;
                int nelements = elementList.getSeriesCount();
                for (int elementIndex = 0; elementIndex < nelements; ++elementIndex) {
                    CurveElement element = elementList.get(elementIndex);
                    xmax = Math.max(xmax, element.getX(element.size() - 1));
                    xmin = Math.min(xmin, element.getX(0));
                    if (element == null) continue;
                    int size = element.size();
                    for (int k = 0; k < size; ++k) {
                        float val = element.getY(k);
                        if (Float.isNaN(val)) continue;
                        ymax = Math.max(ymax, val);
                        ymin = Math.min(ymin, val);
                    }
                }
            }
            ymax += ymax * 0.1f;
            BufferedImage image = new BufferedImage(width, height, 2);
            Graphics2D g = (Graphics2D)image.getGraphics();
            g.setRenderingHints(UIUtil.RENDERING_HINTS);
            this.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            g.setColor(isSelected ? table.getSelectionBackground() : table.getBackground());
            g.fillRect(0, 0, image.getWidth(), image.getHeight());
            int viewSize2 = view.size();
            for (int i = 0; i < viewSize2; ++i) {
                CurveElementList elementList = (CurveElementList)view.getObjectValue(i, curveElementDatasetSeriesIndex);
                if (elementList == null) continue;
                painter.draw(g, elementList, 0.0f, 0.0f, width, height, xmin, xmax, ymin, ymax, 4.0f);
            }
            painter.setDrawErrorBars(savedErrorBars);
            painter.setDrawPoints(savedDrawPoints);
            painter.setFilled(savedFilled);
            g.dispose();
            ImageIcon imageIcon = new ImageIcon(image);
            this.setIcon(imageIcon);
            return this;
        }
        catch (Exception e) {
            System.err.println("Renderer error");
            e.printStackTrace();
            this.setIcon(null);
            return this;
        }
    }
}

