/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import org.broadinstitute.genee.chart.ShapeUtil;
import org.broadinstitute.genee.filter.BetweenFloatFilter;
import org.broadinstitute.genee.filter.FloatFilter;
import org.broadinstitute.genee.heatmap.ElementPainter;
import org.broadinstitute.genee.heatmap.HeatMapColorScheme;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.matrix.Dataset;

public final class DefaultElementPainter
implements ElementPainter {
    private HeatMapColorScheme colorScheme;
    private boolean predicateEnabled;
    private Project project;
    private Rectangle2D.Float rect = new Rectangle2D.Float();

    @Override
    public ElementPainter copy() {
        DefaultElementPainter painter = new DefaultElementPainter();
        painter.project = this.project;
        painter.colorScheme = this.colorScheme.copy();
        painter.colorScheme.setProject(this.project);
        return painter;
    }

    @Override
    public void draw(Graphics2D g, Dataset dataset, int row, int column, float xpix, float ypix, float columnSize, float rowSize) {
        g.setColor(this.colorScheme.getColor(row, column, dataset.getValue(row, column)));
        if (!this.predicateEnabled) {
            this.rect.setRect(xpix, ypix, columnSize, rowSize);
            g.fill(this.rect);
        } else {
            boolean found = false;
            Collection<Condition> predicates = this.colorScheme.getConditions(row, column);
            if (predicates.size() > 0) {
                found = true;
                Shape shape = null;
                Color fillColor = null;
                Color borderColor = null;
                Stroke borderStroke = null;
                int mark = -1;
                Color markColor = null;
                for (Condition p : predicates) {
                    if (p.mark != -1) {
                        mark = p.mark;
                        markColor = p.markColor;
                    }
                    if (p.shape != null) {
                        shape = p.shape;
                    }
                    if (p.fillColor != null) {
                        fillColor = p.fillColor;
                    }
                    if (p.borderColor != null) {
                        borderColor = p.borderColor;
                    }
                    if (p.borderStroke == null) continue;
                    borderStroke = p.borderStroke;
                }
                if (fillColor == null) {
                    fillColor = this.colorScheme.getColor(row, column, dataset.getValue(row, column));
                }
                if (shape == null) {
                    shape = ShapeUtil.getShape(1, 12.0f);
                }
                AffineTransform transform = AffineTransform.getTranslateInstance(xpix, ypix);
                Rectangle2D bounds = shape.getBounds2D();
                transform.concatenate(AffineTransform.getScaleInstance((double)columnSize / bounds.getWidth(), (double)rowSize / bounds.getHeight()));
                Shape fillShape = transform.createTransformedShape(shape);
                g.setColor(fillColor);
                g.fill(fillShape);
                if (mark != -1) {
                    if (mark == Condition.MARK_LINE) {
                        g.setColor(markColor != null ? markColor : Color.GRAY);
                        Line2D.Float line = new Line2D.Float(xpix, ypix + 1.0f, xpix + columnSize, ypix + rowSize - 1.0f);
                        g.draw(line);
                    } else if (mark == Condition.MARK_CIRCLE) {
                        g.setColor(markColor != null ? markColor : Color.WHITE);
                        float width = 6.0f;
                        if (columnSize < width) {
                            width = columnSize;
                        }
                        if (rowSize < width) {
                            width = columnSize;
                        }
                        Ellipse2D.Float line = new Ellipse2D.Float(xpix + columnSize / 2.0f - width / 2.0f, ypix + rowSize / 2.0f - width / 2.0f, width, width);
                        g.fill(line);
                    }
                }
                if (borderColor != null) {
                    Stroke stroke = g.getStroke();
                    float lineWidth = 0.0f;
                    if (borderStroke != null) {
                        if (borderStroke instanceof BasicStroke) {
                            lineWidth = ((BasicStroke)borderStroke).getLineWidth();
                        }
                        g.setStroke(borderStroke);
                    }
                    g.setColor(borderColor);
                    transform = AffineTransform.getTranslateInstance(xpix + lineWidth / 2.0f, ypix + lineWidth / 2.0f);
                    transform.concatenate(AffineTransform.getScaleInstance((double)(columnSize -= lineWidth) / bounds.getWidth(), (double)(rowSize -= lineWidth) / bounds.getHeight()));
                    Shape drawShape = transform.createTransformedShape(shape);
                    g.draw(drawShape);
                    g.setStroke(stroke);
                }
            }
            if (!found) {
                this.rect.setRect(xpix, ypix, columnSize, rowSize);
                g.fill(this.rect);
            }
        }
    }

    @Override
    public boolean setColorScheme(HeatMapColorScheme colorScheme) {
        this.colorScheme = colorScheme;
        colorScheme.setProject(this.project);
        this.predicateEnabled = colorScheme.containsConditions();
        return true;
    }

    @Override
    public void setProject(Project project) {
        this.project = project;
    }

    public static class Condition {
        public static int MARK_CIRCLE = 0;
        public static int MARK_LINE = 1;
        private Color borderColor;
        private Stroke borderStroke;
        private Dataset dataset;
        private String datasetName;
        private boolean enabled = false;
        private Color fillColor;
        private int mark = -1;
        private Color markColor;
        private FloatFilter predicate;
        private Shape shape;
        private int shapeIndex = -1;

        public Condition(FloatFilter predicate, Shape shape, int shapeIndex, String datasetName) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            this.predicate = predicate;
            this.shape = shape;
            this.shapeIndex = shapeIndex;
            this.datasetName = datasetName;
        }

        public boolean apply(int row, int column) {
            return this.predicate.apply(this.dataset.getValue(row, column));
        }

        public Condition copy() {
            Condition copy = new Condition(this.predicate instanceof BetweenFloatFilter ? ((BetweenFloatFilter)this.predicate).copy() : new BetweenFloatFilter(), this.shapeIndex == -1 ? null : ShapeUtil.getShape(this.shapeIndex, 12.0f), this.shapeIndex, this.datasetName);
            copy.shapeIndex = this.shapeIndex;
            copy.datasetName = this.datasetName;
            copy.borderColor = this.borderColor;
            copy.borderStroke = this.borderStroke;
            copy.enabled = this.enabled;
            copy.fillColor = this.fillColor;
            copy.mark = this.mark;
            copy.markColor = this.markColor;
            return copy;
        }

        public Color getBorderColor() {
            return this.borderColor;
        }

        public Stroke getBorderStroke() {
            return this.borderStroke;
        }

        public String getDatasetName() {
            return this.datasetName;
        }

        public Color getFillColor() {
            return this.fillColor;
        }

        public int getMark() {
            return this.mark;
        }

        public Color getMarkColor() {
            return this.markColor;
        }

        public FloatFilter getPredicate() {
            return this.predicate;
        }

        public int getShapeIndex() {
            return this.shapeIndex;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setBorderColor(Color borderColor) {
            this.borderColor = borderColor;
        }

        public void setBorderStroke(Stroke borderStroke) {
            this.borderStroke = borderStroke;
        }

        public void setDataset(Dataset dataset) {
            if (dataset == null) {
                throw new NullPointerException();
            }
            this.dataset = dataset;
        }

        public void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setFillColor(Color fillColor) {
            this.fillColor = fillColor;
        }

        public void setMark(int mark) {
            this.mark = mark;
        }

        public void setMarkColor(Color color) {
            this.markColor = color;
        }

        public void setPredicate(FloatFilter predicate) {
            this.predicate = predicate;
        }

        public void setShape(Shape shape, int shapeIndex) {
            this.shape = shape;
            this.shapeIndex = shapeIndex;
        }
    }
}

