/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.EventListenerList;
import org.broadinstitute.genee.application.UniqueEventListenerList;
import org.broadinstitute.genee.category.DefaultVectorColorModel;
import org.broadinstitute.genee.category.VectorColorModel;
import org.broadinstitute.genee.clustering.hierarchical.Dendrogram;
import org.broadinstitute.genee.clustering.hierarchical.Node;
import org.broadinstitute.genee.filter.Filter;
import org.broadinstitute.genee.heatmap.AbstractSelectionModel;
import org.broadinstitute.genee.heatmap.ColumnSelectionModel;
import org.broadinstitute.genee.heatmap.DefaultElementSelectionModel;
import org.broadinstitute.genee.heatmap.ElementSelectionModel;
import org.broadinstitute.genee.heatmap.FilterEvent;
import org.broadinstitute.genee.heatmap.FilterListener;
import org.broadinstitute.genee.heatmap.IndexMapper;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.ProjectEvent;
import org.broadinstitute.genee.heatmap.ProjectListener;
import org.broadinstitute.genee.heatmap.ProjectSortKey;
import org.broadinstitute.genee.heatmap.RowSelectionModel;
import org.broadinstitute.genee.heatmap.SelectionModel;
import org.broadinstitute.genee.matrix.CombinedRowsDatasetView;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataModelAsDatasetView;
import org.broadinstitute.genee.matrix.MetadataModelColumnView;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.table.ColumnSorter;
import org.broadinstitute.genee.table.RowSorter;

public class DefaultProject
implements Project {
    private static int instanceCounter = 0;
    private VectorColorModel columnCategoryColorModel;
    private Dendrogram columnDendrogram;
    private ProjectSortKey[] columnGroupBy = new ProjectSortKey[0];
    private Comparator<String> columnIdComparator = String.CASE_INSENSITIVE_ORDER;
    private IndexMapper columnIndexMapper;
    private Dataset dataset;
    private ElementSelectionModel elementSelectionModel = new DefaultElementSelectionModel();
    private List<Node> highlightedColumnDendrogramNodes;
    private List<Node> highlightedRowDendrogramNodes;
    private String id;
    private EventListenerList listenerList = new UniqueEventListenerList();
    private VectorColorModel rowCategoryColorModel;
    private Dendrogram rowDendrogram;
    private ProjectSortKey[] rowGroupBy = new ProjectSortKey[0];
    private Comparator<String> rowIdComparator = String.CASE_INSENSITIVE_ORDER;
    private IndexMapper rowIndexMapper;
    private DefaultListSelectionModel viewRowCategoriesSelectionModel = new DefaultListSelectionModel();

    public DefaultProject() {
        this(null, null, null, null);
    }

    public DefaultProject(Dataset dataset) {
        this(dataset, null);
    }

    public DefaultProject(Dataset dataset, Dendrogram rowDendrogram, Dendrogram columnDendrogram, Project parentProject) {
        this(dataset, rowDendrogram, columnDendrogram, parentProject, null, null);
    }

    public DefaultProject(Dataset dataset, Dendrogram rowDendrogram, Dendrogram columnDendrogram, VectorColorModel rowCategoryColorModel, VectorColorModel columnCategoryColorModel) {
        this(dataset, rowDendrogram, columnDendrogram, null, rowCategoryColorModel, columnCategoryColorModel);
    }

    public DefaultProject(Dataset dataset, Project parentProject) {
        this(dataset, null, null, parentProject);
    }

    public DefaultProject(Project parentProject) {
        this(null, parentProject);
    }

    private DefaultProject(Dataset dataset, Dendrogram rowDendrogram, Dendrogram columnDendrogram, Project parentProject, VectorColorModel rowCategoryColorModel, VectorColorModel columnCategoryColorModel) {
        this.id = String.valueOf(instanceCounter++);
        if (rowDendrogram != null) {
            this.rowDendrogram = rowDendrogram;
        }
        if (columnDendrogram != null) {
            this.columnDendrogram = columnDendrogram;
        }
        if (dataset != null) {
            this.dataset = dataset;
        }
        this.rowIndexMapper = new IndexMapper(this, new RowSorter(), this.createRowSelectionModel(), this.createViewRowMask(), true, new FilterListener(){

            @Override
            public void filterChanged(FilterEvent e) {
                ProjectEvent evt = new ProjectEvent(DefaultProject.this, 7);
                DefaultProject.this.rowIndexMapper.updateMappings();
                DefaultProject.this.fireProjectChanged(evt);
            }
        });
        this.columnIndexMapper = new IndexMapper(this, new ColumnSorter(), this.createColumnSelectionModel(), this.createViewColumnMask(), false, new FilterListener(){

            @Override
            public void filterChanged(FilterEvent e) {
                ProjectEvent evt = new ProjectEvent(DefaultProject.this, 13);
                DefaultProject.this.columnIndexMapper.updateMappings();
                DefaultProject.this.fireProjectChanged(evt);
            }
        });
        if (parentProject != null) {
            this.setParentProject(parentProject);
        } else {
            this.rowCategoryColorModel = rowCategoryColorModel == null ? new DefaultVectorColorModel() : rowCategoryColorModel;
            this.columnCategoryColorModel = columnCategoryColorModel == null ? new DefaultVectorColorModel() : columnCategoryColorModel;
        }
    }

    @Override
    public void addProjectListener(ProjectListener l) {
        this.listenerList.add(ProjectListener.class, l);
    }

    @Override
    public void addToColumnMask(int[] viewIndices) {
        this.columnIndexMapper.addToMask(viewIndices);
        this.fireProjectChanged(new ProjectEvent(this, 12));
    }

    @Override
    public void addToRowMask(int[] viewIndices) {
        this.rowIndexMapper.addToMask(viewIndices);
        this.fireProjectChanged(new ProjectEvent(this, 1));
    }

    @Override
    public void clearColumnMask() {
        this.columnIndexMapper.clearMask();
        this.fireProjectChanged(new ProjectEvent(this, 12));
    }

    @Override
    public void clearRowMask() {
        this.rowIndexMapper.clearMask();
        this.fireProjectChanged(new ProjectEvent(this, 1));
    }

    @Override
    public int convertModelColumnIndexToView(int modelColumnIndex) {
        return this.columnIndexMapper.convertModelIndexToView(modelColumnIndex);
    }

    @Override
    public int convertModelRowIndexToView(int modelRowIndex) {
        return this.rowIndexMapper.convertModelIndexToView(modelRowIndex);
    }

    @Override
    public int convertViewColumnIndexToModel(int viewIndex) {
        return this.columnIndexMapper.convertViewIndexToModel(viewIndex);
    }

    @Override
    public int convertViewRowIndexToModel(int viewIndex) {
        return this.rowIndexMapper.convertViewIndexToModel(viewIndex);
    }

    @Override
    public void fireColumnMetadataChanged() {
        this.updateColumnMetadataInDataset();
        this.fireProjectChanged(new ProjectEvent(this, 6));
    }

    @Override
    public void fireRowMetadataChanged() {
        this.fireProjectChanged(new ProjectEvent(this, 5));
    }

    @Override
    public VectorColorModel getColumnColorModel() {
        return this.columnCategoryColorModel;
    }

    @Override
    public Dendrogram getColumnDendrogram() {
        return this.columnDendrogram;
    }

    @Override
    public ProjectSortKey[] getColumnGroupBy() {
        return this.columnGroupBy;
    }

    public Comparator<String> getColumnIdComparator() {
        return this.columnIdComparator;
    }

    @Override
    public SelectionModel getColumnSelectionModel() {
        return this.columnIndexMapper.getSelectionModel();
    }

    @Override
    public List<? extends ProjectSortKey> getColumnSortKeys() {
        return this.columnIndexMapper.getSortKeys();
    }

    @Override
    public int[] getColumnSortOrder() {
        return this.columnIndexMapper.getSortOrder();
    }

    @Override
    public ElementSelectionModel getElementSelectionModel() {
        return this.elementSelectionModel;
    }

    @Override
    public List<Node> getHighlightedColumnDendrogramNodes() {
        return this.highlightedColumnDendrogramNodes;
    }

    @Override
    public List<Node> getHighlightedRowDendrogramNodes() {
        return this.highlightedRowDendrogramNodes;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int[] getModelColumnIndices(boolean selectionOnly, boolean removeMasked) {
        return this.columnIndexMapper.convertToView(selectionOnly, removeMasked);
    }

    @Override
    public int[] getModelRowIndices(boolean selectionOnly, boolean removeMasked) {
        return this.rowIndexMapper.convertToView(selectionOnly, removeMasked);
    }

    @Override
    public Dataset getOriginalDataset() {
        return this.dataset;
    }

    @Override
    public VectorColorModel getRowColorModel() {
        return this.rowCategoryColorModel;
    }

    @Override
    public Dendrogram getRowDendrogram() {
        return this.rowDendrogram;
    }

    @Override
    public Filter getRowFilter() {
        return this.rowIndexMapper.getFilter();
    }

    @Override
    public ProjectSortKey[] getRowGroupBy() {
        return this.rowGroupBy;
    }

    public Comparator<String> getRowIdComparator() {
        return this.rowIdComparator;
    }

    @Override
    public SelectionModel getRowSelectionModel() {
        return this.rowIndexMapper.getSelectionModel();
    }

    @Override
    public List<? extends ProjectSortKey> getRowSortKeys() {
        return this.rowIndexMapper.getSortKeys();
    }

    @Override
    public int[] getRowSortOrder() {
        return this.rowIndexMapper.getSortOrder();
    }

    @Override
    public Dataset getSortedFilteredDataset() {
        return DatasetUtil.sliceView(this.getOriginalDataset(), this.rowIndexMapper.convertToView(false, false), this.columnIndexMapper.convertToView(false, false));
    }

    @Override
    public int getViewColumnCount() {
        return this.getOriginalDataset() == null ? 0 : this.getSortedFilteredDataset().getColumnCount();
    }

    @Override
    public TIntHashSet getViewColumnMask() {
        return this.columnIndexMapper.getViewMask();
    }

    @Override
    public ListSelectionModel getViewRowCategoriesSelectionModel() {
        return this.viewRowCategoriesSelectionModel;
    }

    @Override
    public int getViewRowCount() {
        return this.rowIndexMapper.getViewCount();
    }

    @Override
    public TIntHashSet getViewRowMask() {
        return this.rowIndexMapper.getViewMask();
    }

    @Override
    public boolean isColumnSortOrderPreservesDendrogram() {
        return this.columnIndexMapper.isSortOrderPreservesDendrogram();
    }

    @Override
    public boolean isRowSortOrderPreservesDendrogram() {
        return this.rowIndexMapper.isSortOrderPreservesDendrogram();
    }

    @Override
    public void removeFromColumnMask(int[] viewIndices) {
        this.columnIndexMapper.removeFromMask(viewIndices);
        this.fireProjectChanged(new ProjectEvent(this, 12));
    }

    @Override
    public void removeFromRowMask(int[] viewIndices) {
        this.rowIndexMapper.removeFromMask(viewIndices);
        this.fireProjectChanged(new ProjectEvent(this, 1));
    }

    @Override
    public void removeProjectListener(ProjectListener l) {
        this.listenerList.remove(ProjectListener.class, l);
    }

    public void setColumnColorModel(VectorColorModel columnCategoryColorModel) {
        this.columnCategoryColorModel = columnCategoryColorModel;
    }

    @Override
    public void setColumnDendrogram(Dendrogram columnDendrogram) {
        this.columnDendrogram = columnDendrogram;
        this.fireProjectChanged(new ProjectEvent(this, 10));
    }

    @Override
    public void setColumnFilter(Filter filter) {
        this.columnIndexMapper.setFilter(filter);
    }

    @Override
    public void setColumnGroupBy(ProjectSortKey[] columnGroupBy) {
        if (columnGroupBy == null) {
            columnGroupBy = new ProjectSortKey[]{};
        }
        if (!Arrays.equals(columnGroupBy, this.columnGroupBy)) {
            this.columnGroupBy = columnGroupBy;
            this.fireProjectChanged(new ProjectEvent(this, 0));
        }
    }

    public void setColumnIdComparator(Comparator<String> columnIdComparator) {
        this.columnIdComparator = columnIdComparator;
    }

    @Override
    public void setColumnSortOrder(List<? extends ProjectSortKey> sortKeys) {
        this.columnIndexMapper.setSortOrder(sortKeys);
        this.fireProjectChanged(new ProjectEvent(this, 0));
    }

    @Override
    public void setDataset(Dataset dataset) {
        if (this.dataset != null) {
            dataset.setProperty("project.node", this.dataset.getProperty("project.node"));
        }
        this.dataset = dataset;
        this.rowIndexMapper.clearMask();
        this.columnIndexMapper.clearMask();
        this.getColumnSelectionModel().setSelectedModelIndices(new int[0]);
        this.getRowSelectionModel().setSelectedModelIndices(new int[0]);
        this.columnIndexMapper.setSortOrder(this.getColumnSortKeys());
        this.rowIndexMapper.setSortOrder(this.getRowSortKeys());
        this.fireProjectChanged(new ProjectEvent(this, 8));
        this.fireProjectChanged(new ProjectEvent(this, 0));
    }

    @Override
    public void setHighlightedColumnDendrogramNodes(List<Node> nodes) {
        this.highlightedColumnDendrogramNodes = nodes;
        this.fireProjectChanged(new ProjectEvent(this, 10));
    }

    @Override
    public void setHighlightedRowDendrogramNodes(List<Node> nodes) {
        this.highlightedRowDendrogramNodes = nodes;
        this.fireProjectChanged(new ProjectEvent(this, 11));
    }

    public void setParentProject(Project parentProject) {
        if (parentProject == null) {
            throw new NullPointerException();
        }
        this.rowCategoryColorModel = DefaultVectorColorModel.copy(parentProject.getOriginalDataset().getRowMetadata(), parentProject.getRowColorModel());
        this.columnCategoryColorModel = DefaultVectorColorModel.copy(parentProject.getOriginalDataset().getColumnMetadata(), parentProject.getColumnColorModel());
        Dataset dataset = this.getSortedFilteredDataset();
        if (this.columnDendrogram == null && parentProject != null && parentProject.getColumnDendrogram() != null && parentProject.getViewColumnCount() == dataset.getColumnCount() && parentProject.isColumnSortOrderPreservesDendrogram()) {
            this.columnDendrogram = parentProject.getColumnDendrogram();
        }
        if (this.rowDendrogram == null && parentProject != null && parentProject.getRowDendrogram() != null && parentProject.isRowSortOrderPreservesDendrogram() && parentProject.getViewRowCount() == dataset.getRowCount()) {
            this.rowDendrogram = parentProject.getRowDendrogram();
        }
    }

    public void setRowCategoryColorModel(VectorColorModel rowCategoryColorModel) {
        this.rowCategoryColorModel = rowCategoryColorModel;
    }

    @Override
    public void setRowDendrogram(Dendrogram rowDendrogram) {
        this.rowDendrogram = rowDendrogram;
    }

    @Override
    public void setRowFilter(Filter filter) {
        this.rowIndexMapper.setFilter(filter);
    }

    @Override
    public void setRowGroupBy(ProjectSortKey[] rowGroupBy) {
        if (rowGroupBy == null) {
            rowGroupBy = new ProjectSortKey[]{};
        }
        if (!Arrays.equals(rowGroupBy, this.rowGroupBy)) {
            this.rowGroupBy = rowGroupBy;
            this.fireProjectChanged(new ProjectEvent(this, 8));
        }
    }

    public void setRowIdComparator(Comparator<String> rowIdComparator) {
        this.rowIdComparator = rowIdComparator;
    }

    @Override
    public void setRowSortOrder(List<? extends ProjectSortKey> sortKeys) {
        this.rowIndexMapper.setSortOrder(sortKeys);
        this.fireProjectChanged(new ProjectEvent(this, 8));
    }

    @Override
    public void setSelectedModelColumnIndices(int[] selectedModelIndices) {
        this.columnIndexMapper.setSelectedModelIndices(selectedModelIndices);
    }

    @Override
    public void setSelectedModelRowIndices(int[] selectedModelIndices) {
        this.rowIndexMapper.setSelectedModelIndices(selectedModelIndices);
    }

    public String toString() {
        return this.getOriginalDataset() != null ? this.getOriginalDataset().getName() : "";
    }

    protected AbstractSelectionModel createColumnSelectionModel() {
        return new ColumnSelectionModel(this);
    }

    protected AbstractSelectionModel createRowSelectionModel() {
        return new RowSelectionModel(this);
    }

    protected TIntHashSet createViewColumnMask() {
        return new TIntHashSet();
    }

    protected TIntHashSet createViewRowMask() {
        return new TIntHashSet();
    }

    private void fireProjectChanged(ProjectEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ProjectListener.class) continue;
            ((ProjectListener)listeners[i + 1]).projectChanged(e);
        }
    }

    private void updateColumnMetadataInDataset() {
        Dataset original = this.getOriginalDataset();
        if (original instanceof CombinedRowsDatasetView) {
            original = ((CombinedRowsDatasetView)original).getPrimaryDataset();
        }
        TIntArrayList indices = new TIntArrayList();
        MetadataModel model = original.getColumnMetadata();
        int n = model.getMetadataCount();
        for (int i = 0; i < n; ++i) {
            Vector v = model.get(i);
            Object value = v.getProperty("In Dataset");
            if (!Boolean.TRUE.equals(value)) continue;
            indices.add(i);
        }
        if (indices.size() > 0) {
            this.setDataset(new CombinedRowsDatasetView(original, new MetadataModelAsDatasetView(new MetadataModelColumnView(model, indices.toArray()), original.getRowMetadata())));
        } else {
            this.setDataset(original);
        }
    }
}

