/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.google.common.base.Function;
import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEFolderNode;
import org.broadinstitute.genee.application.History;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.application.UserUtil;
import org.broadinstitute.genee.gui.BackgroundTask;
import org.broadinstitute.genee.gui.actions.AnnotateAction;
import org.broadinstitute.genee.heatmap.HeatMapColorScheme;
import org.broadinstitute.genee.heatmap.HeatMapColorSchemeOptionsPanel;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.excel.AddToMetadataContentHandler;
import org.broadinstitute.genee.io.excel.ExcelReader;
import org.broadinstitute.genee.io.matrix.cls.ClsReader;
import org.broadinstitute.genee.io.util.ArchiveUtil;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ProjectIO;
import org.broadinstitute.genee.io.util.TrackerUtil;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DefaultClassVector;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.VectorUtil;

public class ExampleDatasetsMenu
extends JMenu {
    public ExampleDatasetsMenu() {
        super("Open Example Data");
        AbstractAction golub1999 = new AbstractAction("Golub, Slonim et al. [Science 1999]"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExampleDatasetsMenu.this.openFromFtpSite("Golub, Slonim et al. Science 1999.zip");
            }
        };
        AbstractAction luo2008 = new AbstractAction("Luo, Cheung, Subramanian et al. [PNAS 2008]"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExampleDatasetsMenu.this.openFromFtpSite("Luo, Cheung, Subramanian et al. PNAS 2008.zip");
            }
        };
        if (UserUtil.isBroadUser()) {
            this.add(new AbstractAction("Project Achilles ATARiS Scores"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExampleDatasetsMenu.openFromHttpSite("Achilles ATARiS Scores", "https://software.broadinstitute.org/GENE-E/datasets/Achilles_QC_v2.4.rnai.Gs.gctx");
                }
            });
        }
        this.add(new AbstractAction("ASG001 PC3 24H (LINCS)"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExampleDatasetsMenu.openFromHttpSite("ASG001 PC3 24H (LINCS)", "https://software.broadinstitute.org/GENE-E/datasets/ASG001_PC3_24H_X2_B7_DUO52HI53LO_INF_mlr12k_n378x22268.gctx");
            }
        });
        this.add(new AbstractAction("CCLE"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExampleDatasetsMenu.openFromHttpSite("CCLE Expression", "https://software.broadinstitute.org/GENE-E/datasets/CCLE_Expression.gct.gz", new Function<Project, Void>(){

                    public Void apply(Project p) {
                        MetadataModel model = p.getOriginalDataset().getColumnMetadata();
                        int count = model.getMetadataCount();
                        for (int i = 0; i < count; ++i) {
                            model.get(i).removeProperty("Color Visible");
                        }
                        model.get("Site Primary").setProperty("Color Visible", true);
                        return null;
                    }
                }, new Function<ProjectGENEEResultTreeNode, Void>(){

                    public Void apply(ProjectGENEEResultTreeNode n) {
                        return null;
                    }
                });
                ExampleDatasetsMenu.openFromHttpSite("CCLE CN", "https://software.broadinstitute.org/GENE-E/datasets/CCLE_copynumber_byGene.gct.gz", new Function<Project, Void>(){

                    public Void apply(Project p) {
                        MetadataModel model = p.getOriginalDataset().getColumnMetadata();
                        int count = model.getMetadataCount();
                        for (int i = 0; i < count; ++i) {
                            model.get(i).removeProperty("Color Visible");
                        }
                        model.get("Site Primary").setProperty("Color Visible", true);
                        return null;
                    }
                }, new Function<ProjectGENEEResultTreeNode, Void>(){

                    public Void apply(ProjectGENEEResultTreeNode n) {
                        HeatMapPanel heatMap = (HeatMapPanel)n.getDisplayInfo().getComponent();
                        HeatMapColorScheme cs = heatMap.getColorScheme();
                        HeatMapColorSchemeOptionsPanel.loadPredefinedColorScheme(cs, "cn");
                        return null;
                    }
                });
            }
        });
        this.add(golub1999);
        this.add(luo2008);
    }

    private static void configureCCLE(ProjectGENEEResultTreeNode node) {
    }

    public static void openFromHttpSite(String name, String url) {
        ExampleDatasetsMenu.openFromHttpSite(name, url, null, null);
    }

    public static void openFromHttpSite(final String name, final String url, final Function<Project, Void> projectCallback, final Function<ProjectGENEEResultTreeNode, Void> nodeCallback) {
        TrackerUtil.trackPageView(name);
        new BackgroundTask<ProjectGENEEResultTreeNode>(name){

            @Override
            protected void succeeded(ProjectGENEEResultTreeNode node) {
                Application.add(new GENEEFolderNode("Example Dataset", node.getAuditTrail().last(), node));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected ProjectGENEEResultTreeNode doInBackground() throws Exception {
                File tmpFile = null;
                try {
                    if (url.endsWith(".gctx") && IOUtil.download(url, tmpFile = File.createTempFile("tmpFile", ".gctx"))) {
                        throw new RuntimeException("Unable to download file");
                    }
                    Project project = ProjectIO.readProject(tmpFile != null ? tmpFile.getCanonicalPath() : url);
                    project.getOriginalDataset().setName(name);
                    if (projectCallback != null) {
                        projectCallback.apply((Object)project);
                    }
                    ProjectGENEEResultTreeNode node = new ProjectGENEEResultTreeNode(project, new History("Opened " + name));
                    if (nodeCallback != null) {
                        nodeCallback.apply((Object)node);
                    }
                    ProjectGENEEResultTreeNode projectGENEEResultTreeNode = node;
                    return projectGENEEResultTreeNode;
                }
                finally {
                    if (tmpFile != null) {
                        tmpFile.delete();
                    }
                }
            }
        }.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProjectGENEEResultTreeNode createNodeFromArchive(String nodeName, String archiveFile) throws IOException {
        File extractToDir = null;
        File tmpArchiveFile = null;
        try {
            ProjectGENEEResultTreeNode node;
            if (!new File(archiveFile).exists()) {
                String archiveName = archiveFile.toLowerCase();
                String extension = ".zip";
                if (archiveName.endsWith(".tar.gz") || archiveName.endsWith(".tgz")) {
                    extension = ".tgz";
                } else if (archiveName.endsWith(".tar.bz2")) {
                    extension = ".tar.bz2";
                }
                tmpArchiveFile = File.createTempFile("archive", extension);
                IOUtil.download(archiveFile, tmpArchiveFile);
                archiveFile = IOUtil.getPath(tmpArchiveFile);
            }
            extractToDir = File.createTempFile("dir", ".tmp");
            extractToDir.delete();
            extractToDir.mkdir();
            ArchiveUtil.extract(new File(archiveFile), extractToDir);
            Project project = null;
            File[] files = new File[]{};
            try {
                files = IOUtil.listFiles(extractToDir, null, null, null, true);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            for (File f : files) {
                String name = f.getName().toLowerCase();
                if (!name.endsWith(".gct") && !name.endsWith(".gctx")) continue;
                Project tmp = ProjectIO.readProject(f.getCanonicalPath(), false);
                if (tmp != null) {
                    project = tmp;
                }
                f.delete();
            }
            if (project == null) {
                throw new RuntimeException("No dataset found");
            }
            Dataset dataset = project.getOriginalDataset();
            for (File f : files) {
                String filename = f.getName().toLowerCase();
                if (filename.endsWith(".cls")) {
                    DefaultClassVector cls = new ClsReader().read(IOUtil.getPath(f));
                    AnnotateAction.loadClassVector(dataset.getColumnMetadata(), cls);
                } else if (filename.endsWith(".chip")) {
                    new ExcelReader(f.getCanonicalPath(), new AddToMetadataContentHandler(dataset.getRowMetadata(), project.getRowColorModel(), null, VectorUtil.createStringValueToIndicesMap(dataset.getRowMetadata().get(0)), true));
                } else if (filename.endsWith(".xls") || filename.endsWith(".xlsx") || filename.endsWith(".csv")) {
                    new ExcelReader(f.getCanonicalPath(), new AddToMetadataContentHandler(dataset.getColumnMetadata(), project.getColumnColorModel(), null, VectorUtil.createStringValueToIndicesMap(dataset.getColumnMetadata().get(0)), false));
                }
                f.delete();
            }
            ProjectGENEEResultTreeNode projectGENEEResultTreeNode = node = new ProjectGENEEResultTreeNode(project, new History("Opened " + nodeName));
            return projectGENEEResultTreeNode;
        }
        finally {
            extractToDir.delete();
            if (tmpArchiveFile != null) {
                tmpArchiveFile.delete();
            }
        }
    }

    public void openFromFtpSite(final String zipFileName) {
        String name = IOUtil.getBaseFileName(zipFileName);
        TrackerUtil.trackPageView(name);
        new BackgroundTask<ProjectGENEEResultTreeNode>(name){

            @Override
            protected void succeeded(ProjectGENEEResultTreeNode node) {
                Application.add(new GENEEFolderNode("Example Dataset", node.getAuditTrail().last(), node));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected ProjectGENEEResultTreeNode doInBackground() throws Exception {
                File tmpFile = null;
                try {
                    tmpFile = ExampleDatasetsMenu.downloadZipFromFtpSite(zipFileName);
                    ProjectGENEEResultTreeNode projectGENEEResultTreeNode = ExampleDatasetsMenu.createNodeFromArchive(zipFileName, IOUtil.getPath(tmpFile));
                    return projectGENEEResultTreeNode;
                }
                finally {
                    if (tmpFile != null) {
                        tmpFile.delete();
                    }
                }
            }
        }.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File downloadZipFromFtpSite(String filename) {
        FTPClient ftp = null;
        try {
            ftp = new FTPClient();
            ftp.setRemoteHost("gseaftp.broadinstitute.org");
            ftp.connect();
            ftp.login("gs3as3cr3tz", "asdf7hEGw");
            ftp.setType(FTPTransferType.BINARY);
            ftp.chdir("/pub/GENE-E/");
            File file = File.createTempFile("tmp", ".zip");
            try (FilterOutputStream bos = null;){
                bos = new BufferedOutputStream(new FileOutputStream(file));
                ftp.get((OutputStream)bos, filename);
            }
            File file2 = file;
            return file2;
        }
        catch (Exception x) {
            x.printStackTrace();
            throw new RuntimeException("Unable to connect to FTP server.");
        }
        finally {
            try {
                ftp.quit();
            }
            catch (Exception e) {}
        }
    }
}

