/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.genee.heatmap.FilePlateWellValue;
import org.broadinstitute.genee.heatmap.ToolTipSupplier;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.matrix.FloatList;

public class FilePlateWellValueList
implements ToolTipSupplier,
FloatList {
    private List<FilePlateWellValue> list = new ArrayList<FilePlateWellValue>();

    public void add(FilePlateWellValue filePlateWellValue) {
        this.list.add(filePlateWellValue);
    }

    @Override
    public float getValue(int index) {
        return this.list.get(index).getValue();
    }

    @Override
    public Map<String, String> getToolTipText() {
        LinkedHashMap<String, String> tip = new LinkedHashMap<String, String>();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            FilePlateWellValue val = this.list.get(i);
            String file = new File(val.getFile()).getName();
            tip.put(file + " " + val.getPlate() + " " + val.getWell(), Formatter.format(val.getValue()));
        }
        return tip;
    }

    @Override
    public void setValue(int index, float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.list.size();
    }
}

