/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import org.broadinstitute.genee.chart.action.BoxPlotAction;
import org.broadinstitute.genee.chart.action.HistogramAction;
import org.broadinstitute.genee.chart.action.ProfileAction;
import org.broadinstitute.genee.cmap.rankedlist.RankedListAction;
import org.broadinstitute.genee.filter.FilterRowsAction;
import org.broadinstitute.genee.gui.IconManager;
import org.broadinstitute.genee.gui.MetadataEditor;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.ZoomInAction;
import org.broadinstitute.genee.gui.ZoomOutAction;
import org.broadinstitute.genee.gui.actions.ColumnDistanceMatrixAction;
import org.broadinstitute.genee.gui.actions.DistanceMatrixAction;
import org.broadinstitute.genee.gui.actions.HierarchicalClusteringAction;
import org.broadinstitute.genee.gui.actions.MarkerSelectionAction;
import org.broadinstitute.genee.gui.actions.NewHeatMapAction;
import org.broadinstitute.genee.gui.actions.RowDistanceMatrixAction;
import org.broadinstitute.genee.gui.actions.SaveDatasetAction;
import org.broadinstitute.genee.heatmap.DatasetTableAction;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.PreferencesAction;
import org.broadinstitute.genee.heatmap.SortColumnsDialog;
import org.broadinstitute.genee.heatmap.menu.AboutAction;
import org.broadinstitute.genee.heatmap.menu.SaveImageAction;
import org.broadinstitute.genee.heatmap.menu.preprocess.MaskAction;
import org.broadinstitute.genee.heatmap.menu.preprocess.ResetMaskAction;
import org.broadinstitute.genee.heatmap.menu.preprocess.UnMaskAction;
import org.broadinstitute.genee.io.util.TrackerUtil;
import org.broadinstitute.genee.math.stat.function.CoefficientOfVariation;
import org.broadinstitute.genee.math.stat.function.FloatListFunction;
import org.broadinstitute.genee.math.stat.function.Max;
import org.broadinstitute.genee.math.stat.function.MaxDividedByMin;
import org.broadinstitute.genee.math.stat.function.MaxMinusMin;
import org.broadinstitute.genee.math.stat.function.Mean;
import org.broadinstitute.genee.math.stat.function.Median;
import org.broadinstitute.genee.math.stat.function.MedianAbsoluteDeviation;
import org.broadinstitute.genee.math.stat.function.Stdev;
import org.broadinstitute.genee.table.CopyTableAction;
import org.broadinstitute.genee.table.SortRowsDialog;

public class HeatMapEditorKit {
    private static List<FloatListFunction> DEFAULT_FUNCTIONS = new ArrayList<FloatListFunction>();
    private static Map<String, FloatListFunction> nameToFunction;
    private DistanceMatrixAction columnCorrelationMatrixAction;
    private ProfileAction columnProfileAction;
    private CopyTableAction copyAction;
    private AbstractAction cutColumnDendrogramAction;
    private AbstractAction cutRowDendrogramAction;
    private Action datasetTableViewAction;
    private Action hierarchicalClusteringAction;
    private MaskAction maskColumnsAction;
    private MaskAction maskRowsAction;
    private NewHeatMapAction newHeatMapAction;
    private ResetMaskAction resetMaskColumnsAction;
    private ResetMaskAction resetMaskRowsAction;
    private DistanceMatrixAction rowCorrelationMatrixAction;
    private HistogramAction histogramAction = new HistogramAction();
    private Action rowProfileAction;
    private AbstractAction sortColumnsAction;
    private AbstractAction sortRowsAction;
    private UnMaskAction unMaskColumnsAction;
    private UnMaskAction unMaskRowsAction;
    private PreferencesAction preferencesAction;
    private ZoomInAction zoomInAction;
    private ZoomOutAction zoomOutAction;
    private Action markerSelectionAction;
    private Action boxPlotAction;
    private Action editColumnAnnotationsAction;
    private Action editRowAnnotationsAction;
    private FilterRowsAction filterRowsAction;
    private Action aboutAction;
    private Action rankedListAction;
    private AbstractAction rowDendrogramBranchColorAction;
    private AbstractAction columnDendrogramBranchColorAction;
    private SaveImageAction saveImageAction;
    private SaveDatasetAction saveDatasetAction = new SaveDatasetAction();

    public HeatMapEditorKit(final HeatMapPanel heatMapPanel) {
        KeyStroke ks;
        this.rankedListAction = new RankedListAction(heatMapPanel);
        this.saveImageAction = new SaveImageAction();
        this.aboutAction = new AboutAction();
        this.filterRowsAction = new FilterRowsAction(heatMapPanel);
        this.editColumnAnnotationsAction = MetadataEditor.createAction(false);
        this.editRowAnnotationsAction = MetadataEditor.createAction(true);
        this.markerSelectionAction = new MarkerSelectionAction();
        this.copyAction = new CopyTableAction(new JTable[]{heatMapPanel.getRowTable(), heatMapPanel.getColumnTable()}, new boolean[]{false, true});
        this.datasetTableViewAction = new DatasetTableAction(heatMapPanel.getProject());
        this.sortColumnsAction = new SortColumnsAction(heatMapPanel);
        this.sortRowsAction = new SortRowsAction(heatMapPanel);
        this.hierarchicalClusteringAction = new HierarchicalClusteringAction();
        this.datasetTableViewAction.putValue("ShortDescription", "Table view of selected rows and columns");
        this.datasetTableViewAction.putValue("SmallIcon", IconManager.loadIcon("16x16/15407.sc_inserttable.png"));
        this.columnCorrelationMatrixAction = new ColumnDistanceMatrixAction();
        this.rowCorrelationMatrixAction = new RowDistanceMatrixAction();
        this.zoomInAction = new ZoomInAction("Both", "Zoom in columns and rows");
        this.zoomOutAction = new ZoomOutAction("Both", "Zoom out columns and rows");
        this.boxPlotAction = new BoxPlotAction();
        if (!GraphicsEnvironment.isHeadless()) {
            ks = KeyStroke.getKeyStroke(61, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
            heatMapPanel.getInputMap(2).put(ks, (String)this.zoomInAction.getValue("Name"));
            this.zoomInAction.putValue("AcceleratorKey", ks);
        }
        if (!GraphicsEnvironment.isHeadless()) {
            ks = KeyStroke.getKeyStroke(45, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
            heatMapPanel.getInputMap(2).put(ks, (String)this.zoomOutAction.getValue("Name"));
            this.zoomOutAction.putValue("AcceleratorKey", ks);
        }
        this.cutColumnDendrogramAction = new AbstractAction("Cut Node"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (heatMapPanel.getColumnDendrogramPanel().getSelectedNode() == null) {
                    UIUtil.showErrorDialog(UIUtil.getCurrentFrame(), "Please select a dendrogram node first.");
                    return;
                }
                heatMapPanel.getColumnDendrogramPanel().cutSelectedNode();
            }
        };
        this.cutColumnDendrogramAction.setEnabled(heatMapPanel.getColumnDendrogramPanel() != null);
        this.cutRowDendrogramAction = new AbstractAction("Cut Node"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (heatMapPanel.getRowDendrogramPanel().getSelectedNode() == null) {
                    UIUtil.showErrorDialog(UIUtil.getCurrentFrame(), "Please select a dendrogram node first.");
                    return;
                }
                heatMapPanel.getRowDendrogramPanel().cutSelectedNode();
            }
        };
        this.cutRowDendrogramAction.setEnabled(heatMapPanel.getRowDendrogramPanel() != null);
        this.rowDendrogramBranchColorAction = new AbstractAction("Branch Color"){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackerUtil.trackPageView((String)this.getValue("Name"));
                heatMapPanel.getRowDendrogramColorEditor().show();
            }
        };
        this.rowDendrogramBranchColorAction.setEnabled(heatMapPanel.getRowDendrogramPanel() != null);
        this.columnDendrogramBranchColorAction = new AbstractAction("Branch Color"){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackerUtil.trackPageView((String)this.getValue("Name"));
                heatMapPanel.getColumnDendrogramColorEditor().show();
            }
        };
        this.columnDendrogramBranchColorAction.setEnabled(heatMapPanel.getColumnDendrogramPanel() != null);
        this.preferencesAction = new PreferencesAction();
        this.newHeatMapAction = new NewHeatMapAction();
        this.maskColumnsAction = new MaskAction(false);
        this.unMaskColumnsAction = new UnMaskAction(false);
        this.resetMaskColumnsAction = new ResetMaskAction(false);
        this.maskRowsAction = new MaskAction(true);
        this.unMaskRowsAction = new UnMaskAction(true);
        this.resetMaskRowsAction = new ResetMaskAction(true);
        this.rowProfileAction = new ProfileAction(true);
        this.columnProfileAction = new ProfileAction(false);
    }

    public Action getAboutAction() {
        return this.aboutAction;
    }

    public Action getBoxPlotAction() {
        return this.boxPlotAction;
    }

    public Action getColumnCorrelationMatrixAction() {
        return this.columnCorrelationMatrixAction;
    }

    public AbstractAction getColumnDendrogramBranchColorAction() {
        return this.columnDendrogramBranchColorAction;
    }

    public Action getColumnProfileAction() {
        return this.columnProfileAction;
    }

    public Action getCopyAction() {
        return this.copyAction;
    }

    public AbstractAction getCutColumnDendrogramAction() {
        return this.cutColumnDendrogramAction;
    }

    public AbstractAction getCutRowDendrogramAction() {
        return this.cutRowDendrogramAction;
    }

    public Action getDatasetTableViewAction() {
        return this.datasetTableViewAction;
    }

    public Action getEditColumnAnnotationsAction() {
        return this.editColumnAnnotationsAction;
    }

    public Action getEditRowAnnotationsAction() {
        return this.editRowAnnotationsAction;
    }

    public Action getFilterRowsAction() {
        return this.filterRowsAction;
    }

    public Action getHierarchicalClusteringAction() {
        return this.hierarchicalClusteringAction;
    }

    public Action getHistogramAction() {
        return this.histogramAction;
    }

    public Action getMarkerSelectionAction() {
        return this.markerSelectionAction;
    }

    public MaskAction getMaskColumnsAction() {
        return this.maskColumnsAction;
    }

    public MaskAction getMaskRowsAction() {
        return this.maskRowsAction;
    }

    public Action getNewHeatMapAction() {
        return this.newHeatMapAction;
    }

    public Action getRankedListAction() {
        return this.rankedListAction;
    }

    public ResetMaskAction getResetMaskColumnsAction() {
        return this.resetMaskColumnsAction;
    }

    public ResetMaskAction getResetMaskRowsAction() {
        return this.resetMaskRowsAction;
    }

    public Action getRowCorrelationMatrixAction() {
        return this.rowCorrelationMatrixAction;
    }

    public AbstractAction getRowDendrogramBranchColorAction() {
        return this.rowDendrogramBranchColorAction;
    }

    public Action getRowProfileAction() {
        return this.rowProfileAction;
    }

    public Action getSortColumnsAction() {
        return this.sortColumnsAction;
    }

    public Action getSortRowsAction() {
        return this.sortRowsAction;
    }

    public UnMaskAction getUnMaskColumnsAction() {
        return this.unMaskColumnsAction;
    }

    public UnMaskAction getUnMaskRowsAction() {
        return this.unMaskRowsAction;
    }

    public PreferencesAction getPreferencesAction() {
        return this.preferencesAction;
    }

    public ZoomInAction getZoomInAction() {
        return this.zoomInAction;
    }

    public ZoomOutAction getZoomOutAction() {
        return this.zoomOutAction;
    }

    public static Collection<FloatListFunction> getDefaultFunctions() {
        return DEFAULT_FUNCTIONS;
    }

    public static FloatListFunction getFunction(String name) {
        return nameToFunction.get(name);
    }

    public SaveImageAction getSaveImageAction() {
        return this.saveImageAction;
    }

    public SaveDatasetAction getSaveDatasetAction() {
        return this.saveDatasetAction;
    }

    static {
        DEFAULT_FUNCTIONS.add(new CoefficientOfVariation());
        DEFAULT_FUNCTIONS.add(new Max());
        DEFAULT_FUNCTIONS.add(new MaxDividedByMin());
        DEFAULT_FUNCTIONS.add(new MaxMinusMin());
        DEFAULT_FUNCTIONS.add(new Mean());
        DEFAULT_FUNCTIONS.add(new MedianAbsoluteDeviation());
        DEFAULT_FUNCTIONS.add(new Median());
        DEFAULT_FUNCTIONS.add(new Stdev());
        nameToFunction = new HashMap<String, FloatListFunction>();
        for (FloatListFunction f : DEFAULT_FUNCTIONS) {
            nameToFunction.put(f.toString(), f);
        }
    }

    public static class SortRowsAction
    extends AbstractAction {
        private HeatMapPanel heatmapPanel;
        private SortRowsDialog sortRowsDialog;

        public SortRowsAction(HeatMapPanel heatmapPanel) {
            super("Sort Rows\u2026");
            this.heatmapPanel = heatmapPanel;
            this.putValue("ShortDescription", "Sort rows");
            this.putValue("SmallIcon", IconManager.loadIcon("16x16/10626.sort.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.sortRowsDialog == null) {
                this.sortRowsDialog = new SortRowsDialog(this.heatmapPanel);
            }
            this.sortRowsDialog.show();
        }
    }

    public static class SortColumnsAction
    extends AbstractAction {
        private HeatMapPanel heatmapPanel;
        private SortColumnsDialog sortColumnsDialog;

        public SortColumnsAction(HeatMapPanel heatmapPanel) {
            super("Sort Columns\u2026");
            this.heatmapPanel = heatmapPanel;
            this.putValue("ShortDescription", "Sort columns");
            this.putValue("SmallIcon", IconManager.loadIcon("16x16/10626.sort-columns.GIF"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.sortColumnsDialog == null) {
                this.sortColumnsDialog = new SortColumnsDialog(this.heatmapPanel);
            }
            this.sortColumnsDialog.show();
        }
    }
}

