/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import gnu.trove.set.hash.TIntHashSet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import org.broadinstitute.genee.chart.MatrixElement;
import org.broadinstitute.genee.gui.Drawable;
import org.broadinstitute.genee.gui.TableToolTip;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.DatasetElementToolTipProvider;
import org.broadinstitute.genee.heatmap.DefaultSizesAndPositions;
import org.broadinstitute.genee.heatmap.DefaultToolTipProvider;
import org.broadinstitute.genee.heatmap.ElementPainter;
import org.broadinstitute.genee.heatmap.HeatMapColorScheme;
import org.broadinstitute.genee.heatmap.HeatMapElementRenderer;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.ProjectEvent;
import org.broadinstitute.genee.heatmap.ProjectListener;
import org.broadinstitute.genee.heatmap.SelectionEvent;
import org.broadinstitute.genee.heatmap.SelectionListener;
import org.broadinstitute.genee.heatmap.SizesAndPositions;
import org.broadinstitute.genee.heatmap.SizesAndPositionsEvent;
import org.broadinstitute.genee.heatmap.SizesAndPositionsListener;
import org.broadinstitute.genee.matrix.Dataset;

public class HeatMapElementPanel
extends JPanel
implements Drawable,
TableToolTip {
    private static DatasetElementToolTipProvider DEFAULT_TOOLTIP_PROVIDER = new DefaultToolTipProvider();
    private final SizesAndPositions columnSizesAndPositions;
    private HeatMapElementRenderer heatMapElementRenderer;
    private Image image;
    private int priorBottom = -1;
    private int priorLeft = -1;
    private int priorRight = -1;
    private int priorTop = -1;
    private ProjectListener projectListener;
    private final SizesAndPositions rowSizesAndPositions;
    private SelectionListener selectionListener;
    private SizesAndPositionsListener sizesAndPositionsListener;
    private DatasetElementToolTipProvider toolTipProvider = DEFAULT_TOOLTIP_PROVIDER;
    private boolean ignoreColumnSizesAndPositionsEvent = false;
    private boolean validImage = false;
    private Rectangle visibleRect = new Rectangle();
    private MatrixElement zoomToElement;
    protected boolean updateSelection = true;
    private List<Point> selectedRowElements;
    private List<Point> selectedColumnElements;

    public HeatMapElementPanel(SizesAndPositions rowSizesAndPositions, SizesAndPositions columnSizesAndPositions) {
        this.rowSizesAndPositions = rowSizesAndPositions;
        this.columnSizesAndPositions = columnSizesAndPositions;
        this.setDoubleBuffered(false);
        this.setBackground(Color.WHITE);
        this.setFont(new Font(UIUtil.getFontName(), 0, 8));
        this.heatMapElementRenderer = new HeatMapElementRenderer();
        this.sizesAndPositionsListener = new SizesAndPositionsListener(){

            @Override
            public void sizesAndPositionsChanged(SizesAndPositionsEvent e) {
                if (HeatMapElementPanel.this.ignoreColumnSizesAndPositionsEvent && e.getSource() == HeatMapElementPanel.this.columnSizesAndPositions) {
                    return;
                }
                HeatMapElementPanel.this.invalidateImage();
            }
        };
        this.image = new BufferedImage(1, 1, 2);
        this.projectListener = new ProjectListener(){

            @Override
            public void projectChanged(ProjectEvent e) {
                HeatMapElementPanel.this.heatMapElementRenderer.updateDataset();
                HeatMapElementPanel.this.invalidateImage();
            }
        };
        this.selectionListener = new SelectionListener(){

            @Override
            public void valueChanged(SelectionEvent e) {
                HeatMapElementPanel.this.updateSelection = true;
                HeatMapElementPanel.this.repaint();
            }
        };
        rowSizesAndPositions.addSizesAndPositionsListener(this.sizesAndPositionsListener);
        columnSizesAndPositions.addSizesAndPositionsListener(this.sizesAndPositionsListener);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        UIUtil.registerToolTip(this);
    }

    public void changeColumnSizes(float change) {
        this.columnSizesAndPositions.setSize(this.columnSizesAndPositions.getSize() + change);
        this.columnSizesAndPositions.notifyListeners(4);
    }

    public void changeRowSizes(float change) {
        this.rowSizesAndPositions.setSize(this.rowSizesAndPositions.getSize() + change);
        this.rowSizesAndPositions.notifyListeners(4);
    }

    @Override
    public void draw(Graphics g, Rectangle clip) {
        int left = this.heatMapElementRenderer.getLeft(clip, this.columnSizesAndPositions);
        int right = this.heatMapElementRenderer.getRight(clip, this.columnSizesAndPositions);
        int top = this.heatMapElementRenderer.getTop(clip, this.rowSizesAndPositions);
        int bottom = this.heatMapElementRenderer.getBottom(clip, this.rowSizesAndPositions);
        this.heatMapElementRenderer.draw((Graphics2D)g, left, right, top, bottom, this.columnSizesAndPositions, this.rowSizesAndPositions);
    }

    public HeatMapColorScheme getColorScheme() {
        return this.heatMapElementRenderer.getColorScheme();
    }

    public float getColumnSize() {
        return this.columnSizesAndPositions.getSize();
    }

    public SizesAndPositions getColumnSizesAndPositions() {
        return this.columnSizesAndPositions;
    }

    public SizesAndPositions getColumnSizeSequence() {
        return this.columnSizesAndPositions;
    }

    public Dataset getDataset() {
        return this.heatMapElementRenderer.getDataset();
    }

    @Override
    public Dimension getDrawableSize() {
        Dimension d = new Dimension();
        d.width = HeatMapPanel.getSizeNoBorder(this.columnSizesAndPositions);
        d.height = HeatMapPanel.getSizeNoBorder(this.rowSizesAndPositions);
        return d;
    }

    public ElementPainter getElementPainter() {
        return this.heatMapElementRenderer.getElementPainter();
    }

    public Color getGridColor() {
        return this.heatMapElementRenderer.getGridColor();
    }

    public HeatMapElementRenderer getHeatMapElementRenderer() {
        return this.heatMapElementRenderer;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = new Dimension();
        size.width = HeatMapPanel.getSize(this.columnSizesAndPositions);
        size.height = HeatMapPanel.getSize(this.rowSizesAndPositions);
        return size;
    }

    public float getRowSize() {
        return this.rowSizesAndPositions.getSize();
    }

    public SizesAndPositions getRowSizesAndPositions() {
        return this.rowSizesAndPositions;
    }

    @Override
    public List<Map.Entry> getTableToolTipText(MouseEvent e) {
        int[] columns = DefaultSizesAndPositions.getIndices(this.columnSizesAndPositions, e.getX());
        int[] rows = DefaultSizesAndPositions.getIndices(this.rowSizesAndPositions, e.getY());
        if (rows.length == 0 && columns.length == 0) {
            return null;
        }
        Dataset dataset = this.heatMapElementRenderer.getDataset();
        ArrayList<Map.Entry> entries = new ArrayList<Map.Entry>();
        for (int row : rows) {
            for (int col : columns) {
                entries.addAll(this.toolTipProvider.getToolTipText(dataset, row, col, e));
            }
        }
        return entries;
    }

    public boolean isDrawGrid() {
        return this.heatMapElementRenderer.isDrawGrid();
    }

    public boolean isDrawValues() {
        return this.heatMapElementRenderer.isDrawValues();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        UIUtil.unregisterToolTip(this);
    }

    void setColorScheme(HeatMapColorScheme cs) {
        this.heatMapElementRenderer.setColorScheme(cs);
        this.invalidateImage();
    }

    public void setDrawGrid(boolean drawGrid) {
        if (this.heatMapElementRenderer.isDrawGrid() != drawGrid) {
            this.heatMapElementRenderer.setDrawGrid(drawGrid);
            this.invalidateImage();
        }
    }

    public void setDrawValues(boolean drawValues) {
        if (this.heatMapElementRenderer.isDrawValues() != drawValues) {
            this.heatMapElementRenderer.setDrawValues(drawValues);
            this.invalidateImage();
        }
    }

    public void setElementPainter(ElementPainter painter) {
        this.heatMapElementRenderer.setElementPainter(painter);
        this.invalidateImage();
    }

    public void setGridColor(Color c) {
        if (!this.heatMapElementRenderer.getGridColor().equals(c)) {
            this.heatMapElementRenderer.setGridColor(c);
            this.invalidateImage();
        }
    }

    public void setMaskedColumnIndices(TIntHashSet viewIndices) {
        if (!this.heatMapElementRenderer.setMaskedColumnIndices(viewIndices)) {
            this.invalidateImage();
        }
    }

    public void setMaskedRowIndices(TIntHashSet viewIndices) {
        if (!this.heatMapElementRenderer.setMaskedRowIndices(viewIndices)) {
            this.invalidateImage();
        }
    }

    public void setProject(Project project) {
        if (this.heatMapElementRenderer.getProject() != null) {
            this.heatMapElementRenderer.getProject().getRowSelectionModel().removeSelectionListener(this.selectionListener);
            this.heatMapElementRenderer.getProject().getColumnSelectionModel().removeSelectionListener(this.selectionListener);
            this.heatMapElementRenderer.getProject().removeProjectListener(this.projectListener);
        }
        this.heatMapElementRenderer.setProject(project);
        project.getRowSelectionModel().addSelectionListener(this.selectionListener);
        project.getColumnSelectionModel().addSelectionListener(this.selectionListener);
        project.addProjectListener(this.projectListener);
    }

    public void setToolTipProvider(DatasetElementToolTipProvider toolTipProvider) {
        if (toolTipProvider == null) {
            toolTipProvider = DEFAULT_TOOLTIP_PROVIDER;
        }
        this.toolTipProvider = toolTipProvider;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Rectangle rect;
        super.paintComponent(g);
        Rectangle currentVisibleRect = this.getVisibleRect();
        if (this.validImage && (currentVisibleRect.height != this.visibleRect.height || currentVisibleRect.y != this.visibleRect.y || currentVisibleRect.width != this.visibleRect.width || currentVisibleRect.x != this.visibleRect.x)) {
            this.validImage = false;
        }
        int left = this.heatMapElementRenderer.getLeft(currentVisibleRect, this.columnSizesAndPositions);
        int right = this.heatMapElementRenderer.getRight(currentVisibleRect, this.columnSizesAndPositions);
        int top = this.heatMapElementRenderer.getTop(currentVisibleRect, this.rowSizesAndPositions);
        int bottom = this.heatMapElementRenderer.getBottom(currentVisibleRect, this.rowSizesAndPositions);
        if (this.validImage && (left != this.priorLeft || right != this.priorRight || top != this.priorTop || bottom != this.priorBottom)) {
            this.validImage = false;
        }
        if (!this.validImage) {
            this.validImage = true;
            this.visibleRect = currentVisibleRect;
            this.priorLeft = left;
            this.priorRight = right;
            this.priorTop = top;
            this.priorBottom = bottom;
            this.image = new BufferedImage(this.visibleRect.width, this.visibleRect.height, 2);
            Graphics2D imageGraphics = (Graphics2D)this.image.getGraphics();
            imageGraphics.setFont(this.getFont());
            imageGraphics.translate(-this.visibleRect.x, -this.visibleRect.y);
            this.heatMapElementRenderer.draw(imageGraphics, left, right, top, bottom, this.columnSizesAndPositions, this.rowSizesAndPositions);
            imageGraphics.dispose();
        }
        g.drawImage(this.image, this.visibleRect.x, this.visibleRect.y, null);
        Graphics2D g2 = (Graphics2D)g;
        if (this.updateSelection) {
            this.updateSelection = false;
            this.selectedRowElements = this.getSelectedRectangles(this.heatMapElementRenderer.getProject().getRowSelectionModel().getSelectedViewIndices());
            this.selectedColumnElements = this.getSelectedRectangles(this.heatMapElementRenderer.getProject().getColumnSelectionModel().getSelectedViewIndices());
            if (this.selectedRowElements.size() != 0 || this.selectedColumnElements.size() != 0) {
                if (this.selectedRowElements.size() == 0) {
                    this.selectedRowElements.add(new Point(top, bottom - 1));
                }
                if (this.selectedColumnElements.size() == 0) {
                    this.selectedColumnElements.add(new Point(left, right - 1));
                }
            }
        }
        boolean emptySelection = this.selectedRowElements.size() == 0;
        emptySelection = emptySelection && this.selectedColumnElements.size() == 0;
        Color selectionColor = Color.YELLOW;
        if (this.heatMapElementRenderer.isDrawGrid() && this.heatMapElementRenderer.getGridColor().equals(selectionColor)) {
            g2.setColor(Color.GRAY);
        }
        if (!emptySelection) {
            g2.setColor(selectionColor);
            rect = new Rectangle();
            for (Point r : this.selectedRowElements) {
                float y1 = this.rowSizesAndPositions.getPosition(r.x);
                float y2 = this.rowSizesAndPositions.getPosition(r.y) + this.rowSizesAndPositions.getSize();
                for (Point c : this.selectedColumnElements) {
                    float x1 = this.columnSizesAndPositions.getPosition(c.x);
                    float x2 = this.columnSizesAndPositions.getPosition(c.y) + this.columnSizesAndPositions.getSize();
                    rect.setRect(x1, y1, x2 - x1, y2 - y1);
                    g2.draw(rect);
                }
            }
        }
        if (this.zoomToElement != null) {
            g2.setColor(Color.BLACK);
            g2.setStroke(new BasicStroke(4.0f));
            rect = new Rectangle();
            float width = this.columnSizesAndPositions.getSize();
            if (width < 6.0f) {
                width = 6.0f;
            }
            float x1 = this.columnSizesAndPositions.getPosition(this.zoomToElement.getColumn());
            float x2 = this.columnSizesAndPositions.getPosition(this.zoomToElement.getColumn()) + width;
            if (x2 - x1 < 12.0f) {
                x2 += 8.0f;
                x1 -= 8.0f;
            }
            float height = this.rowSizesAndPositions.getSize();
            float y1 = this.rowSizesAndPositions.getPosition(this.zoomToElement.getRow());
            float y2 = this.rowSizesAndPositions.getPosition(this.zoomToElement.getRow()) + height;
            if (y2 - y1 < 12.0f) {
                y2 += 8.0f;
                y1 -= 8.0f;
            }
            rect.setRect(x1, y1, x2 - x1, y2 - y1);
            g2.draw(rect);
        }
    }

    public void setZoomToElement(MatrixElement zoomToElement) {
        this.zoomToElement = zoomToElement;
    }

    void invalidateImage() {
        this.updateSelection = true;
        this.validImage = false;
        this.revalidate();
        this.repaint();
    }

    boolean isIgnoreColumnSizesAndPositionsEvent() {
        return this.ignoreColumnSizesAndPositionsEvent;
    }

    void setIgnoreColumnSizesAndPositionsEvent(boolean b) {
        this.ignoreColumnSizesAndPositionsEvent = b;
    }

    private List<Point> getSelectedRectangles(int[] viewIndices) {
        ArrayList<Point> list = new ArrayList<Point>();
        if (viewIndices != null && viewIndices.length > 0) {
            int index;
            int start = index = 0;
            int length = viewIndices.length;
            while (index < length) {
                int current = viewIndices[index];
                int prior = index == 0 ? viewIndices[0] : viewIndices[index - 1];
                if (current - prior > 1) {
                    list.add(new Point(viewIndices[start], viewIndices[index - 1]));
                    start = index;
                }
                ++index;
            }
            if (start == 0) {
                list.add(new Point(viewIndices[0], viewIndices[viewIndices.length - 1]));
            } else {
                list.add(new Point(viewIndices[start], viewIndices[index - 1]));
            }
        }
        return list;
    }

    public static int getBottom(int rowCount, Rectangle rect, SizesAndPositions rowSizeSequence) {
        int bottom = rowCount;
        if (rect != null) {
            bottom = rowSizeSequence.getIndex(rect.y + rect.height, false) + 1;
            if (bottom > rowCount) {
                bottom = rowCount;
            } else if (bottom < 0) {
                bottom = 0;
            }
        }
        return bottom;
    }

    public static int getLeft(Rectangle rect, SizesAndPositions columnSizeSequence) {
        int left = 0;
        if (rect != null) {
            left = Math.max(columnSizeSequence.getIndex(rect.x, false) - 1, 0);
        }
        return left;
    }

    public static int getRight(int columnCount, Rectangle rect, SizesAndPositions columnSizeSequence) {
        int right = columnCount;
        if (rect != null) {
            right = Math.min(columnSizeSequence.getIndex(rect.x + rect.width, false) + 1, columnCount);
        }
        return right;
    }

    public static int getTop(int rowCount, Rectangle rect, SizesAndPositions rowSizeSequence) {
        int top = 0;
        if (rect != null) {
            top = rowSizeSequence.getIndex(rect.y, false) - 1;
            if (top < 0) {
                top = 0;
            } else if (top >= rowCount) {
                top = rowCount - 1;
            }
        }
        return top;
    }
}

