/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import java.awt.Component;
import javax.swing.JTabbedPane;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEWindow;
import org.broadinstitute.genee.chart.CurveOptionsPanel;
import org.broadinstitute.genee.gui.DendrogramOptionsPanel;
import org.broadinstitute.genee.gui.GapMapOptions;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.CurveElementList;
import org.broadinstitute.genee.heatmap.DisplayOptionsPanel;
import org.broadinstitute.genee.heatmap.GeneralOptionsPanel;
import org.broadinstitute.genee.heatmap.HeatMapColorSchemeOptionsPanel;
import org.broadinstitute.genee.heatmap.HeatMapElementPanel;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.jdesktop.swingx.util.OS;

public class HeatMapOptionsDialog {
    private GENEEWindow optionsWindow;
    private HeatMapPanel heatMapPanel;
    private JTabbedPane tabbedPane = UIUtil.createTabbedPane();
    private DendrogramOptionsPanel columnDendrogramPanel;
    private GapMapOptions rowGapMapOptions;
    private GapMapOptions columnGapMapOptions;
    private DendrogramOptionsPanel rowDendrogramPanel;
    private HeatMapColorSchemeOptionsPanel colorSchemeOptionsPanel;
    private DisplayOptionsPanel displayOptionsPanel;
    private GeneralOptionsPanel generalOptionsPanel;

    public HeatMapOptionsDialog(HeatMapPanel heatMap, HeatMapElementPanel heatMapPanel) {
        this.init(heatMap, heatMapPanel);
    }

    public void show() {
        this.configureValues();
        this.optionsWindow.pack();
        this.optionsWindow.setVisible(true);
    }

    private void configureValues() {
        int index = this.removeTabs("Color Scheme")[0];
        this.colorSchemeOptionsPanel = new HeatMapColorSchemeOptionsPanel(this.heatMapPanel);
        this.tabbedPane.insertTab("Color Scheme", null, UIUtil.createNoBorderScrollPane(this.colorSchemeOptionsPanel.createPanel()), null, index);
        this.removeTabs("Curves");
        if (this.heatMapPanel.getProject().getOriginalDataset() != null && DatasetUtil.getSeriesIndex(this.heatMapPanel.getProject().getOriginalDataset(), CurveElementList.class) != -1) {
            this.tabbedPane.insertTab("Curves", null, UIUtil.createNoBorderScrollPane(new CurveOptionsPanel(this.heatMapPanel)), null, this.tabbedPane.getTabCount() - 1);
        }
        if (Application.isDevVersion() && this.heatMapPanel.getColumnDendrogramPanel() != null) {
            this.columnDendrogramPanel = new DendrogramOptionsPanel(this.heatMapPanel, false);
            this.columnGapMapOptions = new GapMapOptions(false);
            this.columnGapMapOptions.setSplittable(this.heatMapPanel.getColumnDendrogramPanel());
            this.removeTabs("Column Dendrogram Nodes", "Column Gap Map");
            this.tabbedPane.addTab("Column Gap Map", UIUtil.createNoBorderScrollPane(this.columnGapMapOptions));
            this.tabbedPane.addTab("Column Dendrogram Nodes", UIUtil.createNoBorderScrollPane(this.columnDendrogramPanel));
        }
        if (Application.isDevVersion() && this.heatMapPanel.getRowDendrogramPanel() != null) {
            this.rowDendrogramPanel = new DendrogramOptionsPanel(this.heatMapPanel, true);
            this.rowGapMapOptions = new GapMapOptions(true);
            this.rowGapMapOptions.setSplittable(this.heatMapPanel.getRowDendrogramPanel());
            this.removeTabs("Row Dendrogram Nodes", "Row Gap Map");
            this.tabbedPane.addTab("Row Gap Map", UIUtil.createNoBorderScrollPane(this.rowGapMapOptions));
            this.tabbedPane.addTab("Row Dendrogram Nodes", UIUtil.createNoBorderScrollPane(this.rowDendrogramPanel));
        }
        this.tabbedPane.setSelectedIndex(0);
        this.displayOptionsPanel.configureValues();
        this.colorSchemeOptionsPanel.configureValues(true);
        this.optionsWindow.pack();
    }

    private void init(HeatMapPanel heatMapPanel, HeatMapElementPanel elementPanel) {
        this.optionsWindow = Application.createDialog(OS.isMacOSX() ? "Preferences" : "Options");
        this.heatMapPanel = heatMapPanel;
        this.colorSchemeOptionsPanel = new HeatMapColorSchemeOptionsPanel(heatMapPanel);
        this.tabbedPane.addTab("Color Scheme", UIUtil.createNoBorderScrollPane(this.colorSchemeOptionsPanel.createPanel()));
        this.displayOptionsPanel = new DisplayOptionsPanel(heatMapPanel);
        this.tabbedPane.addTab("Display", UIUtil.createNoBorderScrollPane(this.displayOptionsPanel));
        this.optionsWindow.getContentPane().add((Component)this.tabbedPane, "Center");
        this.generalOptionsPanel = new GeneralOptionsPanel();
        this.tabbedPane.addTab("General", this.generalOptionsPanel);
        this.tabbedPane.setSelectedIndex(0);
        this.tabbedPane.revalidate();
        this.tabbedPane.repaint();
        this.optionsWindow.pack();
    }

    private int[] removeTabs(String ... names) {
        int[] tabIndices = new int[names.length];
        block0: for (int j = 0; j < names.length; ++j) {
            String name = names[j];
            int size = this.tabbedPane.getTabCount();
            for (int i = 0; i < size; ++i) {
                if (!this.tabbedPane.getTitleAt(i).equals(name)) continue;
                this.tabbedPane.removeTabAt(i);
                tabIndices[j] = i;
                continue block0;
            }
        }
        return tabIndices;
    }
}

