/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.SliderPanel;
import org.broadinstitute.genee.heatmap.HeatMapPanel;

public class HeatMapSizeOptions {
    private SliderPanel columnSizeSliderPanel;
    private HeatMapPanel heatMapPanel;
    private SliderPanel rowSizeSliderPanel;
    private JCheckBox synchSizesCheckBox;

    public HeatMapSizeOptions(final HeatMapPanel heatMapPanel, FormBuilder formBuilder) {
        this.heatMapPanel = heatMapPanel;
        this.synchSizesCheckBox = new JCheckBox("Synchronize row and column sizes", false);
        formBuilder.addLabel("Column size:");
        this.columnSizeSliderPanel = new SliderPanel(heatMapPanel.getColumnSize(), 0.1f, 20.0f, 10.0f){

            @Override
            public void setTextFromSlider(float value) {
                if (value > 1.0f) {
                    value = (int)value;
                }
                super.setTextFromSlider(value);
            }
        };
        this.columnSizeSliderPanel.setLabels(new int[]{10, 20}, 2);
        this.columnSizeSliderPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                heatMapPanel.setColumnSize(HeatMapSizeOptions.this.columnSizeSliderPanel.getValue());
                if (HeatMapSizeOptions.this.synchSizesCheckBox.isSelected()) {
                    heatMapPanel.setRowSize(HeatMapSizeOptions.this.columnSizeSliderPanel.getValue());
                    HeatMapSizeOptions.this.rowSizeSliderPanel.setValue(HeatMapSizeOptions.this.columnSizeSliderPanel.getValue(), true);
                }
            }
        });
        formBuilder.add(this.columnSizeSliderPanel);
        formBuilder.nextSmallRow();
        formBuilder.addLabel("Row size:");
        this.rowSizeSliderPanel = new SliderPanel(heatMapPanel.getRowSize(), 0.1f, 20.0f, 10.0f){

            @Override
            public void setTextFromSlider(float value) {
                if (value > 1.0f) {
                    value = (int)value;
                }
                super.setTextFromSlider(value);
            }
        };
        this.rowSizeSliderPanel.setLabels(new int[]{10, 20}, 2);
        this.rowSizeSliderPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                heatMapPanel.setRowSize(HeatMapSizeOptions.this.rowSizeSliderPanel.getValue());
                if (HeatMapSizeOptions.this.synchSizesCheckBox.isSelected()) {
                    heatMapPanel.setColumnSize(HeatMapSizeOptions.this.rowSizeSliderPanel.getValue());
                    HeatMapSizeOptions.this.columnSizeSliderPanel.setValue(HeatMapSizeOptions.this.rowSizeSliderPanel.getValue(), true);
                }
            }
        });
        formBuilder.add(this.rowSizeSliderPanel);
        this.synchSizesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (HeatMapSizeOptions.this.synchSizesCheckBox.isSelected()) {
                    float maxValue = Math.max(HeatMapSizeOptions.this.rowSizeSliderPanel.getValue(), HeatMapSizeOptions.this.columnSizeSliderPanel.getValue());
                    heatMapPanel.setColumnSize(maxValue);
                    heatMapPanel.setRowSize(maxValue);
                    HeatMapSizeOptions.this.columnSizeSliderPanel.setValue(maxValue, true);
                    HeatMapSizeOptions.this.rowSizeSliderPanel.setValue(maxValue, true);
                }
            }
        });
        formBuilder.nextRow();
        formBuilder.addSpanned(this.synchSizesCheckBox);
    }

    void configureValues() {
        if (this.rowSizeSliderPanel != null) {
            this.rowSizeSliderPanel.setValue(this.heatMapPanel.getRowSize(), false);
            this.columnSizeSliderPanel.setValue(this.heatMapPanel.getColumnSize(), false);
        }
    }
}

