/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.DefaultWindowManager;
import org.broadinstitute.genee.gui.DatasetAutocomplete;
import org.broadinstitute.genee.heatmap.AbstractQuickFilterPanel;
import org.broadinstitute.genee.heatmap.FitToSizeAction;
import org.broadinstitute.genee.heatmap.FromGeneeAction;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.SearchComponents;
import org.broadinstitute.genee.heatmap.menu.CopyImageAction;
import org.broadinstitute.genee.io.util.Formatter;
import org.jdesktop.swingx.util.OS;

public class HeatMapToolBar
extends JToolBar {
    private JButton histogramButton;
    private JButton columnProfileButton;
    private SearchComponents columnSearch;
    private JButton dataTableButton;
    private JButton hclButton;
    private JButton newButton;
    private JButton rowProfileButton;
    private JButton rankedListButton;
    private JButton rowRowsButton;
    private SearchComponents rowSearch;
    private JButton sortColumnsButton;
    private JButton zoomInButton;
    private JButton zoomOutButton;
    private JButton markerSelectionButton;
    private JButton boxplotButton;
    private JButton filterRowsButton;
    private HeatMapPanel heatMapPanel;

    public HeatMapToolBar(HeatMapPanel heatMapPanel) {
        this.heatMapPanel = heatMapPanel;
        this.init();
    }

    public int getSearchComponentIndex() {
        return this.getComponentIndex((Component)((Object)this.columnSearch.getQuickSearch()));
    }

    public void grabColumnSearchFocus() {
        this.columnSearch.getQuickFilter().requestFocusInWindow();
    }

    public void grabRowSearchFocus() {
        this.rowSearch.getQuickFilter().requestFocusInWindow();
    }

    public void setAnalysisToolsVisible(boolean b) {
        this.hclButton.setVisible(b);
        this.markerSelectionButton.setVisible(b);
        this.newButton.setVisible(b);
        this.histogramButton.setVisible(b);
        this.boxplotButton.setVisible(b);
        this.columnProfileButton.setVisible(b);
        this.rowProfileButton.setVisible(b);
        this.rankedListButton.setVisible(b);
        this.dataTableButton.setVisible(b);
        this.sortColumnsButton.setVisible(b);
        this.rowRowsButton.setVisible(b);
        this.filterRowsButton.setVisible(b);
    }

    public void setSearchVisible(boolean visible) {
        this.rowSearch.setVisible(visible);
        this.columnSearch.setVisible(visible);
    }

    private void init() {
        this.rowSearch = new SearchComponents(this.heatMapPanel, this.heatMapPanel.getQuickRowSearch(), true);
        new DatasetAutocomplete((AbstractQuickFilterPanel)this.rowSearch.getQuickFilter(), this.heatMapPanel.getProject(), true);
        this.columnSearch = new SearchComponents(this.heatMapPanel, this.heatMapPanel.getQuickColumnSearch(), false);
        new DatasetAutocomplete((AbstractQuickFilterPanel)this.columnSearch.getQuickFilter(), this.heatMapPanel.getProject(), false);
        this.setFloatable(false);
        this.setBorderPainted(false);
        this.add(HeatMapToolBar.createButton(this.heatMapPanel.getHeatMapEditorKit().getSaveDatasetAction()));
        this.add(HeatMapToolBar.createButton(this.heatMapPanel.getHeatMapEditorKit().getSaveImageAction()));
        CopyImageAction copyImageAction = new CopyImageAction();
        copyImageAction.setJComponent(this.heatMapPanel);
        this.add(HeatMapToolBar.createButton(copyImageAction));
        this.heatMapPanel.getHeatMapEditorKit().getPreferencesAction().setZoomable(this.heatMapPanel);
        this.add(HeatMapToolBar.createButton(this.heatMapPanel.getHeatMapEditorKit().getPreferencesAction()));
        this.heatMapPanel.getHeatMapEditorKit().getZoomInAction().setZoomable(this.heatMapPanel);
        this.zoomInButton = HeatMapToolBar.createButton(this.heatMapPanel.getHeatMapEditorKit().getZoomInAction());
        this.add(this.zoomInButton);
        this.heatMapPanel.getHeatMapEditorKit().getZoomOutAction().setZoomable(this.heatMapPanel);
        this.zoomOutButton = HeatMapToolBar.createButton(this.heatMapPanel.getHeatMapEditorKit().getZoomOutAction());
        this.add(this.zoomOutButton);
        this.histogramButton = HeatMapToolBar.createButton(this.heatMapPanel.getHeatMapEditorKit().getHistogramAction());
        this.add(this.histogramButton);
        this.boxplotButton = HeatMapToolBar.createButton(this.heatMapPanel.getHeatMapEditorKit().getBoxPlotAction());
        this.add(this.boxplotButton);
        this.columnProfileButton = HeatMapToolBar.createButton(this.heatMapPanel.getHeatMapEditorKit().getColumnProfileAction());
        this.add(this.columnProfileButton);
        this.rowProfileButton = HeatMapToolBar.createButton(this.heatMapPanel.getHeatMapEditorKit().getRowProfileAction());
        this.add(this.rowProfileButton);
        this.rankedListButton = HeatMapToolBar.createButton(this.heatMapPanel.getHeatMapEditorKit().getRankedListAction());
        this.add(this.rankedListButton);
        this.dataTableButton = HeatMapToolBar.createButton(this.heatMapPanel.getHeatMapEditorKit().getDatasetTableViewAction());
        this.add(this.dataTableButton);
        this.newButton = HeatMapToolBar.createButton(this.heatMapPanel.getHeatMapEditorKit().getNewHeatMapAction());
        this.add(this.newButton);
        this.hclButton = HeatMapToolBar.createButton(this.heatMapPanel.getHeatMapEditorKit().getHierarchicalClusteringAction());
        this.add(this.hclButton);
        this.markerSelectionButton = HeatMapToolBar.createButton(this.heatMapPanel.getHeatMapEditorKit().getMarkerSelectionAction());
        this.add(this.markerSelectionButton);
        this.sortColumnsButton = HeatMapToolBar.createButton(this.heatMapPanel.getHeatMapEditorKit().getSortColumnsAction());
        this.add(this.sortColumnsButton);
        this.rowRowsButton = HeatMapToolBar.createButton(this.heatMapPanel.getHeatMapEditorKit().getSortRowsAction());
        this.add(this.rowRowsButton);
        this.filterRowsButton = HeatMapToolBar.createButton(this.heatMapPanel.getHeatMapEditorKit().getFilterRowsAction());
        this.add(this.filterRowsButton);
        JButton maximizeButton = HeatMapToolBar.createButton(new FitToSizeAction(this.heatMapPanel));
        this.add(maximizeButton);
        this.add(HeatMapToolBar.createButton(new FromGeneeAction()));
        JLabel testLabel = new JLabel();
        testLabel.setFont(testLabel.getFont().deriveFont(testLabel.getFont().getSize2D() - 1.0f));
        this.add((Component)((Object)this.columnSearch.getQuickSearch()));
        Dimension columnSize = this.columnSearch.getQuickSearch().getSearchResultsLabel().getPreferredSize();
        testLabel.setText("  " + Formatter.format(this.heatMapPanel.getProject().getOriginalDataset().getColumnCount()) + " in " + Formatter.format(this.heatMapPanel.getProject().getOriginalDataset().getColumnCount()));
        columnSize.width = testLabel.getPreferredSize().width;
        this.columnSearch.getQuickSearch().getSearchResultsLabel().setPreferredSize(columnSize);
        this.add(this.columnSearch.getQuickSearch().getSearchResultsLabel());
        this.add(this.columnSearch.getHighlightPrevious());
        this.add(this.columnSearch.getHighlightNext());
        this.add(this.columnSearch.getSelectAllMatchesButton());
        this.add(this.columnSearch.getSaveSearchButton());
        this.add(this.columnSearch.getBringMatchesToTopButton());
        Dimension rowSize = this.rowSearch.getQuickSearch().getSearchResultsLabel().getPreferredSize();
        testLabel.setText("  " + Formatter.format(this.heatMapPanel.getProject().getOriginalDataset().getRowCount()) + " in " + Formatter.format(this.heatMapPanel.getProject().getOriginalDataset().getRowCount()));
        rowSize.width = testLabel.getPreferredSize().width;
        this.rowSearch.getQuickSearch().getSearchResultsLabel().setPreferredSize(rowSize);
        this.add((Component)((Object)this.rowSearch.getQuickSearch()));
        this.add(this.rowSearch.getQuickSearch().getSearchResultsLabel());
        this.add(this.rowSearch.getHighlightPrevious());
        this.add(this.rowSearch.getHighlightNext());
        this.add(this.rowSearch.getSelectAllMatchesButton());
        this.add(this.rowSearch.getSaveSearchButton());
        this.add(this.rowSearch.getBringMatchesToTopButton());
        if (System.getProperty("org.broadinstitute.genee.debug") != null) {
            this.add(new AbstractAction("Debug"){

                @Override
                public void actionPerformed(ActionEvent paramActionEvent) {
                    ((DefaultWindowManager)Application.getWindowManager()).debug();
                }
            });
        }
    }

    public static void configure(JButton b) {
        b.setBorderPainted(false);
        b.setHorizontalTextPosition(0);
        b.setVerticalTextPosition(3);
        b.setRolloverEnabled(true);
    }

    public static JButton createButton(Action a) {
        JButton b = new JButton();
        b.addActionListener(a);
        KeyStroke ks = (KeyStroke)a.getValue("AcceleratorKey");
        b.setToolTipText((String)a.getValue("ShortDescription") + HeatMapToolBar.getString(ks));
        b.setIcon((Icon)a.getValue("SmallIcon"));
        HeatMapToolBar.configure(b);
        return b;
    }

    private static String getString(KeyStroke ks) {
        if (ks == null) {
            return "";
        }
        String c = "" + (char)ks.getKeyCode();
        if (ks.getKeyCode() == 61) {
            c = "Equals";
        } else if (ks.getKeyCode() == 45) {
            c = "Minus";
        }
        int modifiers = ks.getModifiers();
        if (!OS.isMacOSX()) {
            if ((modifiers & 0x80) != 0 && (modifiers & 0x40) != 0) {
                return " (Ctrl+Shift+" + c + ")";
            }
            if ((modifiers & 0x80) != 0) {
                return " (Ctrl+" + c + ")";
            }
        } else {
            if ((modifiers & 0x80) != 0 && (modifiers & 0x40) != 0) {
                return " (Command+Shift+" + c + ")";
            }
            if ((modifiers & 0x80) != 0) {
                return " (Command+" + c + ")";
            }
        }
        return "";
    }
}

