/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.hash.TIntHashSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.genee.filter.Filter;
import org.broadinstitute.genee.heatmap.AbstractSelectionModel;
import org.broadinstitute.genee.heatmap.FilterListener;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.ProjectSortKey;
import org.broadinstitute.genee.heatmap.SelectionModel;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.table.ProjectSorter;

public class IndexMapper {
    private Filter filter;
    private FilterListener filterListener;
    private boolean isRows;
    private TIntHashSet maskedModelIndices;
    private TIntHashSet maskedViewIndices;
    private Map<Integer, Integer> modelToView;
    private Project project;
    private AbstractSelectionModel selectionModel;
    private ProjectSorter sorter;
    private int[] sortOrder;
    private int[] viewOrder;

    public IndexMapper(Project project, ProjectSorter sorter, AbstractSelectionModel selectionModel, TIntHashSet viewMask, boolean isRows, FilterListener filterListener) {
        this.project = project;
        this.sorter = sorter;
        this.selectionModel = selectionModel;
        this.maskedViewIndices = viewMask;
        this.isRows = isRows;
        this.filterListener = filterListener;
    }

    public void addToMask(int[] viewIndices) {
        if (this.maskedModelIndices == null) {
            this.maskedModelIndices = new TIntHashSet();
        }
        int length = viewIndices.length;
        for (int i = 0; i < length; ++i) {
            int index = this.convertViewIndexToModel(viewIndices[i]);
            this.maskedModelIndices.add(index);
        }
        this.updateViewMaskFromModel();
    }

    public int convertModelIndexToView(int modelIndex) {
        if (this.modelToView != null) {
            Integer index = this.modelToView.get(modelIndex);
            return index != null ? index : -1;
        }
        return modelIndex;
    }

    public int[] convertToView(boolean includeSelection, boolean excludeMask) {
        int[] order = this.viewOrder;
        int[] selection = null;
        if (includeSelection) {
            selection = this.selectionModel.getSelectedViewIndices();
        }
        if (excludeMask && this.maskedViewIndices != null && this.maskedViewIndices.size() > 0) {
            selection = IndexMapper.removeMaskedIndices(selection, this.maskedViewIndices, order != null ? order.length : this.getOriginalDataset().getRowCount());
        }
        if (selection != null) {
            int[] newOrder = new int[selection.length];
            int length = newOrder.length;
            for (int i = 0; i < length; ++i) {
                newOrder[i] = order != null ? order[selection[i]] : selection[i];
            }
            order = newOrder;
        }
        return order;
    }

    public int convertViewIndexToModel(int viewIndex) {
        return this.viewOrder != null ? (viewIndex < this.viewOrder.length && viewIndex >= 0 ? this.viewOrder[viewIndex] : -1) : viewIndex;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public SelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public List<? extends ProjectSortKey> getSortKeys() {
        return this.sorter.getSortKeys();
    }

    public int[] getSortOrder() {
        return this.sortOrder;
    }

    public int getViewCount() {
        if (this.getOriginalDataset() == null) {
            return 0;
        }
        return this.viewOrder != null ? this.viewOrder.length : this.getOriginalDataset().getRowCount();
    }

    public TIntHashSet getViewMask() {
        return this.maskedViewIndices;
    }

    public boolean isSortOrderPreservesDendrogram() {
        return this.sorter.isDendrogramValid();
    }

    public void removeFromMask(int[] viewIndices) {
        int length = viewIndices.length;
        for (int i = 0; i < length; ++i) {
            int modelIndex = this.convertViewIndexToModel(viewIndices[i]);
            this.maskedModelIndices.remove(modelIndex);
        }
        this.updateViewMaskFromModel();
        this.selectionModel.setSelectedModelIndices(new int[0]);
    }

    public void setFilter(Filter filter) {
        if (this.filter != null) {
            this.filter.removeFilterListener(this.filterListener);
        }
        this.filter = filter;
        if (filter != null) {
            filter.addFilterListener(this.filterListener);
        }
    }

    public void setSelectedModelIndices(int[] selectedModelIndices) {
        this.selectionModel.setSelectedModelIndices(selectedModelIndices);
    }

    public void updateMappings() {
        if (this.project.getOriginalDataset() == null) {
            return;
        }
        Dataset originalDataset = this.getOriginalDataset();
        Dataset sortedDataset = DatasetUtil.sliceView(originalDataset, this.sortOrder, null);
        int count = sortedDataset.getRowCount();
        this.viewOrder = this.sortOrder;
        if (this.filter != null && !this.filter.isEmpty() && this.filter.isEnabled()) {
            TIntArrayList acceptIndices = new TIntArrayList();
            this.filter.init(sortedDataset);
            for (int i = 0; i < count; ++i) {
                if (!this.filter.accept(i)) continue;
                int modelIndex = this.sortOrder == null ? i : this.sortOrder[i];
                acceptIndices.add(modelIndex);
            }
            this.viewOrder = acceptIndices.toArray();
        }
        if (this.viewOrder != null) {
            this.modelToView = new HashMap<Integer, Integer>();
            int length = this.viewOrder.length;
            for (int i = 0; i < length; ++i) {
                this.modelToView.put(this.viewOrder[i], i);
            }
        } else {
            this.modelToView = null;
        }
        this.updateViewMaskFromModel();
    }

    protected void setSortOrder(List<? extends ProjectSortKey> sortKeys) {
        this.sorter.setSortKeys(sortKeys);
        this.sortOrder = this.sorter.getSortedIndices(this.project);
        this.updateMappings();
    }

    void clearMask() {
        this.maskedViewIndices.clear();
        this.maskedModelIndices = null;
    }

    private Dataset getOriginalDataset() {
        Dataset originalDataset = this.project.getOriginalDataset();
        return this.isRows ? originalDataset : DatasetUtil.transposeView(originalDataset);
    }

    private void updateViewMaskFromModel() {
        if (this.maskedViewIndices != null) {
            this.maskedViewIndices.clear();
        }
        if (this.maskedModelIndices != null) {
            if (this.maskedViewIndices == null) {
                this.maskedViewIndices = new TIntHashSet();
            }
            for (int modelIndex : this.maskedModelIndices) {
                int viewIndex = this.convertModelIndexToView(modelIndex);
                this.maskedViewIndices.add(viewIndex);
            }
        }
    }

    private static int[] removeMaskedIndices(int[] viewIndices, TIntHashSet viewMask, int count) {
        TIntArrayList indicesToKeep = new TIntArrayList();
        if (viewIndices != null) {
            for (int viewIndex : viewIndices) {
                if (viewMask.contains(viewIndex)) continue;
                indicesToKeep.add(viewIndex);
            }
        } else {
            for (int i = 0; i < count; ++i) {
                if (viewMask.contains(i)) continue;
                indicesToKeep.add(i);
            }
        }
        return indicesToKeep.toArray();
    }
}

