/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import java.util.regex.Pattern;
import javax.swing.ListModel;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.Version;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.rankedlist.RankedList;
import org.broadinstitute.genee.table.FilterableTableModel;

public class LuceneSearchParser {
    public static final int CONTAINS = 0;
    public static final int ENDS_WITH = 2;
    public static final int EXACT_MATCH = 3;
    public static final int STARTS_WITH = 1;

    public static boolean accept(Object value, InternalSearchPredicate internalSearchPredicate) {
        if (!internalSearchPredicate.isNumber()) {
            if (value != null) {
                value = value.toString();
            }
        } else if (!(value instanceof Number)) {
            value = null;
        }
        return value != null && internalSearchPredicate.accept(value);
    }

    public static IndexedSearchPredicate parse(SearchPredicateAdapterCreator searchPredicateAdapterCreator, String queryString, boolean caseSensitive, boolean or, int matchMode, String defaultFilterColumnName) {
        Query query;
        WhitespaceAnalyzer analyzer = new WhitespaceAnalyzer(Version.LUCENE_36);
        QueryParser luceneParser = new QueryParser(Version.LUCENE_36, "", (Analyzer)analyzer);
        luceneParser.setDefaultOperator(or ? QueryParser.Operator.OR : QueryParser.Operator.AND);
        luceneParser.setAllowLeadingWildcard(true);
        try {
            queryString = LuceneSearchParser.replace(queryString);
            query = luceneParser.parse(queryString);
        }
        catch (Exception e) {
            return new AlwaysFalse();
        }
        IndexedSearchPredicate predicate = null;
        if (query instanceof BooleanQuery) {
            BooleanClause[] clauses;
            BooleanQuery q = (BooleanQuery)query;
            for (BooleanClause clause : clauses = q.getClauses()) {
                IndexedSearchPredicate parsedPredicate = searchPredicateAdapterCreator.create(LuceneSearchParser.handleQuery(clause.getQuery(), caseSensitive, matchMode, defaultFilterColumnName));
                if (predicate == null) {
                    if (clause.getOccur().equals((Object)BooleanClause.Occur.MUST_NOT)) {
                        predicate = new NotSearchPredicate(parsedPredicate);
                        continue;
                    }
                    predicate = parsedPredicate;
                    continue;
                }
                if (clause.getOccur().equals((Object)BooleanClause.Occur.SHOULD)) {
                    predicate = new OrSearchPredicate(predicate, parsedPredicate);
                    continue;
                }
                if (clause.getOccur().equals((Object)BooleanClause.Occur.MUST)) {
                    predicate = new AndSearchPredicate(predicate, parsedPredicate);
                    continue;
                }
                if (clause.getOccur().equals((Object)BooleanClause.Occur.MUST_NOT)) {
                    predicate = new AndSearchPredicate(predicate, new NotSearchPredicate(parsedPredicate));
                    continue;
                }
                System.out.println("not handled: " + clause.getOccur());
            }
        } else {
            predicate = searchPredicateAdapterCreator.create(LuceneSearchParser.handleQuery(query, caseSensitive, matchMode, defaultFilterColumnName));
        }
        if (predicate == null) {
            System.out.println("Search: null predicate");
            return new AlwaysTrue();
        }
        return predicate;
    }

    public static String replace(String queryString) {
        queryString = queryString.replace(" OR ", " || ");
        queryString = queryString.replace(" or ", " || ");
        queryString = queryString.replace(" and ", " AND ");
        queryString = queryString.replace(" not ", " - ");
        queryString = queryString.replace(" NOT ", " - ");
        return queryString;
    }

    private static String getField(String field, String defaultFilterColumnName) {
        return field == null || field.equals("") ? defaultFilterColumnName : field;
    }

    private static InternalSearchPredicate handleQuery(Query query, boolean caseSensitive, int matchMode, String defaultFilterColumnName) {
        if (query instanceof BooleanQuery) {
            BooleanQuery q = (BooleanQuery)query;
            BooleanClause[] clauses = q.getClauses();
            InternalSearchPredicate[] internalPredicates = new InternalSearchPredicate[clauses.length];
            int length = clauses.length;
            for (int i = 0; i < length; ++i) {
                internalPredicates[i] = LuceneSearchParser.handleQuery(clauses[i].getQuery(), caseSensitive, matchMode, defaultFilterColumnName);
            }
            return new BooleanInternalSearchPredicate(internalPredicates, defaultFilterColumnName);
        }
        if (query instanceof NumericRangeQuery) {
            NumericRangeQuery q = (NumericRangeQuery)query;
            String field = LuceneSearchParser.getField(q.getField(), defaultFilterColumnName);
            return new NumberRangeInternalSearchPredicate(field, q.getMin().floatValue(), q.includesMin(), q.getMax().floatValue(), q.includesMax());
        }
        if (query instanceof TermRangeQuery) {
            TermRangeQuery q = (TermRangeQuery)query;
            String field = LuceneSearchParser.getField(q.getField(), defaultFilterColumnName);
            try {
                return new NumberRangeInternalSearchPredicate(field, ParserHelper.parseFloat(q.getLowerTerm()), q.includesLower(), ParserHelper.parseFloat(q.getUpperTerm()), q.includesUpper());
            }
            catch (Exception x) {
                System.out.println("query not handled.");
                return null;
            }
        }
        if (query instanceof TermQuery) {
            TermQuery q = (TermQuery)query;
            String text = q.getTerm().text();
            if (matchMode == 1) {
                return new StartsWithPredicate(LuceneSearchParser.getField(q.getTerm().field(), defaultFilterColumnName), text, caseSensitive);
            }
            if (matchMode == 0) {
                return new ContainsPredicate(LuceneSearchParser.getField(q.getTerm().field(), defaultFilterColumnName), text, caseSensitive);
            }
            if (matchMode == 2) {
                return new EndsWithPredicate(LuceneSearchParser.getField(q.getTerm().field(), defaultFilterColumnName), text, caseSensitive);
            }
            return new MyExactTermQuery(LuceneSearchParser.getField(q.getTerm().field(), defaultFilterColumnName), text, caseSensitive);
        }
        if (query instanceof PrefixQuery) {
            PrefixQuery q = (PrefixQuery)query;
            String text = q.getPrefix().text();
            return new StartsWithPredicate(LuceneSearchParser.getField(q.getPrefix().field(), defaultFilterColumnName), text, caseSensitive);
        }
        if (query instanceof WildcardQuery) {
            WildcardQuery q = (WildcardQuery)query;
            String text = q.getTerm().text();
            return new MyWildcardQuery(LuceneSearchParser.getField(q.getTerm().field(), defaultFilterColumnName), text, caseSensitive);
        }
        if (query instanceof PhraseQuery) {
            PhraseQuery q = (PhraseQuery)query;
            Term[] terms = q.getTerms();
            StringBuilder buf = new StringBuilder();
            int length = terms.length;
            for (int i = 0; i < length; ++i) {
                Term t = terms[i];
                if (i > 0) {
                    buf.append(" ");
                }
                buf.append(t.text());
            }
            String text = buf.toString();
            return new MyExactTermQuery(LuceneSearchParser.getField(q.getTerms()[0].field(), defaultFilterColumnName), text, caseSensitive);
        }
        System.out.println("Not handled: " + query.getClass());
        return null;
    }

    static {
        BooleanQuery.setMaxClauseCount((int)Integer.MAX_VALUE);
    }

    private static class StartsWithPredicate
    implements InternalSearchPredicate {
        private boolean caseSensitive;
        private String field;
        private String prefix;

        public StartsWithPredicate(String field, String prefix, boolean caseSensitive) {
            this.field = field;
            this.caseSensitive = caseSensitive;
            if (!caseSensitive) {
                prefix = prefix.toLowerCase();
            }
            this.prefix = prefix;
        }

        @Override
        public boolean accept(Object value) {
            String s = (String)value;
            return this.caseSensitive ? s.startsWith(this.prefix) : s.toLowerCase().startsWith(this.prefix);
        }

        @Override
        public String getField() {
            return this.field;
        }

        @Override
        public boolean isNumber() {
            return false;
        }

        public String toString() {
            return this.prefix;
        }
    }

    private static class OrSearchPredicate
    implements IndexedSearchPredicate {
        private IndexedSearchPredicate p1;
        private IndexedSearchPredicate p2;

        public OrSearchPredicate(IndexedSearchPredicate p1, IndexedSearchPredicate p2) {
            this.p1 = p1;
            this.p2 = p2;
        }

        @Override
        public boolean accept(int index) {
            return this.p1.accept(index) || this.p2.accept(index);
        }

        @Override
        public void setData(Object data) {
            this.p1.setData(data);
            this.p2.setData(data);
        }
    }

    private static class NumberRangeInternalSearchPredicate
    implements InternalSearchPredicate {
        private String field;
        private boolean includesMax;
        private boolean includesMin;
        private float max;
        private float min;

        public NumberRangeInternalSearchPredicate(String field, float min, boolean includesMin, float max, boolean includesMax) {
            this.field = field;
            this.min = min;
            this.includesMin = includesMin;
            this.max = max;
            this.includesMax = includesMax;
        }

        @Override
        public boolean accept(Object value) {
            float f = ((Number)value).floatValue();
            return (this.includesMin ? f >= this.min : f > this.min) && (this.includesMax ? f <= this.max : f < this.max);
        }

        @Override
        public String getField() {
            return this.field;
        }

        @Override
        public boolean isNumber() {
            return true;
        }

        public String toString() {
            return this.min + " " + this.max;
        }
    }

    private static class NotSearchPredicate
    implements IndexedSearchPredicate {
        private IndexedSearchPredicate p1;

        public NotSearchPredicate(IndexedSearchPredicate p1) {
            this.p1 = p1;
        }

        @Override
        public boolean accept(int index) {
            return !this.p1.accept(index);
        }

        @Override
        public void setData(Object data) {
            this.p1.setData(data);
        }
    }

    private static class MyWildcardQuery
    implements InternalSearchPredicate {
        private String field;
        private Pattern pattern;
        private String text;

        public MyWildcardQuery(String field, String text, boolean caseSensitive) {
            this.field = field;
            this.text = text;
            String patternText = text.replace("*", ".*");
            if (!patternText.endsWith(".*")) {
                patternText = patternText + ".*";
            }
            this.pattern = !caseSensitive ? Pattern.compile(patternText, 2) : Pattern.compile(patternText);
        }

        @Override
        public boolean accept(Object value) {
            String s = (String)value;
            return this.pattern.matcher(s).matches();
        }

        @Override
        public String getField() {
            return this.field;
        }

        @Override
        public boolean isNumber() {
            return false;
        }

        public String toString() {
            return this.text;
        }
    }

    private static class MyExactTermQuery
    implements InternalSearchPredicate {
        private boolean caseSensitive;
        private String field;
        private String term;

        public MyExactTermQuery(String field, String term, boolean caseSensitive) {
            this.field = field;
            if (!caseSensitive) {
                term = term.toLowerCase();
            }
            this.term = term;
            this.caseSensitive = caseSensitive;
        }

        @Override
        public boolean accept(Object value) {
            String s = (String)value;
            return this.caseSensitive ? s.equals(this.term) : s.toLowerCase().equals(this.term);
        }

        @Override
        public String getField() {
            return this.field;
        }

        @Override
        public boolean isNumber() {
            return false;
        }

        public String toString() {
            return this.term;
        }
    }

    private static class EndsWithPredicate
    implements InternalSearchPredicate {
        private boolean caseSensitive;
        private String field;
        private String suffix;

        public EndsWithPredicate(String field, String suffix, boolean caseSensitive) {
            this.field = field;
            this.caseSensitive = caseSensitive;
            if (!caseSensitive) {
                suffix = suffix.toLowerCase();
            }
            this.suffix = suffix;
        }

        @Override
        public boolean accept(Object value) {
            String s = (String)value;
            return this.caseSensitive ? s.endsWith(this.suffix) : s.toLowerCase().endsWith(this.suffix);
        }

        @Override
        public String getField() {
            return this.field;
        }

        @Override
        public boolean isNumber() {
            return false;
        }

        public String toString() {
            return this.suffix;
        }
    }

    private static class ContainsPredicate
    implements InternalSearchPredicate {
        private boolean caseSensitive;
        private String field;
        private String text;

        public ContainsPredicate(String field, String text, boolean caseSensitive) {
            this.field = field;
            this.caseSensitive = caseSensitive;
            if (!caseSensitive) {
                text = text.toLowerCase();
            }
            this.text = text;
        }

        @Override
        public boolean accept(Object value) {
            String s = (String)value;
            return this.caseSensitive ? s.indexOf(this.text) != -1 : s.toLowerCase().indexOf(this.text) != -1;
        }

        @Override
        public String getField() {
            return this.field;
        }

        @Override
        public boolean isNumber() {
            return false;
        }

        public String toString() {
            return this.text;
        }
    }

    private static class AlwaysTrue
    implements IndexedSearchPredicate {
        private AlwaysTrue() {
        }

        @Override
        public boolean accept(int index) {
            return true;
        }

        @Override
        public void setData(Object data) {
        }
    }

    public static interface SearchPredicateAdapterCreator {
        public IndexedSearchPredicate create(InternalSearchPredicate var1);
    }

    public static class RankedListSearchPredicateAdapter
    extends MetadataSearchPredicateAdapter {
        private RankedList rankedList;

        public RankedListSearchPredicateAdapter(InternalSearchPredicate internalSearchPredicate) {
            super(internalSearchPredicate);
        }

        @Override
        public void setData(Object data) {
            this.rankedList = (RankedList)data;
            this.metadataModel = this.rankedList.getMetadata();
        }
    }

    public static abstract class MetadataSearchPredicateAdapter
    implements IndexedSearchPredicate {
        protected MetadataModel metadataModel;
        private boolean all;
        private InternalSearchPredicate internalSearchPredicate;

        public MetadataSearchPredicateAdapter(InternalSearchPredicate internalSearchPredicate) {
            this.internalSearchPredicate = internalSearchPredicate;
            String filterColumnName = internalSearchPredicate.getField();
            this.all = filterColumnName.equals("All");
        }

        @Override
        public boolean accept(int index) {
            if (this.all) {
                int ncols = this.metadataModel.getMetadataCount();
                for (int j = 0; j < ncols; ++j) {
                    boolean accept;
                    Vector vector = this.metadataModel.get(j);
                    Object value = null;
                    if (!this.internalSearchPredicate.isNumber()) {
                        value = vector.getValue(index);
                        if (value != null) {
                            value = value.toString();
                        }
                    } else if (this.internalSearchPredicate.isNumber() && Number.class.isAssignableFrom(this.metadataModel.get(j).getColumnClass())) {
                        value = vector.getValue(index);
                    }
                    boolean bl = accept = value != null ? this.internalSearchPredicate.accept(value) : false;
                    if (!accept) continue;
                    return true;
                }
            } else {
                String filterColumnName = this.internalSearchPredicate.getField();
                int metadataColumnIndex = this.metadataModel.getColumnIndex(filterColumnName);
                Object value = this.metadataModel.getValue(index, metadataColumnIndex);
                return LuceneSearchParser.accept(value, this.internalSearchPredicate);
            }
            return false;
        }
    }

    public static class ListModelSearchPredicateAdapter
    implements IndexedSearchPredicate {
        private InternalSearchPredicate filter;
        private ListModel listModel;

        public ListModelSearchPredicateAdapter(InternalSearchPredicate filter) {
            this.filter = filter;
        }

        @Override
        public boolean accept(int index) {
            return this.filter.accept(String.valueOf(this.listModel.getElementAt(index)));
        }

        @Override
        public void setData(Object data) {
            this.listModel = (ListModel)data;
        }
    }

    public static interface InternalSearchPredicate {
        public boolean accept(Object var1);

        public String getField();

        public boolean isNumber();
    }

    public static interface IndexedSearchPredicate {
        public boolean accept(int var1);

        public void setData(Object var1);
    }

    public static class FilterableTableModelSearchPredicateAdapter
    implements IndexedSearchPredicate {
        private boolean all;
        private int columnIndex;
        private InternalSearchPredicate internalSearchPredicate;
        private FilterableTableModel tableModel;

        public FilterableTableModelSearchPredicateAdapter(InternalSearchPredicate filter) {
            this.internalSearchPredicate = filter;
            String filterColumnName = filter.getField();
            this.all = filterColumnName.equals("All");
        }

        @Override
        public boolean accept(int index) {
            if (this.all) {
                int ncols = this.tableModel.getColumnCount();
                for (int j = 0; j < ncols; ++j) {
                    boolean accept;
                    Object value = null;
                    if (!this.internalSearchPredicate.isNumber()) {
                        value = this.tableModel.getOriginalValueAt(index, j);
                        if (value != null) {
                            value = value.toString();
                        }
                    } else if (this.internalSearchPredicate.isNumber() && Number.class.isAssignableFrom(this.tableModel.getColumnClass(j))) {
                        value = this.tableModel.getOriginalValueAt(index, j);
                    }
                    boolean bl = accept = value != null ? this.internalSearchPredicate.accept(value) : false;
                    if (!accept) continue;
                    return true;
                }
            } else {
                Object value = null;
                if (!this.internalSearchPredicate.isNumber()) {
                    value = this.tableModel.getOriginalValueAt(index, this.columnIndex);
                    if (value != null) {
                        value = value.toString();
                    }
                } else if (this.internalSearchPredicate.isNumber() && Number.class.isAssignableFrom(this.tableModel.getColumnClass(this.columnIndex))) {
                    value = this.tableModel.getOriginalValueAt(index, this.columnIndex);
                }
                if (value != null && this.internalSearchPredicate.accept(value)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void setData(Object data) {
            this.tableModel = (FilterableTableModel)data;
            if (!this.all) {
                this.columnIndex = -1;
                int cc = this.tableModel.getColumnCount();
                for (int j = 0; j < cc; ++j) {
                    if (!this.internalSearchPredicate.getField().equals(this.tableModel.getColumnName(j))) continue;
                    this.columnIndex = j;
                    break;
                }
            }
        }
    }

    public static class DatasetSearchPredicateAdapter
    implements IndexedSearchPredicate {
        private boolean all;
        private Dataset dataset;
        private InternalSearchPredicate internalSearchPredicate;

        public DatasetSearchPredicateAdapter(InternalSearchPredicate internalSearchPredicate) {
            this.internalSearchPredicate = internalSearchPredicate;
            if (internalSearchPredicate == null) {
                throw new NullPointerException("Search predicate is null");
            }
            String filterColumnName = internalSearchPredicate.getField();
            this.all = "All".equals(filterColumnName);
        }

        @Override
        public boolean accept(int index) {
            MetadataModel metadata = this.dataset.getRowMetadata();
            if (this.all) {
                int nmetadata = metadata.getMetadataCount();
                for (int j = 0; j < nmetadata; ++j) {
                    boolean accept;
                    Vector vector = metadata.get(j);
                    Object value = null;
                    if (!this.internalSearchPredicate.isNumber()) {
                        value = vector.getValue(index);
                        if (value != null) {
                            value = value.toString();
                        }
                    } else if (this.internalSearchPredicate.isNumber() && Number.class.isAssignableFrom(vector.getColumnClass())) {
                        value = vector.getValue(index);
                    }
                    boolean bl = accept = value != null ? this.internalSearchPredicate.accept(value) : false;
                    if (!accept) continue;
                    return true;
                }
            } else {
                String filterColumnName = this.internalSearchPredicate.getField();
                Vector vector = metadata.get(filterColumnName);
                if (vector == null) {
                    if ("#".equals(filterColumnName) && this.internalSearchPredicate.isNumber()) {
                        return this.internalSearchPredicate.accept(index + 1);
                    }
                    return false;
                }
                Object value = null;
                if (!this.internalSearchPredicate.isNumber()) {
                    value = vector.getValue(index);
                    if (value != null) {
                        value = value.toString();
                    }
                } else if (this.internalSearchPredicate.isNumber() && Number.class.isAssignableFrom(vector.getColumnClass())) {
                    value = vector.getValue(index);
                }
                if (value != null && this.internalSearchPredicate.accept(value)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void setData(Object data) {
            this.dataset = (Dataset)data;
        }
    }

    public static class BooleanInternalSearchPredicate
    implements InternalSearchPredicate {
        private String field;
        private boolean isNumber;
        private InternalSearchPredicate[] predicates;

        public BooleanInternalSearchPredicate(InternalSearchPredicate[] predicates, String field) {
            this.predicates = predicates;
            this.field = field;
            this.isNumber = false;
            for (InternalSearchPredicate p : predicates) {
                if (!p.isNumber()) continue;
                this.isNumber = true;
                break;
            }
        }

        @Override
        public boolean accept(Object value) {
            for (InternalSearchPredicate p : this.predicates) {
                if (!p.accept(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getField() {
            return this.field;
        }

        @Override
        public boolean isNumber() {
            return this.isNumber;
        }
    }

    public static class AndSearchPredicate
    implements IndexedSearchPredicate {
        private IndexedSearchPredicate p1;
        private IndexedSearchPredicate p2;

        public AndSearchPredicate(IndexedSearchPredicate p1, IndexedSearchPredicate p2) {
            this.p1 = p1;
            this.p2 = p2;
        }

        @Override
        public boolean accept(int index) {
            return this.p1.accept(index) && this.p2.accept(index);
        }

        @Override
        public void setData(Object data) {
            this.p1.setData(data);
            this.p2.setData(data);
        }
    }

    public static class AlwaysFalse
    implements IndexedSearchPredicate {
        @Override
        public boolean accept(int index) {
            return false;
        }

        @Override
        public void setData(Object data) {
        }
    }
}

